/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageTierUpgradeItem
extends ItemBase {
    private final TierUpgrade tier;
    private final boolean hasTooltip;

    public StorageTierUpgradeItem(TierUpgrade tier) {
        this(tier, false);
    }

    public StorageTierUpgradeItem(TierUpgrade tier, boolean hasTooltip) {
        super(new Item.Properties(), SophisticatedStorage.CREATIVE_TAB);
        this.tier = tier;
        this.hasTooltip = hasTooltip;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (this.hasTooltip) {
            tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.m_41720_().m_5524_() + ".tooltip", null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        return this.tryUpgradeStorage(stack, level, pos, state, player);
    }

    public InteractionResult tryUpgradeStorage(ItemStack stack, Level level, BlockPos pos, BlockState state, @Nullable Player player) {
        return this.tier.getBlockUpgradeDefinition(state.m_60734_()).map(def -> WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, def.blockEntityClass()).map(be -> this.tryUpgradeStorage(stack, pos, level, state, (TierUpgradeDefinition)def, (BlockEntity)be, player)).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS);
    }

    private <B extends BlockEntity> InteractionResult tryUpgradeStorage(ItemStack stack, BlockPos pos, Level level, BlockState state, TierUpgradeDefinition<B> def, BlockEntity blockEntity, @Nullable Player player) {
        BlockEntity be = (BlockEntity)def.blockEntityClass().cast(blockEntity);
        if (def.isUpgradingBlocked().test(be)) {
            return InteractionResult.PASS;
        }
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!def.upgradeStorage(player, pos, level, state, be)) {
            return InteractionResult.PASS;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    private static Map<Block, TierUpgradeDefinition<?>> getVanillaShulkerBoxTierUpgradeDefinitions(net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock toShulkerBox) {
        return new ImmutableMap.Builder().put((Object)Blocks.f_50456_, new VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity>(ShulkerBoxBlockEntity.class, shulkerBoxBlockEntity -> shulkerBoxBlockEntity.f_59646_ > 0, (StorageBlockBase)toShulkerBox, null, new Property[]{ShulkerBoxBlock.f_56183_})).put((Object)Blocks.f_50457_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.WHITE, toShulkerBox)).put((Object)Blocks.f_50458_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.ORANGE, toShulkerBox)).put((Object)Blocks.f_50459_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.MAGENTA, toShulkerBox)).put((Object)Blocks.f_50460_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_BLUE, toShulkerBox)).put((Object)Blocks.f_50461_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.YELLOW, toShulkerBox)).put((Object)Blocks.f_50462_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIME, toShulkerBox)).put((Object)Blocks.f_50463_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PINK, toShulkerBox)).put((Object)Blocks.f_50464_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GRAY, toShulkerBox)).put((Object)Blocks.f_50465_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_GRAY, toShulkerBox)).put((Object)Blocks.f_50466_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.CYAN, toShulkerBox)).put((Object)Blocks.f_50520_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PURPLE, toShulkerBox)).put((Object)Blocks.f_50521_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLUE, toShulkerBox)).put((Object)Blocks.f_50522_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BROWN, toShulkerBox)).put((Object)Blocks.f_50523_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GREEN, toShulkerBox)).put((Object)Blocks.f_50524_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.RED, toShulkerBox)).put((Object)Blocks.f_50525_, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLACK, toShulkerBox)).build();
    }

    public static enum TierUpgrade {
        BASIC(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.BARREL.get(), WoodType.f_61831_, new Property[]{BlockStateProperties.f_61372_})).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, chestBlockEntity -> chestBlockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.CHEST.get(), WoodType.f_61830_, new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions((net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.SHULKER_BOX.get())).build())),
        BASIC_TO_COPPER(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.COPPER_BARREL.get(), WoodType.f_61831_, new Property[]{BlockStateProperties.f_61372_})).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.COPPER_CHEST.get(), WoodType.f_61830_, new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions((net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.COPPER_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.COPPER_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.COPPER_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.COPPER_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_COPPER_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_COPPER_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_COPPER_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_COPPER_BARREL_4.get())).build())),
        BASIC_TO_IRON(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.IRON_BARREL.get(), WoodType.f_61831_, new Property[]{BlockStateProperties.f_61372_})).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.IRON_CHEST.get(), WoodType.f_61830_, new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions((net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.IRON_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.IRON_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.IRON_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.IRON_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_4.get())).build())),
        BASIC_TO_GOLD(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.GOLD_BARREL.get(), WoodType.f_61831_, new Property[]{BlockStateProperties.f_61372_})).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.GOLD_CHEST.get(), WoodType.f_61830_, new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions((net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.GOLD_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_4.get())).build())),
        BASIC_TO_DIAMOND(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.DIAMOND_BARREL.get(), WoodType.f_61831_, new Property[]{BlockStateProperties.f_61372_})).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.DIAMOND_CHEST.get(), WoodType.f_61830_, new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions((net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.DIAMOND_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_4.get())).build())),
        BASIC_TO_NETHERITE(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.f_50618_, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.f_155050_.m_155450_() > 0, (StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), WoodType.f_61831_, new Property[]{BlockStateProperties.f_61372_})).put((Object)Blocks.f_50087_, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.f_155324_.m_155450_() > 0, (StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), WoodType.f_61830_, new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61362_})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions((net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock)ModBlocks.NETHERITE_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_4.get())).build())),
        COPPER_TO_IRON(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.IRON_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.IRON_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.IRON_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_IRON_BARREL_4.get())).build())),
        COPPER_TO_GOLD(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_4.get())).build())),
        COPPER_TO_DIAMOND(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_4.get())).build())),
        COPPER_TO_NETHERITE(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_4.get())).build())),
        IRON_TO_GOLD(Map.of((Block)ModBlocks.IRON_BARREL.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.IRON_CHEST.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_}), (Block)ModBlocks.IRON_SHULKER_BOX.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.GOLD_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_}), (Block)ModBlocks.LIMITED_IRON_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_1.get()), (Block)ModBlocks.LIMITED_IRON_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_2.get()), (Block)ModBlocks.LIMITED_IRON_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_3.get()), (Block)ModBlocks.LIMITED_IRON_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_GOLD_BARREL_4.get()))),
        IRON_TO_DIAMOND(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.IRON_BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.IRON_CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.IRON_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_4.get())).build())),
        IRON_TO_NETHERITE(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.IRON_BARREL.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.IRON_CHEST.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_})).put((Object)((Block)ModBlocks.IRON_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_})).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_4.get())).build())),
        GOLD_TO_DIAMOND(Map.of((Block)ModBlocks.GOLD_BARREL.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.GOLD_CHEST.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_}), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_}), (Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_1.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_2.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_3.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_DIAMOND_BARREL_4.get()))),
        GOLD_TO_NETHERITE(Map.of((Block)ModBlocks.GOLD_BARREL.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.GOLD_CHEST.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_}), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_}), (Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_1.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_2.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_3.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_4.get()))),
        DIAMOND_TO_NETHERITE(Map.of((Block)ModBlocks.DIAMOND_BARREL.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.f_61372_, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.DIAMOND_CHEST.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.f_61374_, StorageBlockBase.TICKING, BlockStateProperties.f_61362_}), (Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), new StorageTierUpgradeDefinition((StorageBlockBase)ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.f_61372_}), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_1.get()), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_2.get()), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_3.get()), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition((StorageBlockBase)ModBlocks.LIMITED_NETHERITE_BARREL_4.get())));

        private final Map<Block, TierUpgradeDefinition<?>> blockUpgradeDefinitions;

        private TierUpgrade(Map<Block, TierUpgradeDefinition<?>> blockUpgradeDefinitions) {
            this.blockUpgradeDefinitions = blockUpgradeDefinitions;
        }

        public void addTierUpgradeDefinition(Block block, VanillaTierUpgradeDefinition<?> tierUpgradeDefinition) {
            this.blockUpgradeDefinitions.put(block, tierUpgradeDefinition);
        }

        private Optional<TierUpgradeDefinition<?>> getBlockUpgradeDefinition(Block block) {
            return Optional.ofNullable(this.blockUpgradeDefinitions.get(block));
        }
    }

    private static abstract class TierUpgradeDefinition<B extends BlockEntity> {
        private final List<Property<?>> propertiesToCopy;
        private final Class<B> blockEntityClass;
        private final Predicate<B> isUpgradingBlocked;
        private final StorageBlockBase newBlock;

        private TierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, Property<?> ... propertiesToCopy) {
            this.propertiesToCopy = Arrays.stream(propertiesToCopy).toList();
            this.blockEntityClass = blockEntityClass;
            this.isUpgradingBlocked = isUpgradingBlocked;
            this.newBlock = newBlock;
        }

        public List<Property<?>> getPropertiesToCopy() {
            return this.propertiesToCopy;
        }

        public Class<B> blockEntityClass() {
            return this.blockEntityClass;
        }

        public Predicate<B> isUpgradingBlocked() {
            return this.isUpgradingBlocked;
        }

        public StorageBlockBase newBlock() {
            return this.newBlock;
        }

        abstract boolean upgradeStorage(@Nullable Player var1, BlockPos var2, Level var3, BlockState var4, B var5);

        protected BlockState getBlockState(BlockState state) {
            BlockState newBlockState = this.newBlock().m_49966_();
            for (Property<?> property : this.getPropertiesToCopy()) {
                newBlockState = this.setProperty(newBlockState, state, property);
            }
            return newBlockState;
        }

        private <T extends Comparable<T>> BlockState setProperty(BlockState newBlockState, BlockState state, Property<T> property) {
            return (BlockState)newBlockState.m_61124_(property, state.m_61143_(property));
        }
    }

    public static class VanillaTierUpgradeDefinition<B extends RandomizableContainerBlockEntity>
    extends TierUpgradeDefinition<B> {
        @Nullable
        private final WoodType woodType;
        private final int color;

        public VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, Property<?> ... propertiesToCopy) {
            this(blockEntityClass, isUpgradingBlocked, newBlock, woodType, -1, propertiesToCopy);
        }

        private VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, DyeColor color, Property<?> ... propertiesToCopy) {
            this(blockEntityClass, isUpgradingBlocked, newBlock, woodType, ColorHelper.getColor((float[])color.m_41068_()), propertiesToCopy);
        }

        private VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, int color, Property<?> ... propertiesToCopy) {
            super(blockEntityClass, isUpgradingBlocked, newBlock, propertiesToCopy);
            this.woodType = woodType;
            this.color = color;
        }

        @Nullable
        public WoodType woodType() {
            return this.woodType;
        }

        @Override
        boolean upgradeStorage(@Nullable Player player, BlockPos pos, Level level, BlockState state, B be) {
            if (player == null || !be.m_7525_(player)) {
                return false;
            }
            Component customName = be.m_7770_();
            NonNullList items = NonNullList.m_122779_();
            for (int slot = 0; slot < be.m_6643_(); ++slot) {
                items.add(slot, (Object)be.m_8020_(slot));
            }
            BlockState newBlockState = this.getBlockState(state);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            this.setStorageItemsNameAndWoodType(newBlockEntity, customName, (NonNullList<ItemStack>)items, this.woodType());
            newBlockEntity.setUpdateBlockRender();
            this.replaceBlockAndBlockEntity(newBlockState, newBlockEntity, pos, level);
            newBlockEntity.tryToAddToController();
            WorldHelper.notifyBlockUpdate((BlockEntity)newBlockEntity);
            return true;
        }

        private void replaceBlockAndBlockEntity(BlockState newBlockState, BlockEntity newBlockEntity, BlockPos pos, Level level) {
            level.m_46747_(pos);
            level.m_7471_(pos, false);
            level.m_7731_(pos, newBlockState, 3);
            level.m_151523_(newBlockEntity);
        }

        private void setStorageItemsNameAndWoodType(StorageBlockEntity newBe, @Nullable Component customName, NonNullList<ItemStack> items, @Nullable WoodType woodType) {
            StorageWrapper storageWrapper;
            InventoryHandler inventoryHandler;
            if (customName != null) {
                newBe.setCustomName(customName);
            }
            if ((inventoryHandler = (storageWrapper = newBe.getStorageWrapper()).getInventoryHandler()).getSlots() < items.size()) {
                inventoryHandler.setSize(items.size());
            }
            for (int slot = 0; slot < items.size(); ++slot) {
                inventoryHandler.setStackInSlot(slot, (ItemStack)items.get(slot));
            }
            if (woodType != null && newBe instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)newBe;
                wbe.setWoodType(woodType);
            }
            if (this.color > -1) {
                storageWrapper.setMainColor(this.color);
                storageWrapper.setAccentColor(this.color);
            }
        }
    }

    private static class VanillaTintedShulkerBoxTierUpgradeDefinition
    extends VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity> {
        private VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor color, net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock newBlock) {
            super(ShulkerBoxBlockEntity.class, (B shulkerBoxBlockEntity) -> shulkerBoxBlockEntity.f_59646_ > 0, (StorageBlockBase)newBlock, null, color, new Property[]{ShulkerBoxBlock.f_56183_, StorageBlockBase.TICKING});
        }
    }

    private static class LimitedBarrelTierUpgradeDefinition
    extends StorageTierUpgradeDefinition {
        private LimitedBarrelTierUpgradeDefinition(StorageBlockBase newBlock) {
            super(newBlock, new Property[]{LimitedBarrelBlock.HORIZONTAL_FACING, LimitedBarrelBlock.VERTICAL_FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP});
        }
    }

    private static class StorageTierUpgradeDefinition
    extends TierUpgradeDefinition<StorageBlockEntity> {
        private StorageTierUpgradeDefinition(StorageBlockBase newBlock, Property<?> ... propertiesToCopy) {
            super(StorageBlockEntity.class, (B storageBlockEntity) -> {
                WoodStorageBlockEntity wbe;
                return storageBlockEntity.isOpen() || storageBlockEntity instanceof WoodStorageBlockEntity && (wbe = (WoodStorageBlockEntity)storageBlockEntity).isPacked();
            }, newBlock, propertiesToCopy);
        }

        @Override
        boolean upgradeStorage(@Nullable Player player, BlockPos pos, Level level, BlockState state, StorageBlockEntity blockEntity) {
            CompoundTag beTag = new CompoundTag();
            blockEntity.m_183515_(beTag);
            BlockState newBlockState = this.getBlockState(state);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            int newInventorySize = newBlockEntity.getStorageWrapper().getInventoryHandler().getSlots();
            int newUpgradeSize = newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlots();
            newBlockEntity.m_142466_(beTag);
            blockEntity.setBeingUpgraded();
            level.m_46747_(pos);
            level.m_7471_(pos, false);
            level.m_7731_(pos, newBlockState, 3);
            level.m_151523_((BlockEntity)newBlockEntity);
            newBlockEntity.increaseStorageSize(newInventorySize - newBlockEntity.getStorageWrapper().getInventoryHandler().getSlots(), newUpgradeSize - newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlots());
            WorldHelper.notifyBlockUpdate((BlockEntity)newBlockEntity);
            return true;
        }
    }
}

