/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.sparsestructuresreforged;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class SSRMixinPlugin
implements IMixinConfigPlugin {
    static boolean initFailed;
    static Throwable exceptionOnWriteFile;
    static Throwable exceptionOnReadFile;
    public static double extraSpacingPercentage;
    public static double extraSeparationPercentage;

    public SSRMixinPlugin() {
        File config = new File(FMLLoader.getGamePath().toFile(), "config");
        config.mkdirs();
        File configFile = new File(config, "sparsetructuresreforged.json");
        if (!configFile.exists()) {
            try {
                FileWriter fileWriter = SSRMixinPlugin.writeFile(configFile);
                fileWriter.close();
            }
            catch (Exception e) {
                initFailed = true;
                exceptionOnWriteFile = e;
            }
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            JsonObject jsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
            extraSpacingPercentage = jsonObject.get("extraSpacingPercentage").getAsDouble();
            extraSeparationPercentage = jsonObject.get("extraSeparationPercentage").getAsDouble();
        }
        catch (Exception e) {
            initFailed = true;
            exceptionOnReadFile = e;
        }
    }

    @NotNull
    private static FileWriter writeFile(File configFile) throws IOException {
        JsonObject defaultConfig = new JsonObject();
        defaultConfig.addProperty("extraSpacingPercentage", (Number)0.8);
        defaultConfig.addProperty("extraSeparationPercentage", (Number)0.8);
        FileWriter writer = new FileWriter(configFile);
        writer.write(defaultConfig.toString());
        return writer;
    }

    public void onLoad(String s) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String s, String s1) {
        return true;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

