/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.jei.ingredients;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityIngredient {
    @Nullable
    private final Entity entity;
    private final EntityType<?> entityType;
    private final Optional<CompoundTag> nbt;
    private final float rotation;

    public EntityIngredient(EntityType<?> entityType, float rotation) {
        this(entityType, rotation, Optional.empty());
    }

    public EntityIngredient(EntityType<?> entityType, float rotation, Optional<CompoundTag> nbt) {
        this.rotation = rotation;
        this.entityType = entityType;
        this.nbt = nbt;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            this.entity = this.entityType.m_20615_((Level)mc.f_91073_);
            if (this.entity != null) {
                nbt.ifPresent(arg_0 -> ((Entity)this.entity).m_20258_(arg_0));
            }
        } else {
            this.entity = null;
        }
    }

    public float getRotation() {
        return this.rotation;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public Optional<CompoundTag> getNbt() {
        return this.nbt;
    }

    public Component getDisplayName() {
        return this.entity == null ? this.entityType.m_20676_() : this.entity.m_5446_();
    }

    public List<Component> getTooltip() {
        ResourceLocation key;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (this.entity != null && Minecraft.m_91087_().f_91066_.f_92125_ && (key = Registry.f_122826_.m_7981_(this.entityType)) != null) {
            tooltip.add((Component)Component.m_237113_((String)key.toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public String toString() {
        ResourceLocation key = Registry.f_122826_.m_7981_(this.entityType);
        return key != null ? key.toString() : this.entityType.toString();
    }
}

