/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.codexadrian.spirit.blocks.blockentity.PedestalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RecipeUtils {
    public static final BlockPos[] CARDINAL_BLOCK_POSITIONS = new BlockPos[]{new BlockPos(0, 0, 3), new BlockPos(0, 0, -3), new BlockPos(3, 0, 0), new BlockPos(-3, 0, 0), new BlockPos(2, 0, 2), new BlockPos(-2, 0, 2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, -2)};

    public static boolean validatePedestals(BlockPos blockPos, Level level, List<Ingredient> recipeIngredients, boolean consumeItems) {
        HashMap<BlockPos, ItemStack> ingredients = new HashMap<BlockPos, ItemStack>();
        HashMap<BlockPos, ItemStack> markedIngredients = new HashMap<BlockPos, ItemStack>();
        for (BlockPos cardinalPos : CARDINAL_BLOCK_POSITIONS) {
            PedestalBlockEntity pedestal;
            BlockPos offset = blockPos.m_121955_((Vec3i)cardinalPos).m_7949_();
            BlockEntity blockEntity = level.m_7702_(offset);
            if (!(blockEntity instanceof PedestalBlockEntity) || (pedestal = (PedestalBlockEntity)blockEntity).m_7983_()) continue;
            ingredients.put(offset, pedestal.m_8020_(0));
        }
        ingredients.forEach((pos, stack) -> {
            Optional<Ingredient> item = recipeIngredients.stream().filter(ingredient -> ingredient.test(stack)).findFirst();
            item.ifPresent(ingredient -> {
                recipeIngredients.remove(ingredient);
                markedIngredients.put((BlockPos)pos, (ItemStack)stack);
            });
        });
        if (!recipeIngredients.isEmpty()) {
            return false;
        }
        if (consumeItems) {
            markedIngredients.forEach((pos, stack) -> {
                BlockEntity patt2140$temp = level.m_7702_(pos);
                if (patt2140$temp instanceof PedestalBlockEntity) {
                    PedestalBlockEntity pedestal = (PedestalBlockEntity)patt2140$temp;
                    pedestal.m_8020_(0).m_41774_(1);
                    pedestal.update(3);
                }
            });
        }
        return true;
    }
}

