/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.inventory;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StarterKitAbstractContainerScreen<T extends class_1703>
extends class_437
implements class_3936<T> {
    public static final class_2960 INVENTORY_LOCATION = new class_2960("starterkit", "textures/gui/container/inventory.png");
    private static final float SNAPBACK_SPEED = 100.0f;
    private static final int QUICKDROP_DELAY = 500;
    public static final int SLOT_ITEM_BLIT_OFFSET = 100;
    private static final int HOVER_ITEM_BLIT_OFFSET = 200;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int titleLabelX;
    protected int titleLabelY;
    protected int inventoryLabelX;
    protected int inventoryLabelY;
    protected final T menu;
    protected final class_2561 playerInventoryTitle;
    @Nullable
    protected class_1735 hoveredSlot;
    @Nullable
    private class_1735 clickedSlot;
    @Nullable
    private class_1735 snapbackEnd;
    @Nullable
    private class_1735 quickdropSlot;
    @Nullable
    private class_1735 lastClickSlot;
    protected int leftPos;
    protected int topPos;
    private boolean isSplittingStack;
    private class_1799 draggingItem = class_1799.field_8037;
    private int snapbackStartX;
    private int snapbackStartY;
    private long snapbackTime;
    private class_1799 snapbackItem = class_1799.field_8037;
    private long quickdropTime;
    protected final Set<class_1735> quickCraftSlots = Sets.newHashSet();
    protected boolean isQuickCrafting;
    private int quickCraftingType;
    private int quickCraftingButton;
    private boolean skipNextRelease;
    private int quickCraftingRemainder;
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleclick;
    private class_1799 lastQuickMoved = class_1799.field_8037;

    public StarterKitAbstractContainerScreen(T abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(component);
        this.menu = abstractContainerMenu;
        this.playerInventoryTitle = inventory.method_5476();
        this.skipNextRelease = true;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
    }

    public void method_25394(@NotNull class_4587 poseStack, int i, int j, float f) {
        class_1799 itemStack;
        int o;
        int n;
        int k = this.leftPos;
        int l = this.topPos;
        this.renderBg(poseStack, f, i, j);
        RenderSystem.disableDepthTest();
        super.method_25394(poseStack, i, j, f);
        class_4587 poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.method_22903();
        poseStack2.method_22904((double)k, (double)l, 0.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.hoveredSlot = null;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int m = 0; m < ((class_1703)this.menu).field_7761.size(); ++m) {
            class_1735 slot = (class_1735)((class_1703)this.menu).field_7761.get(m);
            if (slot.method_7682()) {
                RenderSystem.setShader(class_757::method_34542);
                this.renderSlot(poseStack, slot);
            }
            if (!this.isHovering(slot, i, j) || !slot.method_7682()) continue;
            this.hoveredSlot = slot;
            n = slot.field_7873;
            o = slot.field_7872;
            StarterKitAbstractContainerScreen.renderSlotHighlight(poseStack, n, o, this.method_25305());
        }
        this.renderLabels(poseStack, i, j);
        class_1799 class_17992 = itemStack = this.draggingItem.method_7960() ? this.menu.method_34255() : this.draggingItem;
        if (!itemStack.method_7960()) {
            boolean p = true;
            n = this.draggingItem.method_7960() ? 8 : 16;
            String string = null;
            if (!this.draggingItem.method_7960() && this.isSplittingStack) {
                itemStack = itemStack.method_7972();
                itemStack.method_7939(class_3532.method_15386((float)((float)itemStack.method_7947() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1) {
                itemStack = itemStack.method_7972();
                itemStack.method_7939(this.quickCraftingRemainder);
                if (itemStack.method_7960()) {
                    string = class_124.field_1054 + "0";
                }
            }
            this.renderFloatingItem(itemStack, i - k - 8, j - l - n, string);
        }
        if (!this.snapbackItem.method_7960()) {
            float g = (float)(class_156.method_658() - this.snapbackTime) / 100.0f;
            if (g >= 1.0f) {
                g = 1.0f;
                this.snapbackItem = class_1799.field_8037;
            }
            n = this.snapbackEnd.field_7873 - this.snapbackStartX;
            o = this.snapbackEnd.field_7872 - this.snapbackStartY;
            int q = this.snapbackStartX + (int)((float)n * g);
            int r = this.snapbackStartY + (int)((float)o * g);
            this.renderFloatingItem(this.snapbackItem, q, r, null);
        }
        poseStack2.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
    }

    public static void renderSlotHighlight(class_4587 poseStack, int i, int j, int k) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        StarterKitAbstractContainerScreen.method_33284((class_4587)poseStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433, (int)-2130706433, (int)k);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void renderTooltip(class_4587 poseStack, int i, int j) {
        if (this.menu.method_34255().method_7960() && this.hoveredSlot != null && this.hoveredSlot.method_7681()) {
            this.method_25409(poseStack, this.hoveredSlot.method_7677(), i, j);
        }
    }

    private void renderFloatingItem(class_1799 itemStack, int i, int j, String string) {
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22904(0.0, 0.0, 32.0);
        RenderSystem.applyModelViewMatrix();
        this.method_25304(200);
        this.field_22788.field_4730 = 200.0f;
        this.field_22788.method_4023(itemStack, i, j);
        this.field_22788.method_4022(this.field_22793, itemStack, i, j - (this.draggingItem.method_7960() ? 0 : 8), string);
        this.method_25304(0);
        this.field_22788.field_4730 = 0.0f;
    }

    protected void renderLabels(class_4587 poseStack, int i, int j) {
        this.field_22793.method_30883(poseStack, this.field_22785, (float)this.titleLabelX, (float)this.titleLabelY, 0x404040);
        this.field_22793.method_30883(poseStack, this.playerInventoryTitle, (float)this.inventoryLabelX, (float)this.inventoryLabelY, 0x404040);
    }

    protected abstract void renderBg(class_4587 var1, float var2, int var3, int var4);

    private void renderSlot(class_4587 poseStack, class_1735 slot) {
        Pair pair;
        int i = slot.field_7873;
        int j = slot.field_7872;
        class_1799 itemStack = slot.method_7677();
        boolean bl = false;
        boolean bl2 = slot == this.clickedSlot && !this.draggingItem.method_7960() && !this.isSplittingStack;
        class_1799 itemStack2 = this.menu.method_34255();
        String string = null;
        if (slot == this.clickedSlot && !this.draggingItem.method_7960() && this.isSplittingStack && !itemStack.method_7960()) {
            itemStack = itemStack.method_7972();
            itemStack.method_7939(itemStack.method_7947() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.method_7960()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (class_1703.method_7592((class_1735)slot, (class_1799)itemStack2, (boolean)true) && this.menu.method_7615(slot)) {
                itemStack = itemStack2.method_7972();
                bl = true;
                class_1703.method_7617(this.quickCraftSlots, (int)this.quickCraftingType, (class_1799)itemStack, (int)(slot.method_7677().method_7960() ? 0 : slot.method_7677().method_7947()));
                int k = Math.min(itemStack.method_7914(), slot.method_7676(itemStack));
                if (itemStack.method_7947() > k) {
                    String var10000 = class_124.field_1054.toString();
                    string = var10000 + k;
                    itemStack.method_7939(k);
                }
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        this.method_25304(100);
        this.field_22788.field_4730 = 100.0f;
        if (itemStack.method_7960() && slot.method_7682() && (pair = slot.method_7679()) != null) {
            class_1058 textureAtlasSprite = (class_1058)this.field_22787.method_1549((class_2960)pair.getFirst()).apply((class_2960)pair.getSecond());
            RenderSystem.setShaderTexture((int)0, (class_2960)textureAtlasSprite.method_24119().method_24106());
            StarterKitAbstractContainerScreen.method_25298((class_4587)poseStack, (int)i, (int)j, (int)this.method_25305(), (int)16, (int)16, (class_1058)textureAtlasSprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                StarterKitAbstractContainerScreen.method_25294((class_4587)poseStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            RenderSystem.enableDepthTest();
            this.field_22788.method_27951((class_1309)this.field_22787.field_1724, itemStack, i, j, slot.field_7873 + slot.field_7872 * this.imageWidth);
            this.field_22788.method_4022(this.field_22793, itemStack, i, j, string);
        }
        this.field_22788.field_4730 = 0.0f;
        this.method_25304(0);
    }

    private void recalculateQuickCraftRemaining() {
        class_1799 itemStack = this.menu.method_34255();
        if (!itemStack.method_7960() && this.isQuickCrafting) {
            if (this.quickCraftingType == 2) {
                this.quickCraftingRemainder = itemStack.method_7914();
            } else {
                this.quickCraftingRemainder = itemStack.method_7947();
                for (class_1735 slot : this.quickCraftSlots) {
                    class_1799 itemStack2 = itemStack.method_7972();
                    class_1799 itemStack3 = slot.method_7677();
                    int i = itemStack3.method_7960() ? 0 : itemStack3.method_7947();
                    class_1703.method_7617(this.quickCraftSlots, (int)this.quickCraftingType, (class_1799)itemStack2, (int)i);
                    int j = Math.min(itemStack2.method_7914(), slot.method_7676(itemStack2));
                    if (itemStack2.method_7947() > j) {
                        itemStack2.method_7939(j);
                    }
                    this.quickCraftingRemainder -= itemStack2.method_7947() - i;
                }
            }
        }
    }

    @Nullable
    private class_1735 findSlot(double d, double e) {
        for (int i = 0; i < ((class_1703)this.menu).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((class_1703)this.menu).field_7761.get(i);
            if (!this.isHovering(slot, d, e) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    public boolean method_25402(double d, double e, int i) {
        if (super.method_25402(d, e, i)) {
            return true;
        }
        boolean bl = this.field_22787.field_1690.field_1871.method_1433(i) && this.field_22787.field_1761.method_2914();
        class_1735 slot = this.findSlot(d, e);
        long l = class_156.method_658();
        this.doubleclick = this.lastClickSlot == slot && l - this.lastClickTime < 250L && this.lastClickButton == i;
        this.skipNextRelease = false;
        if (i != 0 && i != 1 && !bl) {
            this.checkHotbarMouseClicked(i);
        } else {
            int j = this.leftPos;
            int k = this.topPos;
            boolean bl2 = this.hasClickedOutside(d, e, j, k, i);
            int m = -1;
            if (slot != null) {
                m = slot.field_7874;
            }
            if (bl2) {
                m = -999;
            }
            if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue() && bl2 && this.menu.method_34255().method_7960()) {
                this.method_25419();
                return true;
            }
            if (m != -1) {
                if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                    if (slot != null && slot.method_7681()) {
                        this.clickedSlot = slot;
                        this.draggingItem = class_1799.field_8037;
                        this.isSplittingStack = i == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.isQuickCrafting) {
                    if (this.menu.method_34255().method_7960()) {
                        if (bl) {
                            this.slotClicked(slot, m, i, class_1713.field_7796);
                        } else {
                            boolean bl3 = m != -999 && (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344));
                            class_1713 clickType = class_1713.field_7790;
                            if (bl3) {
                                this.lastQuickMoved = slot != null && slot.method_7681() ? slot.method_7677().method_7972() : class_1799.field_8037;
                                clickType = class_1713.field_7794;
                            } else if (m == -999) {
                                clickType = class_1713.field_7795;
                            }
                            this.slotClicked(slot, m, i, clickType);
                        }
                        this.skipNextRelease = true;
                    } else {
                        this.isQuickCrafting = true;
                        this.quickCraftingButton = i;
                        this.quickCraftSlots.clear();
                        if (i == 0) {
                            this.quickCraftingType = 0;
                        } else if (i == 1) {
                            this.quickCraftingType = 1;
                        } else if (bl) {
                            this.quickCraftingType = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        this.lastClickTime = l;
        this.lastClickButton = i;
        return true;
    }

    private void checkHotbarMouseClicked(int i) {
        if (this.hoveredSlot != null && this.menu.method_34255().method_7960()) {
            if (this.field_22787.field_1690.field_1831.method_1433(i)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, 40, class_1713.field_7791);
                return;
            }
            for (int j = 0; j < 9; ++j) {
                if (!this.field_22787.field_1690.field_1852[j].method_1433(i)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, j, class_1713.field_7791);
            }
        }
    }

    protected boolean hasClickedOutside(double d, double e, int i, int j, int k) {
        return d < (double)i || e < (double)j || d >= (double)(i + this.imageWidth) || e >= (double)(j + this.imageHeight);
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        class_1735 slot = this.findSlot(d, e);
        class_1799 itemStack = this.menu.method_34255();
        if (this.clickedSlot != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
            if (i == 0 || i == 1) {
                if (this.draggingItem.method_7960()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.method_7677().method_7960()) {
                        this.draggingItem = this.clickedSlot.method_7677().method_7972();
                    }
                } else if (this.draggingItem.method_7947() > 1 && slot != null && class_1703.method_7592((class_1735)slot, (class_1799)this.draggingItem, (boolean)false)) {
                    long l = class_156.method_658();
                    if (this.quickdropSlot == slot) {
                        if (l - this.quickdropTime > 500L) {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, 0, class_1713.field_7790);
                            this.slotClicked(slot, slot.field_7874, 1, class_1713.field_7790);
                            this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, 0, class_1713.field_7790);
                            this.quickdropTime = l + 750L;
                            this.draggingItem.method_7934(1);
                        }
                    } else {
                        this.quickdropSlot = slot;
                        this.quickdropTime = l;
                    }
                }
            }
        } else if (this.isQuickCrafting && slot != null && !itemStack.method_7960() && (itemStack.method_7947() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && class_1703.method_7592((class_1735)slot, (class_1799)itemStack, (boolean)true) && slot.method_7680(itemStack) && this.menu.method_7615(slot)) {
            this.quickCraftSlots.add(slot);
            this.recalculateQuickCraftRemaining();
        }
        return true;
    }

    public boolean method_25406(double d, double e, int i) {
        class_1735 slot = this.findSlot(d, e);
        int j = this.leftPos;
        int k = this.topPos;
        boolean bl = this.hasClickedOutside(d, e, j, k, i);
        int l = -1;
        if (slot != null) {
            l = slot.field_7874;
        }
        if (bl) {
            l = -999;
        }
        if (this.doubleclick && slot != null && i == 0 && this.menu.method_7613(class_1799.field_8037, slot)) {
            if (StarterKitAbstractContainerScreen.method_25442()) {
                if (!this.lastQuickMoved.method_7960()) {
                    for (class_1735 slot2 : ((class_1703)this.menu).field_7761) {
                        if (slot2 == null || !slot2.method_7674((class_1657)this.field_22787.field_1724) || !slot2.method_7681() || slot2.field_7871 != slot.field_7871 || !class_1703.method_7592((class_1735)slot2, (class_1799)this.lastQuickMoved, (boolean)true)) continue;
                        this.slotClicked(slot2, slot2.field_7874, i, class_1713.field_7794);
                    }
                }
            } else {
                this.slotClicked(slot, l, i, class_1713.field_7793);
            }
            this.doubleclick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.isQuickCrafting && this.quickCraftingButton != i) {
                this.isQuickCrafting = false;
                this.quickCraftSlots.clear();
                this.skipNextRelease = true;
                return true;
            }
            if (this.skipNextRelease) {
                this.skipNextRelease = false;
                return true;
            }
            if (this.clickedSlot != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                if (i == 0 || i == 1) {
                    if (this.draggingItem.method_7960() && slot != this.clickedSlot) {
                        this.draggingItem = this.clickedSlot.method_7677();
                    }
                    boolean bl2 = class_1703.method_7592((class_1735)slot, (class_1799)this.draggingItem, (boolean)false);
                    if (l != -1 && !this.draggingItem.method_7960() && bl2) {
                        this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, i, class_1713.field_7790);
                        this.slotClicked(slot, l, 0, class_1713.field_7790);
                        if (this.menu.method_34255().method_7960()) {
                            this.snapbackItem = class_1799.field_8037;
                        } else {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.field_7874, i, class_1713.field_7790);
                            this.snapbackStartX = class_3532.method_15357((double)(d - (double)j));
                            this.snapbackStartY = class_3532.method_15357((double)(e - (double)k));
                            this.snapbackEnd = this.clickedSlot;
                            this.snapbackItem = this.draggingItem;
                            this.snapbackTime = class_156.method_658();
                        }
                    } else if (!this.draggingItem.method_7960()) {
                        this.snapbackStartX = class_3532.method_15357((double)(d - (double)j));
                        this.snapbackStartY = class_3532.method_15357((double)(e - (double)k));
                        this.snapbackEnd = this.clickedSlot;
                        this.snapbackItem = this.draggingItem;
                        this.snapbackTime = class_156.method_658();
                    }
                    this.clearDraggingState();
                }
            } else if (this.isQuickCrafting && !this.quickCraftSlots.isEmpty()) {
                this.slotClicked(null, -999, class_1703.method_7591((int)0, (int)this.quickCraftingType), class_1713.field_7789);
                for (class_1735 slot2 : this.quickCraftSlots) {
                    this.slotClicked(slot2, slot2.field_7874, class_1703.method_7591((int)1, (int)this.quickCraftingType), class_1713.field_7789);
                }
                this.slotClicked(null, -999, class_1703.method_7591((int)2, (int)this.quickCraftingType), class_1713.field_7789);
            } else if (!this.menu.method_34255().method_7960()) {
                if (this.field_22787.field_1690.field_1871.method_1433(i)) {
                    this.slotClicked(slot, l, i, class_1713.field_7796);
                } else {
                    boolean bl2;
                    boolean bl3 = bl2 = l != -999 && (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344));
                    if (bl2) {
                        this.lastQuickMoved = slot != null && slot.method_7681() ? slot.method_7677().method_7972() : class_1799.field_8037;
                    }
                    this.slotClicked(slot, l, i, bl2 ? class_1713.field_7794 : class_1713.field_7790);
                }
            }
        }
        if (this.menu.method_34255().method_7960()) {
            this.lastClickTime = 0L;
        }
        this.isQuickCrafting = false;
        return true;
    }

    public void clearDraggingState() {
        this.draggingItem = class_1799.field_8037;
        this.clickedSlot = null;
    }

    private boolean isHovering(class_1735 slot, double d, double e) {
        return this.isHovering(slot.field_7873, slot.field_7872, 16, 16, d, e);
    }

    protected boolean isHovering(int i, int j, int k, int l, double d, double e) {
        int m = this.leftPos;
        int n = this.topPos;
        return (d -= (double)m) >= (double)(i - 1) && d < (double)(i + k + 1) && (e -= (double)n) >= (double)(j - 1) && e < (double)(j + l + 1);
    }

    protected void slotClicked(class_1735 slot, int i, int j, class_1713 clickType) {
        if (slot != null) {
            i = slot.field_7874;
        }
        this.field_22787.field_1761.method_2906(((class_1703)this.menu).field_7763, i, j, clickType, (class_1657)this.field_22787.field_1724);
    }

    public boolean method_25404(int i, int j, int k) {
        if (super.method_25404(i, j, k)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(i, j)) {
            this.method_25419();
            return true;
        }
        this.checkHotbarKeyPressed(i, j);
        if (this.hoveredSlot != null && this.hoveredSlot.method_7681()) {
            if (this.field_22787.field_1690.field_1871.method_1417(i, j)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, 0, class_1713.field_7796);
            } else if (this.field_22787.field_1690.field_1869.method_1417(i, j)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, StarterKitAbstractContainerScreen.method_25441() ? 1 : 0, class_1713.field_7795);
            }
        }
        return true;
    }

    protected boolean checkHotbarKeyPressed(int i, int j) {
        if (this.menu.method_34255().method_7960() && this.hoveredSlot != null) {
            if (this.field_22787.field_1690.field_1831.method_1417(i, j)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, 40, class_1713.field_7791);
                return true;
            }
            for (int k = 0; k < 9; ++k) {
                if (!this.field_22787.field_1690.field_1852[k].method_1417(i, j)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.field_7874, k, class_1713.field_7791);
                return true;
            }
        }
        return false;
    }

    public void method_25432() {
        if (this.field_22787.field_1724 != null) {
            this.menu.method_7595((class_1657)this.field_22787.field_1724);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public final void method_25393() {
        super.method_25393();
        if (this.field_22787.field_1724.method_5805() && !this.field_22787.field_1724.method_31481()) {
            this.containerTick();
        } else {
            this.field_22787.field_1724.method_7346();
        }
    }

    protected void containerTick() {
    }

    @NotNull
    public T method_17577() {
        return this.menu;
    }

    public void method_25419() {
        this.field_22787.field_1724.method_7346();
        super.method_25419();
    }
}

