/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.starterkit_common_forge.config.ConfigHandler;
import com.natamus.starterkit_common_forge.data.Constants;
import com.natamus.starterkit_common_forge.data.Variables;
import com.natamus.starterkit_common_forge.functions.StarterCheckFunctions;
import com.natamus.starterkit_common_forge.functions.StarterCommandFunctions;
import com.natamus.starterkit_common_forge.functions.StarterDataFunctions;
import com.natamus.starterkit_common_forge.functions.StarterGearFunctions;
import com.natamus.starterkit_common_forge.util.Util;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandStarterkit {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (String commandPrefix : Constants.commandPrefixes) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandPrefix).requires(commandSourceStack -> commandSourceStack.m_230897_())).executes(command -> CommandStarterkit.showCommandHelp((CommandSourceStack)command.getSource()))).then(Commands.m_82127_((String)"help").executes(command -> CommandStarterkit.showCommandHelp((CommandSourceStack)command.getSource())))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                ServerPlayer player = source.m_230896_();
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                return StarterGearFunctions.showKitInformation((Player)player, kitName);
            })))).then(Commands.m_82127_((String)"choose").then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                ServerPlayer player = source.m_230896_();
                if (!StarterCheckFunctions.shouldPlayerReceiveStarterKit((Player)player)) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"You are not eligible for a starter kit.", (ChatFormatting)ChatFormatting.RED);
                    return 0;
                }
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                if (!Variables.starterGearEntries.containsKey(kitName)) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The starter kit '" + kitName + "' does not exist."), (ChatFormatting)ChatFormatting.RED);
                    return 0;
                }
                String actualKitName = StarterGearFunctions.giveStarterKit((Player)player, null, kitName);
                if (actualKitName == null) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while choosing your starter kit.", (ChatFormatting)ChatFormatting.RED);
                    return 0;
                }
                MessageFunctions.sendMessage((Player)player, (String)("You have been given the '" + Util.formatKitName(actualKitName) + "' starter kit."), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                return 1;
            })))).then(Commands.m_82127_((String)"add").executes(command -> CommandStarterkit.processCommand((CommandSourceStack)command.getSource(), "", true)))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).executes(command -> CommandStarterkit.processCommand((CommandSourceStack)command.getSource(), StringArgumentType.getString((CommandContext)command, (String)"kit_name"), true))))).then(Commands.m_82127_((String)"set").executes(command -> CommandStarterkit.processCommand((CommandSourceStack)command.getSource(), "", false)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).executes(command -> CommandStarterkit.processCommand((CommandSourceStack)command.getSource(), StringArgumentType.getString((CommandContext)command, (String)"kit_name"), false))))).then(Commands.m_82127_((String)"deactivate").then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestionsWithAll).executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                String kitNameInput = StringArgumentType.getString((CommandContext)command, (String)"kit_name");
                if (kitNameInput.equalsIgnoreCase("_all")) {
                    StarterGearFunctions.moveAllKitsToInactive();
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Moved all kits to the inactive folder.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                    return 1;
                }
                String kitName = Util.findCorrectKitNameFromInput(kitNameInput);
                if (!StarterGearFunctions.moveKitToInactive(kitName)) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to move the '" + kitName + "' kit to the inactive folder."), (ChatFormatting)ChatFormatting.RED, (boolean)true);
                    return 0;
                }
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The kit '" + kitName + "' has been moved to the inactive folder."), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                return 1;
            })))).then(Commands.m_82127_((String)"activate").then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.inactiveKitSuggestionsWithAll).executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                String kitNameInput = StringArgumentType.getString((CommandContext)command, (String)"kit_name");
                if (kitNameInput.equalsIgnoreCase("_all")) {
                    StarterGearFunctions.moveAllKitsToActive();
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Moved all kits to the active folder.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                    return 1;
                }
                String kitName = Util.findCorrectKitNameFromInput(kitNameInput);
                if (!StarterGearFunctions.moveKitToActive(kitName)) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Unable to move the '" + kitName + "' kit to the active folder."), (ChatFormatting)ChatFormatting.RED, (boolean)true);
                    return 0;
                }
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The kit '" + kitName + "' has been moved to the active folder."), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                return 1;
            })))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                ServerPlayer commandPlayer = source.m_230896_();
                Level level = commandPlayer.f_19853_;
                if (level.f_46443_) {
                    return 1;
                }
                ServerPlayer targetPlayer = EntityArgument.m_91474_((CommandContext)command, (String)"target");
                StarterDataFunctions.resetTrackingForPlayer((Player)targetPlayer);
                StarterGearFunctions.initStarterKitHandle(level, (Player)targetPlayer, (Player)commandPlayer);
                if (ConfigHandler.randomizeMultipleKitsToggle && Variables.starterGearEntries.size() > 1) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)(targetPlayer.m_7755_().getString() + " has been given the choice for a new starter kit!"), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                }
                return 1;
            })))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                ServerPlayer commandPlayer = source.m_230896_();
                Level level = commandPlayer.f_19853_;
                if (level.f_46443_) {
                    return 1;
                }
                ServerPlayer targetPlayer = EntityArgument.m_91474_((CommandContext)command, (String)"target");
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                StarterDataFunctions.resetTrackingForPlayer((Player)targetPlayer);
                StarterGearFunctions.initStarterKitHandle(level, (Player)targetPlayer, (Player)commandPlayer, kitName);
                if (ConfigHandler.randomizeMultipleKitsToggle && Variables.starterGearEntries.size() > 1) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)(targetPlayer.m_7755_().getString() + " has been given the choice for a new starter kit!"), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                }
                return 1;
            }))))).then(Commands.m_82127_((String)"list").executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.m_237113_((String)"The current ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)"active").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" starter kits are:").m_130940_(ChatFormatting.DARK_GREEN))), (boolean)true);
                List<String> activeKitNames = StarterGearFunctions.getActiveKitNames();
                int activeKitcount = activeKitNames.size();
                if (activeKitcount > 0) {
                    for (String kitName : activeKitNames) {
                        MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" " + kitName), (ChatFormatting)ChatFormatting.GRAY);
                    }
                } else {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)" N/A", (ChatFormatting)ChatFormatting.RED);
                }
                if (ConfigHandler.randomizeMultipleKitsToggle) {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"One kit is given randomly on join.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                } else {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Players can choose one of the kits on join.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                    if (activeKitcount < 2) {
                        if (activeKitcount == 0) {
                            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" > If 2 more kits are added.", (ChatFormatting)ChatFormatting.DARK_GRAY);
                        } else {
                            MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" > If 1 more kit is added. For now all players will receive the '" + activeKitNames.get(0) + "' kit without a choice screen."), (ChatFormatting)ChatFormatting.DARK_GRAY);
                        }
                    }
                }
                return 1;
            }))).then(Commands.m_82127_((String)"list").then(Commands.m_82127_((String)"inactive").executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.m_237113_((String)"The current ").m_130940_(ChatFormatting.DARK_GREEN).m_7220_((Component)Component.m_237113_((String)"inactive").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" starter kits are:").m_130940_(ChatFormatting.DARK_GREEN))), (boolean)true);
                List<String> inactiveKitNames = StarterGearFunctions.getInactiveKitNames();
                if (inactiveKitNames.size() > 0) {
                    for (String kitName : inactiveKitNames) {
                        MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" " + kitName), (ChatFormatting)ChatFormatting.GRAY);
                    }
                } else {
                    MessageFunctions.sendMessage((CommandSourceStack)source, (String)" N/A", (ChatFormatting)ChatFormatting.RED);
                }
                return 1;
            })))).then(Commands.m_82127_((String)"reload").executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                StarterGearFunctions.processKitFiles();
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (String)"All active kits have been reloaded.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                CommandStarterkit.sendKitCount(source, false);
                return 1;
            }))).then(Commands.m_82127_((String)"reset").executes(command -> {
                CommandSourceStack source = (CommandSourceStack)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                ServerPlayer player = source.m_230896_();
                Level level = player.f_19853_;
                if (level.f_46443_) {
                    return 0;
                }
                StarterDataFunctions.resetTrackingMap(level.m_7654_());
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Starter Kit tracking data has been reset. All players will now again receive a kit on join.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
                return 1;
            })));
        }
    }

    private static boolean permissionCheck(CommandSourceStack source) {
        if (!source.m_6761_(2)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"You do not have permission to use that command.", (ChatFormatting)ChatFormatting.RED);
            return false;
        }
        return true;
    }

    private static int showCommandHelp(CommandSourceStack source) {
        if (source.m_6761_(2)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.m_237113_((String)"Starter Kit Admin Usage:").m_130940_(ChatFormatting.GOLD), (boolean)true);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk add (kit_name)", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Adds your current inventory to the active kits.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk set (kit_name)", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Sets your current inventory as the only active kit.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk give <player> (kit_name)", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Give a player a random (or specific) starter kit.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk activate <kit_name>/_all", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Moves kit_name or all kits from inactive to active.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk deactivate <kit_name>/_all", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Moves kit_name or all kits from active to inactive.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk list (inactive)", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Lists all active (or inactive) kits.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk reset", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Resets all tracking. Players receive another kit on join.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk reload", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Reloads starter kit changes from the config folder.", (ChatFormatting)ChatFormatting.GRAY);
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (MutableComponent)Component.m_237113_((String)"Starter Kit User Usage:").m_130940_(ChatFormatting.GOLD), (boolean)true);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk choose <kit_name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Allows players to choose a starter kit via commands. This is only needed when Starter Kit is not installed on the client and the server enabled kit choices.", (ChatFormatting)ChatFormatting.GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /sk info <kit_name>", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"     Shows the description and items of kit_name.", (ChatFormatting)ChatFormatting.GRAY);
        return 1;
    }

    private static int processCommand(CommandSourceStack source, String kitName, boolean adding) {
        String actualKitName;
        if (!CommandStarterkit.permissionCheck(source)) {
            return 0;
        }
        ServerPlayer player = source.m_230896_();
        kitName = Util.findCorrectKitNameFromInput(kitName);
        String wording = "adding";
        String worded = "added";
        String cmd = "add";
        if (!adding) {
            wording = "setting";
            worded = "set";
            cmd = "set";
        }
        if ((actualKitName = StarterGearFunctions.createStarterKitFile((Player)player, kitName, adding)).equals("")) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("Something went wrong while " + wording + " a new starter kit."), (ChatFormatting)ChatFormatting.RED);
            return 0;
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)("The starter kit '" + Util.formatKitName(actualKitName) + "' was " + worded + "!"), (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        if (!kitName.equals(actualKitName)) {
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" If you'd like to specify the kit name, use:", (ChatFormatting)ChatFormatting.GRAY, (boolean)true);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)("     /sk " + cmd + " <kit_name>"), (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)" ", (ChatFormatting)ChatFormatting.GRAY);
        }
        CommandStarterkit.sendKitCount(source, true);
        return 1;
    }

    private static void sendKitCount(CommandSourceStack source, boolean now) {
        int kitCount = Variables.starterGearEntries.size();
        String isare = "are";
        String s = "s";
        if (kitCount == 1) {
            isare = "is";
            s = "";
        }
        String nowword = "now ";
        if (!now) {
            nowword = "";
        }
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" There " + isare + " " + nowword + kitCount + " starter kit" + s + " available."), (ChatFormatting)ChatFormatting.DARK_GRAY);
    }
}

