/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.starterkit_common_fabric.config.ConfigHandler;
import com.natamus.starterkit_common_fabric.data.Constants;
import com.natamus.starterkit_common_fabric.data.Variables;
import com.natamus.starterkit_common_fabric.functions.StarterCheckFunctions;
import com.natamus.starterkit_common_fabric.functions.StarterCommandFunctions;
import com.natamus.starterkit_common_fabric.functions.StarterDataFunctions;
import com.natamus.starterkit_common_fabric.functions.StarterGearFunctions;
import com.natamus.starterkit_common_fabric.util.Util;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandStarterkit {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        for (String commandPrefix : Constants.commandPrefixes) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandPrefix).executes(command -> CommandStarterkit.showCommandHelp((class_2168)command.getSource()))).then(class_2170.method_9247((String)"help").executes(command -> CommandStarterkit.showCommandHelp((class_2168)command.getSource())))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                return StarterGearFunctions.showKitInformation((class_1937)source.method_9225(), source, null, kitName);
            })))).then(class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(command -> {
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)command, (String)"target");
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                return StarterGearFunctions.showKitInformation(targetPlayer.field_6002, null, (class_1657)targetPlayer, kitName);
            }))))).then(class_2170.method_9247((String)"choose").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!source.method_43737()) {
                    MessageFunctions.sendMessage((class_2168)source, (String)"This command can only be ran as a player.", (class_124)class_124.field_1061);
                    return 0;
                }
                class_3222 player = source.method_44023();
                if (!StarterCheckFunctions.shouldPlayerReceiveStarterKit((class_1657)player)) {
                    MessageFunctions.sendMessage((class_2168)source, (String)"You are not eligible for a starter kit.", (class_124)class_124.field_1061);
                    return 0;
                }
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                if (!Variables.starterGearEntries.containsKey(kitName)) {
                    MessageFunctions.sendMessage((class_2168)source, (String)("The starter kit '" + kitName + "' does not exist."), (class_124)class_124.field_1061);
                    return 0;
                }
                String actualKitName = StarterGearFunctions.giveStarterKit((class_1657)player, null, kitName);
                if (actualKitName == null) {
                    MessageFunctions.sendMessage((class_2168)source, (String)"Something went wrong while choosing your starter kit.", (class_124)class_124.field_1061);
                    return 0;
                }
                MessageFunctions.sendMessage((class_1657)player, (String)("You have been given the '" + Util.formatKitName(actualKitName) + "' starter kit."), (class_124)class_124.field_1077, (boolean)true);
                return 1;
            })))).then(class_2170.method_9247((String)"add").executes(command -> CommandStarterkit.processCommand((class_2168)command.getSource(), "", true)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).executes(command -> CommandStarterkit.processCommand((class_2168)command.getSource(), StringArgumentType.getString((CommandContext)command, (String)"kit_name"), true))))).then(class_2170.method_9247((String)"set").executes(command -> CommandStarterkit.processCommand((class_2168)command.getSource(), "", false)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).executes(command -> CommandStarterkit.processCommand((class_2168)command.getSource(), StringArgumentType.getString((CommandContext)command, (String)"kit_name"), false))))).then(class_2170.method_9247((String)"deactivate").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestionsWithAll).executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                String kitNameInput = StringArgumentType.getString((CommandContext)command, (String)"kit_name");
                if (kitNameInput.equalsIgnoreCase("_all")) {
                    StarterGearFunctions.moveAllKitsToInactive();
                    MessageFunctions.sendMessage((class_2168)source, (String)"Moved all kits to the inactive folder.", (class_124)class_124.field_1077, (boolean)true);
                    return 1;
                }
                String kitName = Util.findCorrectKitNameFromInput(kitNameInput);
                if (!StarterGearFunctions.moveKitToInactive(kitName)) {
                    MessageFunctions.sendMessage((class_2168)source, (String)("Unable to move the '" + kitName + "' kit to the inactive folder."), (class_124)class_124.field_1061, (boolean)true);
                    return 0;
                }
                MessageFunctions.sendMessage((class_2168)source, (String)("The kit '" + kitName + "' has been moved to the inactive folder."), (class_124)class_124.field_1077, (boolean)true);
                return 1;
            })))).then(class_2170.method_9247((String)"activate").then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.inactiveKitSuggestionsWithAll).executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                String kitNameInput = StringArgumentType.getString((CommandContext)command, (String)"kit_name");
                if (kitNameInput.equalsIgnoreCase("_all")) {
                    StarterGearFunctions.moveAllKitsToActive();
                    MessageFunctions.sendMessage((class_2168)source, (String)"Moved all kits to the active folder.", (class_124)class_124.field_1077, (boolean)true);
                    return 1;
                }
                String kitName = Util.findCorrectKitNameFromInput(kitNameInput);
                if (!StarterGearFunctions.moveKitToActive(kitName)) {
                    MessageFunctions.sendMessage((class_2168)source, (String)("Unable to move the '" + kitName + "' kit to the active folder."), (class_124)class_124.field_1061, (boolean)true);
                    return 0;
                }
                MessageFunctions.sendMessage((class_2168)source, (String)("The kit '" + kitName + "' has been moved to the active folder."), (class_124)class_124.field_1077, (boolean)true);
                return 1;
            })))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                class_3218 level = source.method_9225();
                if (level.field_9236) {
                    return 1;
                }
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)command, (String)"target");
                StarterDataFunctions.resetTrackingForPlayer((class_1657)targetPlayer);
                StarterGearFunctions.initStarterKitHandle((class_1937)level, (class_1657)targetPlayer, source);
                if (ConfigHandler.randomizeMultipleKitsToggle && Variables.starterGearEntries.size() > 1) {
                    MessageFunctions.sendMessage((class_2168)source, (String)(targetPlayer.method_5477().getString() + " has been given the choice for a new starter kit!"), (class_124)class_124.field_1077, (boolean)true);
                }
                return 1;
            })))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"kit_name", (ArgumentType)StringArgumentType.string()).suggests(StarterCommandFunctions.activeKitSuggestions).executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                class_3218 level = source.method_9225();
                if (level.field_9236) {
                    return 1;
                }
                class_3222 targetPlayer = class_2186.method_9315((CommandContext)command, (String)"target");
                String kitName = Util.findCorrectKitNameFromInput(StringArgumentType.getString((CommandContext)command, (String)"kit_name"));
                StarterDataFunctions.resetTrackingForPlayer((class_1657)targetPlayer);
                StarterGearFunctions.initStarterKitHandle((class_1937)level, (class_1657)targetPlayer, source, kitName);
                if (ConfigHandler.randomizeMultipleKitsToggle && Variables.starterGearEntries.size() > 1) {
                    MessageFunctions.sendMessage((class_2168)source, (String)(targetPlayer.method_5477().getString() + " has been given the choice for a new starter kit!"), (class_124)class_124.field_1077, (boolean)true);
                }
                return 1;
            }))))).then(class_2170.method_9247((String)"list").executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"The current ").method_27692(class_124.field_1077).method_10852((class_2561)class_2561.method_43470((String)"active").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" starter kits are:").method_27692(class_124.field_1077))), (boolean)true);
                List<String> activeKitNames = StarterGearFunctions.getActiveKitNames();
                int activeKitcount = activeKitNames.size();
                if (activeKitcount > 0) {
                    for (String kitName : activeKitNames) {
                        MessageFunctions.sendMessage((class_2168)source, (String)(" " + kitName), (class_124)class_124.field_1080);
                    }
                } else {
                    MessageFunctions.sendMessage((class_2168)source, (String)" N/A", (class_124)class_124.field_1061);
                }
                if (ConfigHandler.randomizeMultipleKitsToggle) {
                    MessageFunctions.sendMessage((class_2168)source, (String)"One kit is given randomly on join.", (class_124)class_124.field_1077, (boolean)true);
                } else {
                    MessageFunctions.sendMessage((class_2168)source, (String)"Players can choose one of the kits on join.", (class_124)class_124.field_1077, (boolean)true);
                    if (activeKitcount < 2) {
                        if (activeKitcount == 0) {
                            MessageFunctions.sendMessage((class_2168)source, (String)" > If 2 more kits are added.", (class_124)class_124.field_1063);
                        } else {
                            MessageFunctions.sendMessage((class_2168)source, (String)(" > If 1 more kit is added. For now all players will receive the '" + activeKitNames.get(0) + "' kit without a choice screen."), (class_124)class_124.field_1063);
                        }
                    }
                }
                return 1;
            }))).then(class_2170.method_9247((String)"list").then(class_2170.method_9247((String)"inactive").executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"The current ").method_27692(class_124.field_1077).method_10852((class_2561)class_2561.method_43470((String)"inactive").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)" starter kits are:").method_27692(class_124.field_1077))), (boolean)true);
                List<String> inactiveKitNames = StarterGearFunctions.getInactiveKitNames();
                if (inactiveKitNames.size() > 0) {
                    for (String kitName : inactiveKitNames) {
                        MessageFunctions.sendMessage((class_2168)source, (String)(" " + kitName), (class_124)class_124.field_1080);
                    }
                } else {
                    MessageFunctions.sendMessage((class_2168)source, (String)" N/A", (class_124)class_124.field_1061);
                }
                return 1;
            })))).then(class_2170.method_9247((String)"reload").executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                StarterGearFunctions.processKitFiles();
                MessageFunctions.sendMessage((class_2168)((class_2168)command.getSource()), (String)"All active kits have been reloaded.", (class_124)class_124.field_1077, (boolean)true);
                CommandStarterkit.sendKitCount(source, false);
                return 1;
            }))).then(class_2170.method_9247((String)"reset").executes(command -> {
                class_2168 source = (class_2168)command.getSource();
                if (!CommandStarterkit.permissionCheck(source)) {
                    return 0;
                }
                class_3218 level = source.method_9225();
                if (level.field_9236) {
                    return 0;
                }
                StarterDataFunctions.resetTrackingMap(level.method_8503());
                MessageFunctions.sendMessage((class_2168)source, (String)"Starter Kit tracking data has been reset. All players will now again receive a kit on join.", (class_124)class_124.field_1077, (boolean)true);
                return 1;
            })));
        }
    }

    private static boolean permissionCheck(class_2168 source) {
        if (!source.method_9259(2)) {
            MessageFunctions.sendMessage((class_2168)source, (String)"You do not have permission to use that command.", (class_124)class_124.field_1061);
            return false;
        }
        return true;
    }

    private static int showCommandHelp(class_2168 source) {
        if (source.method_9259(2)) {
            MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"Starter Kit Admin Usage:").method_27692(class_124.field_1065), (boolean)true);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk add (kit_name)", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Adds your current inventory to the active kits.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk set (kit_name)", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Sets your current inventory as the only active kit.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk give <player> (kit_name)", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Give a player a random (or specific) starter kit.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk activate <kit_name>/_all", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Moves kit_name or all kits from inactive to active.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk deactivate <kit_name>/_all", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Moves kit_name or all kits from active to inactive.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk list (inactive)", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Lists all active (or inactive) kits.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk reset", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Resets all tracking. Players receive another kit on join.", (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" /sk reload", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_2168)source, (String)"     Reloads starter kit changes from the config folder.", (class_124)class_124.field_1080);
        }
        MessageFunctions.sendMessage((class_2168)source, (class_5250)class_2561.method_43470((String)"Starter Kit User Usage:").method_27692(class_124.field_1065), (boolean)true);
        MessageFunctions.sendMessage((class_2168)source, (String)" /sk choose <kit_name>", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"     Allows players to choose a starter kit via commands. This is only needed when Starter Kit is not installed on the client and the server enabled kit choices.", (class_124)class_124.field_1080);
        MessageFunctions.sendMessage((class_2168)source, (String)" /sk info <kit_name>", (class_124)class_124.field_1077);
        MessageFunctions.sendMessage((class_2168)source, (String)"     Shows the description and items of kit_name.", (class_124)class_124.field_1080);
        return 1;
    }

    private static int processCommand(class_2168 source, String kitName, boolean adding) {
        String actualKitName;
        if (!CommandStarterkit.permissionCheck(source)) {
            return 0;
        }
        if (!source.method_43737()) {
            MessageFunctions.sendMessage((class_2168)source, (String)"This command can only be ran as a player.", (class_124)class_124.field_1061);
            return 0;
        }
        class_3222 player = source.method_44023();
        kitName = Util.findCorrectKitNameFromInput(kitName);
        String wording = "adding";
        String worded = "added";
        String cmd = "add";
        if (!adding) {
            wording = "setting";
            worded = "set";
            cmd = "set";
        }
        if ((actualKitName = StarterGearFunctions.createStarterKitFile((class_1657)player, kitName, adding)).equals("")) {
            MessageFunctions.sendMessage((class_2168)source, (String)("Something went wrong while " + wording + " a new starter kit."), (class_124)class_124.field_1061);
            return 0;
        }
        MessageFunctions.sendMessage((class_2168)source, (String)("The starter kit '" + Util.formatKitName(actualKitName) + "' was " + worded + "!"), (class_124)class_124.field_1077, (boolean)true);
        if (!kitName.equals(actualKitName)) {
            MessageFunctions.sendMessage((class_2168)source, (String)" If you'd like to specify the kit name, use:", (class_124)class_124.field_1080, (boolean)true);
            MessageFunctions.sendMessage((class_2168)source, (String)("     /sk " + cmd + " <kit_name>"), (class_124)class_124.field_1080);
            MessageFunctions.sendMessage((class_2168)source, (String)" ", (class_124)class_124.field_1080);
        }
        CommandStarterkit.sendKitCount(source, true);
        return 1;
    }

    private static void sendKitCount(class_2168 source, boolean now) {
        int kitCount = Variables.starterGearEntries.size();
        String isare = "are";
        String s = "s";
        if (kitCount == 1) {
            isare = "is";
            s = "";
        }
        String nowword = "now ";
        if (!now) {
            nowword = "";
        }
        MessageFunctions.sendMessage((class_2168)source, (String)(" There " + isare + " " + nowword + kitCount + " starter kit" + s + " available."), (class_124)class_124.field_1063);
    }
}

