/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.inventory;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import com.natamus.starterkit_common_fabric.data.VariablesClient;
import com.natamus.starterkit_common_fabric.inventory.StarterKitAbstractContainerScreen;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public abstract class StarterKitEffectRenderingInventoryScreen<T extends class_1703>
extends StarterKitAbstractContainerScreen<T> {
    public StarterKitEffectRenderingInventoryScreen(T abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
    }

    @Override
    public void method_25394(@NotNull class_4587 poseStack, int i, int j, float f) {
        super.method_25394(poseStack, i, j, f);
        this.renderEffects(poseStack, i, j);
    }

    public boolean canSeeEffects() {
        int i = this.leftPos + this.imageWidth + 2;
        int j = this.field_22789 - i;
        return j >= 32;
    }

    private void renderEffects(class_4587 poseStack, int i, int j) {
        int k = this.leftPos + this.imageWidth + 2;
        int l = this.field_22789 - k;
        if (!VariablesClient.cachedStarterKitEffects.isEmpty() && l >= 32) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = l >= 120;
            int m = 33;
            if (VariablesClient.cachedStarterKitEffects.size() > 5) {
                m = 132 / (VariablesClient.cachedStarterKitEffects.size() - 1);
            }
            List iterable = Ordering.natural().sortedCopy(VariablesClient.cachedStarterKitEffects);
            this.renderBackgrounds(poseStack, k, m, iterable, bl);
            this.renderIcons(poseStack, k, m, iterable, bl);
            if (bl) {
                this.renderLabels(poseStack, k, m, iterable);
            } else if (i >= k && i <= k + 33) {
                int n = this.topPos;
                class_1293 mobEffectInstance = null;
                for (class_1293 mobEffectInstance2 : iterable) {
                    if (j >= n && j <= n + m) {
                        mobEffectInstance = mobEffectInstance2;
                    }
                    n += m;
                }
                if (mobEffectInstance != null) {
                    List<class_5250> list = List.of(this.getEffectName(mobEffectInstance), class_2561.method_43470((String)class_1292.method_5577(mobEffectInstance, (float)1.0f)));
                    this.method_32634(poseStack, list, Optional.empty(), i, j);
                }
            }
        }
    }

    private void renderBackgrounds(class_4587 poseStack, int i, int j, Iterable<class_1293> iterable, boolean bl) {
        RenderSystem.setShaderTexture((int)0, (class_2960)INVENTORY_LOCATION);
        int k = this.topPos;
        for (class_1293 mobEffectInstance : iterable) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (bl) {
                this.method_25302(poseStack, i, k, 0, 166, 120, 32);
            } else {
                this.method_25302(poseStack, i, k, 0, 198, 32, 32);
            }
            k += j;
        }
    }

    private void renderIcons(class_4587 poseStack, int i, int j, Iterable<class_1293> iterable, boolean bl) {
        class_4074 mobEffectTextureManager = this.field_22787.method_18505();
        int k = this.topPos;
        for (class_1293 mobEffectInstance : iterable) {
            class_1291 mobEffect = mobEffectInstance.method_5579();
            class_1058 textureAtlasSprite = mobEffectTextureManager.method_18663(mobEffect);
            RenderSystem.setShaderTexture((int)0, (class_2960)textureAtlasSprite.method_24119().method_24106());
            StarterKitEffectRenderingInventoryScreen.method_25298((class_4587)poseStack, (int)(i + (bl ? 6 : 7)), (int)(k + 7), (int)this.method_25305(), (int)18, (int)18, (class_1058)textureAtlasSprite);
            k += j;
        }
    }

    private void renderLabels(class_4587 poseStack, int i, int j, Iterable<class_1293> iterable) {
        int k = this.topPos;
        for (class_1293 mobEffectInstance : iterable) {
            class_2561 component = this.getEffectName(mobEffectInstance);
            this.field_22793.method_30881(poseStack, component, (float)(i + 10 + 18), (float)(k + 6), 0xFFFFFF);
            String string = class_1292.method_5577((class_1293)mobEffectInstance, (float)1.0f);
            this.field_22793.method_1720(poseStack, string, (float)(i + 10 + 18), (float)(k + 6 + 10), 0x7F7F7F);
            k += j;
        }
    }

    private class_2561 getEffectName(class_1293 mobEffectInstance) {
        class_5250 mutableComponent = mobEffectInstance.method_5579().method_5560().method_27661();
        if (mobEffectInstance.method_5578() >= 1 && mobEffectInstance.method_5578() <= 9) {
            class_5250 var10000 = mutableComponent.method_27693(" ");
            int var10001 = mobEffectInstance.method_5578();
            var10000.method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (var10001 + 1))));
        }
        return mutableComponent;
    }
}

