/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.inventory;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.natamus.starterkit_common_forge.data.Constants;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StarterKitAbstractContainerScreen<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    public static final ResourceLocation INVENTORY_LOCATION = new ResourceLocation("starterkit", "textures/gui/container/inventory.png");
    private static final float SNAPBACK_SPEED = 100.0f;
    private static final int QUICKDROP_DELAY = 500;
    public static final int SLOT_ITEM_BLIT_OFFSET = 100;
    private static final int HOVER_ITEM_BLIT_OFFSET = 200;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int titleLabelX;
    protected int titleLabelY;
    protected int inventoryLabelX;
    protected int inventoryLabelY;
    protected T menu;
    protected Component playerInventoryTitle;
    @Nullable
    protected Slot hoveredSlot;
    @Nullable
    private Slot clickedSlot;
    @Nullable
    private Slot snapbackEnd;
    @Nullable
    private Slot quickdropSlot;
    @Nullable
    private Slot lastClickSlot;
    protected int leftPos;
    protected int topPos;
    private boolean isSplittingStack;
    private ItemStack draggingItem;
    private int snapbackStartX;
    private int snapbackStartY;
    private long snapbackTime;
    private ItemStack snapbackItem;
    private long quickdropTime;
    protected Set<Slot> quickCraftSlots;
    protected boolean isQuickCrafting;
    private int quickCraftingType;
    private int quickCraftingButton;
    private boolean skipNextRelease;
    private int quickCraftingRemainder;
    private long lastClickTime;
    private int lastClickButton;
    private boolean doubleclick;
    private ItemStack lastQuickMoved;

    public StarterKitAbstractContainerScreen(T abstractContainerMenu, Inventory inventory, Component component) {
        super(component);
        if (inventory == null) {
            Constants.logger.warn("[Starter Kit] Cannot initiate StarterKitAbstractContainerScreen, the playerInventory is null.");
            return;
        }
        this.draggingItem = ItemStack.f_41583_;
        this.snapbackItem = ItemStack.f_41583_;
        this.quickCraftSlots = Sets.newHashSet();
        this.lastQuickMoved = ItemStack.f_41583_;
        this.menu = abstractContainerMenu;
        this.playerInventoryTitle = inventory.m_5446_();
        this.skipNextRelease = true;
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void m_6305_(@NotNull PoseStack poseStack, int i, int j, float f) {
        ItemStack itemStack;
        int o;
        int n;
        int k = this.leftPos;
        int l = this.topPos;
        this.renderBg(poseStack, f, i, j);
        RenderSystem.m_69465_();
        super.m_6305_(poseStack, i, j, f);
        PoseStack poseStack2 = RenderSystem.m_157191_();
        poseStack2.m_85836_();
        poseStack2.m_85837_((double)k, (double)l, 0.0);
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.hoveredSlot = null;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int m = 0; m < ((AbstractContainerMenu)this.menu).f_38839_.size(); ++m) {
            Slot slot = (Slot)((AbstractContainerMenu)this.menu).f_38839_.get(m);
            if (slot.m_6659_()) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                this.renderSlot(poseStack, slot);
            }
            if (!this.isHovering(slot, i, j) || !slot.m_6659_()) continue;
            this.hoveredSlot = slot;
            n = slot.f_40220_;
            o = slot.f_40221_;
            StarterKitAbstractContainerScreen.renderSlotHighlight(poseStack, n, o, this.m_93252_());
        }
        this.renderLabels(poseStack, i, j);
        ItemStack itemStack2 = itemStack = this.draggingItem.m_41619_() ? this.menu.m_142621_() : this.draggingItem;
        if (!itemStack.m_41619_()) {
            boolean p = true;
            n = this.draggingItem.m_41619_() ? 8 : 16;
            String string = null;
            if (!this.draggingItem.m_41619_() && this.isSplittingStack) {
                itemStack = itemStack.m_41777_();
                itemStack.m_41764_(Mth.m_14167_((float)((float)itemStack.m_41613_() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1) {
                itemStack = itemStack.m_41777_();
                itemStack.m_41764_(this.quickCraftingRemainder);
                if (itemStack.m_41619_()) {
                    string = ChatFormatting.YELLOW + "0";
                }
            }
            this.renderFloatingItem(itemStack, i - k - 8, j - l - n, string);
        }
        if (!this.snapbackItem.m_41619_()) {
            float g = (float)(Util.m_137550_() - this.snapbackTime) / 100.0f;
            if (g >= 1.0f) {
                g = 1.0f;
                this.snapbackItem = ItemStack.f_41583_;
            }
            n = this.snapbackEnd.f_40220_ - this.snapbackStartX;
            o = this.snapbackEnd.f_40221_ - this.snapbackStartY;
            int q = this.snapbackStartX + (int)((float)n * g);
            int r = this.snapbackStartY + (int)((float)o * g);
            this.renderFloatingItem(this.snapbackItem, q, r, null);
        }
        poseStack2.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
    }

    public static void renderSlotHighlight(PoseStack poseStack, int i, int j, int k) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        StarterKitAbstractContainerScreen.m_168740_((PoseStack)poseStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433, (int)-2130706433, (int)k);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    protected void renderTooltip(PoseStack poseStack, int i, int j) {
        if (this.menu.m_142621_().m_41619_() && this.hoveredSlot != null && this.hoveredSlot.m_6657_()) {
            this.m_6057_(poseStack, this.hoveredSlot.m_7993_(), i, j);
        }
    }

    private void renderFloatingItem(ItemStack itemStack, int i, int j, String string) {
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157182_();
        this.m_93250_(200);
        this.f_96542_.f_115093_ = 200.0f;
        this.f_96542_.m_115203_(itemStack, i, j);
        this.f_96542_.m_115174_(this.f_96547_, itemStack, i, j - (this.draggingItem.m_41619_() ? 0 : 8), string);
        this.m_93250_(0);
        this.f_96542_.f_115093_ = 0.0f;
    }

    protected void renderLabels(PoseStack poseStack, int i, int j) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.titleLabelX, (float)this.titleLabelY, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.playerInventoryTitle, (float)this.inventoryLabelX, (float)this.inventoryLabelY, 0x404040);
    }

    protected abstract void renderBg(PoseStack var1, float var2, int var3, int var4);

    private void renderSlot(PoseStack poseStack, Slot slot) {
        Pair pair;
        int i = slot.f_40220_;
        int j = slot.f_40221_;
        ItemStack itemStack = slot.m_7993_();
        boolean bl = false;
        boolean bl2 = slot == this.clickedSlot && !this.draggingItem.m_41619_() && !this.isSplittingStack;
        ItemStack itemStack2 = this.menu.m_142621_();
        String string = null;
        if (slot == this.clickedSlot && !this.draggingItem.m_41619_() && this.isSplittingStack && !itemStack.m_41619_()) {
            itemStack = itemStack.m_41777_();
            itemStack.m_41764_(itemStack.m_41613_() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemStack2.m_41619_()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)itemStack2, (boolean)true) && this.menu.m_5622_(slot)) {
                itemStack = itemStack2.m_41777_();
                bl = true;
                AbstractContainerMenu.m_38922_(this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemStack, (int)(slot.m_7993_().m_41619_() ? 0 : slot.m_7993_().m_41613_()));
                int k = Math.min(itemStack.m_41741_(), slot.m_5866_(itemStack));
                if (itemStack.m_41613_() > k) {
                    String var10000 = ChatFormatting.YELLOW.toString();
                    string = var10000 + k;
                    itemStack.m_41764_(k);
                }
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        if (itemStack.m_41619_() && slot.m_6659_() && (pair = slot.m_7543_()) != null) {
            TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureAtlasSprite.m_118414_().m_118330_());
            StarterKitAbstractContainerScreen.m_93200_((PoseStack)poseStack, (int)i, (int)j, (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureAtlasSprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                StarterKitAbstractContainerScreen.m_93172_((PoseStack)poseStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            RenderSystem.m_69482_();
            this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, itemStack, i, j, slot.f_40220_ + slot.f_40221_ * this.imageWidth);
            this.f_96542_.m_115174_(this.f_96547_, itemStack, i, j, string);
        }
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
    }

    private void recalculateQuickCraftRemaining() {
        ItemStack itemStack = this.menu.m_142621_();
        if (!itemStack.m_41619_() && this.isQuickCrafting) {
            if (this.quickCraftingType == 2) {
                this.quickCraftingRemainder = itemStack.m_41741_();
            } else {
                this.quickCraftingRemainder = itemStack.m_41613_();
                for (Slot slot : this.quickCraftSlots) {
                    ItemStack itemStack2 = itemStack.m_41777_();
                    ItemStack itemStack3 = slot.m_7993_();
                    int i = itemStack3.m_41619_() ? 0 : itemStack3.m_41613_();
                    AbstractContainerMenu.m_38922_(this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)itemStack2, (int)i);
                    int j = Math.min(itemStack2.m_41741_(), slot.m_5866_(itemStack2));
                    if (itemStack2.m_41613_() > j) {
                        itemStack2.m_41764_(j);
                    }
                    this.quickCraftingRemainder -= itemStack2.m_41613_() - i;
                }
            }
        }
    }

    @Nullable
    private Slot findSlot(double d, double e) {
        for (int i = 0; i < ((AbstractContainerMenu)this.menu).f_38839_.size(); ++i) {
            Slot slot = (Slot)((AbstractContainerMenu)this.menu).f_38839_.get(i);
            if (!this.isHovering(slot, d, e) || !slot.m_6659_()) continue;
            return slot;
        }
        return null;
    }

    public boolean m_6375_(double d, double e, int i) {
        if (super.m_6375_(d, e, i)) {
            return true;
        }
        boolean bl = this.f_96541_.f_91066_.f_92097_.m_90830_(i) && this.f_96541_.f_91072_.m_105290_();
        Slot slot = this.findSlot(d, e);
        long l = Util.m_137550_();
        this.doubleclick = this.lastClickSlot == slot && l - this.lastClickTime < 250L && this.lastClickButton == i;
        this.skipNextRelease = false;
        if (i != 0 && i != 1 && !bl) {
            this.checkHotbarMouseClicked(i);
        } else {
            int j = this.leftPos;
            int k = this.topPos;
            boolean bl2 = this.hasClickedOutside(d, e, j, k, i);
            int m = -1;
            if (slot != null) {
                m = slot.f_40219_;
            }
            if (bl2) {
                m = -999;
            }
            if (((Boolean)this.f_96541_.f_91066_.m_231828_().m_231551_()).booleanValue() && bl2 && this.menu.m_142621_().m_41619_()) {
                this.m_7379_();
                return true;
            }
            if (m != -1) {
                if (((Boolean)this.f_96541_.f_91066_.m_231828_().m_231551_()).booleanValue()) {
                    if (slot != null && slot.m_6657_()) {
                        this.clickedSlot = slot;
                        this.draggingItem = ItemStack.f_41583_;
                        this.isSplittingStack = i == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.isQuickCrafting) {
                    if (this.menu.m_142621_().m_41619_()) {
                        if (bl) {
                            this.slotClicked(slot, m, i, ClickType.CLONE);
                        } else {
                            boolean bl3 = m != -999 && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344));
                            ClickType clickType = ClickType.PICKUP;
                            if (bl3) {
                                this.lastQuickMoved = slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
                                clickType = ClickType.QUICK_MOVE;
                            } else if (m == -999) {
                                clickType = ClickType.THROW;
                            }
                            this.slotClicked(slot, m, i, clickType);
                        }
                        this.skipNextRelease = true;
                    } else {
                        this.isQuickCrafting = true;
                        this.quickCraftingButton = i;
                        this.quickCraftSlots.clear();
                        if (i == 0) {
                            this.quickCraftingType = 0;
                        } else if (i == 1) {
                            this.quickCraftingType = 1;
                        } else if (bl) {
                            this.quickCraftingType = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        this.lastClickTime = l;
        this.lastClickButton = i;
        return true;
    }

    private void checkHotbarMouseClicked(int i) {
        if (this.hoveredSlot != null && this.menu.m_142621_().m_41619_()) {
            if (this.f_96541_.f_91066_.f_92093_.m_90830_(i)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.f_40219_, 40, ClickType.SWAP);
                return;
            }
            for (int j = 0; j < 9; ++j) {
                if (!this.f_96541_.f_91066_.f_92056_[j].m_90830_(i)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.f_40219_, j, ClickType.SWAP);
            }
        }
    }

    protected boolean hasClickedOutside(double d, double e, int i, int j, int k) {
        return d < (double)i || e < (double)j || d >= (double)(i + this.imageWidth) || e >= (double)(j + this.imageHeight);
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        Slot slot = this.findSlot(d, e);
        ItemStack itemStack = this.menu.m_142621_();
        if (this.clickedSlot != null && ((Boolean)this.f_96541_.f_91066_.m_231828_().m_231551_()).booleanValue()) {
            if (i == 0 || i == 1) {
                if (this.draggingItem.m_41619_()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.m_7993_().m_41619_()) {
                        this.draggingItem = this.clickedSlot.m_7993_().m_41777_();
                    }
                } else if (this.draggingItem.m_41613_() > 1 && slot != null && AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)this.draggingItem, (boolean)false)) {
                    long l = Util.m_137550_();
                    if (this.quickdropSlot == slot) {
                        if (l - this.quickdropTime > 500L) {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.f_40219_, 0, ClickType.PICKUP);
                            this.slotClicked(slot, slot.f_40219_, 1, ClickType.PICKUP);
                            this.slotClicked(this.clickedSlot, this.clickedSlot.f_40219_, 0, ClickType.PICKUP);
                            this.quickdropTime = l + 750L;
                            this.draggingItem.m_41774_(1);
                        }
                    } else {
                        this.quickdropSlot = slot;
                        this.quickdropTime = l;
                    }
                }
            }
        } else if (this.isQuickCrafting && slot != null && !itemStack.m_41619_() && (itemStack.m_41613_() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)itemStack, (boolean)true) && slot.m_5857_(itemStack) && this.menu.m_5622_(slot)) {
            this.quickCraftSlots.add(slot);
            this.recalculateQuickCraftRemaining();
        }
        return true;
    }

    public boolean m_6348_(double d, double e, int i) {
        Slot slot = this.findSlot(d, e);
        int j = this.leftPos;
        int k = this.topPos;
        boolean bl = this.hasClickedOutside(d, e, j, k, i);
        int l = -1;
        if (slot != null) {
            l = slot.f_40219_;
        }
        if (bl) {
            l = -999;
        }
        if (this.doubleclick && slot != null && i == 0 && this.menu.m_5882_(ItemStack.f_41583_, slot)) {
            if (StarterKitAbstractContainerScreen.m_96638_()) {
                if (!this.lastQuickMoved.m_41619_()) {
                    for (Slot slot2 : ((AbstractContainerMenu)this.menu).f_38839_) {
                        if (slot2 == null || !slot2.m_8010_((Player)this.f_96541_.f_91074_) || !slot2.m_6657_() || slot2.f_40218_ != slot.f_40218_ || !AbstractContainerMenu.m_38899_((Slot)slot2, (ItemStack)this.lastQuickMoved, (boolean)true)) continue;
                        this.slotClicked(slot2, slot2.f_40219_, i, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.slotClicked(slot, l, i, ClickType.PICKUP_ALL);
            }
            this.doubleclick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.isQuickCrafting && this.quickCraftingButton != i) {
                this.isQuickCrafting = false;
                this.quickCraftSlots.clear();
                this.skipNextRelease = true;
                return true;
            }
            if (this.skipNextRelease) {
                this.skipNextRelease = false;
                return true;
            }
            if (this.clickedSlot != null && ((Boolean)this.f_96541_.f_91066_.m_231828_().m_231551_()).booleanValue()) {
                if (i == 0 || i == 1) {
                    if (this.draggingItem.m_41619_() && slot != this.clickedSlot) {
                        this.draggingItem = this.clickedSlot.m_7993_();
                    }
                    boolean bl2 = AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)this.draggingItem, (boolean)false);
                    if (l != -1 && !this.draggingItem.m_41619_() && bl2) {
                        this.slotClicked(this.clickedSlot, this.clickedSlot.f_40219_, i, ClickType.PICKUP);
                        this.slotClicked(slot, l, 0, ClickType.PICKUP);
                        if (this.menu.m_142621_().m_41619_()) {
                            this.snapbackItem = ItemStack.f_41583_;
                        } else {
                            this.slotClicked(this.clickedSlot, this.clickedSlot.f_40219_, i, ClickType.PICKUP);
                            this.snapbackStartX = Mth.m_14107_((double)(d - (double)j));
                            this.snapbackStartY = Mth.m_14107_((double)(e - (double)k));
                            this.snapbackEnd = this.clickedSlot;
                            this.snapbackItem = this.draggingItem;
                            this.snapbackTime = Util.m_137550_();
                        }
                    } else if (!this.draggingItem.m_41619_()) {
                        this.snapbackStartX = Mth.m_14107_((double)(d - (double)j));
                        this.snapbackStartY = Mth.m_14107_((double)(e - (double)k));
                        this.snapbackEnd = this.clickedSlot;
                        this.snapbackItem = this.draggingItem;
                        this.snapbackTime = Util.m_137550_();
                    }
                    this.clearDraggingState();
                }
            } else if (this.isQuickCrafting && !this.quickCraftSlots.isEmpty()) {
                this.slotClicked(null, -999, AbstractContainerMenu.m_38930_((int)0, (int)this.quickCraftingType), ClickType.QUICK_CRAFT);
                for (Slot slot2 : this.quickCraftSlots) {
                    this.slotClicked(slot2, slot2.f_40219_, AbstractContainerMenu.m_38930_((int)1, (int)this.quickCraftingType), ClickType.QUICK_CRAFT);
                }
                this.slotClicked(null, -999, AbstractContainerMenu.m_38930_((int)2, (int)this.quickCraftingType), ClickType.QUICK_CRAFT);
            } else if (!this.menu.m_142621_().m_41619_()) {
                if (this.f_96541_.f_91066_.f_92097_.m_90830_(i)) {
                    this.slotClicked(slot, l, i, ClickType.CLONE);
                } else {
                    boolean bl2;
                    boolean bl3 = bl2 = l != -999 && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344));
                    if (bl2) {
                        this.lastQuickMoved = slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
                    }
                    this.slotClicked(slot, l, i, bl2 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.menu.m_142621_().m_41619_()) {
            this.lastClickTime = 0L;
        }
        this.isQuickCrafting = false;
        return true;
    }

    public void clearDraggingState() {
        this.draggingItem = ItemStack.f_41583_;
        this.clickedSlot = null;
    }

    private boolean isHovering(Slot slot, double d, double e) {
        return this.isHovering(slot.f_40220_, slot.f_40221_, 16, 16, d, e);
    }

    protected boolean isHovering(int i, int j, int k, int l, double d, double e) {
        int m = this.leftPos;
        int n = this.topPos;
        return (d -= (double)m) >= (double)(i - 1) && d < (double)(i + k + 1) && (e -= (double)n) >= (double)(j - 1) && e < (double)(j + l + 1);
    }

    protected void slotClicked(Slot slot, int i, int j, ClickType clickType) {
        if (slot != null) {
            i = slot.f_40219_;
        }
        this.f_96541_.f_91072_.m_171799_(((AbstractContainerMenu)this.menu).f_38840_, i, j, clickType, (Player)this.f_96541_.f_91074_);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (super.m_7933_(i, j, k)) {
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(i, j)) {
            this.m_7379_();
            return true;
        }
        this.checkHotbarKeyPressed(i, j);
        if (this.hoveredSlot != null && this.hoveredSlot.m_6657_()) {
            if (this.f_96541_.f_91066_.f_92097_.m_90832_(i, j)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.f_40219_, 0, ClickType.CLONE);
            } else if (this.f_96541_.f_91066_.f_92094_.m_90832_(i, j)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.f_40219_, StarterKitAbstractContainerScreen.m_96637_() ? 1 : 0, ClickType.THROW);
            }
        }
        return true;
    }

    protected boolean checkHotbarKeyPressed(int i, int j) {
        if (this.menu.m_142621_().m_41619_() && this.hoveredSlot != null) {
            if (this.f_96541_.f_91066_.f_92093_.m_90832_(i, j)) {
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.f_40219_, 40, ClickType.SWAP);
                return true;
            }
            for (int k = 0; k < 9; ++k) {
                if (!this.f_96541_.f_91066_.f_92056_[k].m_90832_(i, j)) continue;
                this.slotClicked(this.hoveredSlot, this.hoveredSlot.f_40219_, k, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    public void m_7861_() {
        if (this.f_96541_.f_91074_ != null) {
            this.menu.m_6877_((Player)this.f_96541_.f_91074_);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public final void m_86600_() {
        super.m_86600_();
        if (this.f_96541_.f_91074_.m_6084_() && !this.f_96541_.f_91074_.m_213877_()) {
            this.containerTick();
        } else {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    protected void containerTick() {
    }

    @NotNull
    public T m_6262_() {
        return this.menu;
    }

    public void m_7379_() {
        this.f_96541_.f_91074_.m_6915_();
        super.m_7379_();
    }
}

