/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.inventory;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.starterkit_common_forge.data.VariablesClient;
import com.natamus.starterkit_common_forge.inventory.StarterKitAbstractContainerScreen;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public abstract class StarterKitEffectRenderingInventoryScreen<T extends AbstractContainerMenu>
extends StarterKitAbstractContainerScreen<T> {
    public StarterKitEffectRenderingInventoryScreen(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int i, int j, float f) {
        super.m_6305_(poseStack, i, j, f);
        this.renderEffects(poseStack, i, j);
    }

    public boolean canSeeEffects() {
        int i = this.leftPos + this.imageWidth + 2;
        int j = this.f_96543_ - i;
        return j >= 32;
    }

    private void renderEffects(PoseStack poseStack, int i, int j) {
        int k = this.leftPos + this.imageWidth + 2;
        int l = this.f_96543_ - k;
        if (!VariablesClient.cachedStarterKitEffects.isEmpty() && l >= 32) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = l >= 120;
            int m = 33;
            if (VariablesClient.cachedStarterKitEffects.size() > 5) {
                m = 132 / (VariablesClient.cachedStarterKitEffects.size() - 1);
            }
            List iterable = Ordering.natural().sortedCopy(VariablesClient.cachedStarterKitEffects);
            this.renderBackgrounds(poseStack, k, m, iterable, bl);
            this.renderIcons(poseStack, k, m, iterable, bl);
            if (bl) {
                this.renderLabels(poseStack, k, m, iterable);
            } else if (i >= k && i <= k + 33) {
                int n = this.topPos;
                MobEffectInstance mobEffectInstance = null;
                for (MobEffectInstance mobEffectInstance2 : iterable) {
                    if (j >= n && j <= n + m) {
                        mobEffectInstance = mobEffectInstance2;
                    }
                    n += m;
                }
                if (mobEffectInstance != null) {
                    List<MutableComponent> list = List.of(this.getEffectName(mobEffectInstance), Component.m_237113_((String)MobEffectUtil.m_19581_(mobEffectInstance, (float)1.0f)));
                    this.m_169388_(poseStack, list, Optional.empty(), i, j);
                }
            }
        }
    }

    private void renderBackgrounds(PoseStack poseStack, int i, int j, Iterable<MobEffectInstance> iterable, boolean bl) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)INVENTORY_LOCATION);
        int k = this.topPos;
        for (MobEffectInstance mobEffectInstance : iterable) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (bl) {
                this.m_93228_(poseStack, i, k, 0, 166, 120, 32);
            } else {
                this.m_93228_(poseStack, i, k, 0, 198, 32, 32);
            }
            k += j;
        }
    }

    private void renderIcons(PoseStack poseStack, int i, int j, Iterable<MobEffectInstance> iterable, boolean bl) {
        MobEffectTextureManager mobEffectTextureManager = this.f_96541_.m_91306_();
        int k = this.topPos;
        for (MobEffectInstance mobEffectInstance : iterable) {
            MobEffect mobEffect = mobEffectInstance.m_19544_();
            TextureAtlasSprite textureAtlasSprite = mobEffectTextureManager.m_118732_(mobEffect);
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureAtlasSprite.m_118414_().m_118330_());
            StarterKitEffectRenderingInventoryScreen.m_93200_((PoseStack)poseStack, (int)(i + (bl ? 6 : 7)), (int)(k + 7), (int)this.m_93252_(), (int)18, (int)18, (TextureAtlasSprite)textureAtlasSprite);
            k += j;
        }
    }

    private void renderLabels(PoseStack poseStack, int i, int j, Iterable<MobEffectInstance> iterable) {
        int k = this.topPos;
        for (MobEffectInstance mobEffectInstance : iterable) {
            Component component = this.getEffectName(mobEffectInstance);
            this.f_96547_.m_92763_(poseStack, component, (float)(i + 10 + 18), (float)(k + 6), 0xFFFFFF);
            String string = MobEffectUtil.m_19581_((MobEffectInstance)mobEffectInstance, (float)1.0f);
            this.f_96547_.m_92750_(poseStack, string, (float)(i + 10 + 18), (float)(k + 6 + 10), 0x7F7F7F);
            k += j;
        }
    }

    private Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = mobEffectInstance.m_19544_().m_19482_().m_6881_();
        if (mobEffectInstance.m_19564_() >= 1 && mobEffectInstance.m_19564_() <= 9) {
            MutableComponent var10000 = mutableComponent.m_130946_(" ");
            int var10001 = mobEffectInstance.m_19564_();
            var10000.m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (var10001 + 1))));
        }
        return mutableComponent;
    }
}

