/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;

public class DimensionRegistrar {
    @Internal
    public static final List<DimensionRegistrar> REGISTRARS = new ArrayList<DimensionRegistrar>();
    private final Registrar.Pointer<DimensionType> dimensionType;
    private final Registrar.Pointer<NoiseGeneratorSettings> noiseSettings;
    private final ResourceKey<Level> levelKey;
    private final ResourceKey<LevelStem> levelStemKey;
    private final BiFunction<RegistryAccess, WorldGenSettings, LevelStem> levelStemFactory;

    public DimensionRegistrar(ResourceLocation registryName, Supplier<DimensionType> dimensionType, Supplier<NoiseGeneratorSettings> noiseSettings, BiFunction<RegistryAccess, WorldGenSettings, ChunkGenerator> chunkGeneratorFactory) {
        String modID = registryName.m_135827_();
        RegistrarHandler dimTypeHandler = RegistrarHandler.getOrCreate(Registry.f_122818_, modID);
        RegistrarHandler noiseSettingsHandler = RegistrarHandler.getOrCreate(Registry.f_122878_, modID);
        this.dimensionType = dimTypeHandler.createPointer(registryName, dimensionType);
        this.noiseSettings = noiseSettingsHandler.createPointer(registryName, noiseSettings);
        this.levelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)registryName);
        this.levelStemKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)registryName);
        this.levelStemFactory = (registryAccess, worldGenSettings) -> new LevelStem(registryAccess.m_175515_(Registry.f_122818_).m_206081_(this.dimensionType.getKey()), (ChunkGenerator)chunkGeneratorFactory.apply((RegistryAccess)registryAccess, (WorldGenSettings)worldGenSettings));
        REGISTRARS.add(this);
    }

    public Registrar.Pointer<DimensionType> getType() {
        return this.dimensionType;
    }

    public Registrar.Pointer<NoiseGeneratorSettings> getNoiseSettings() {
        return this.noiseSettings;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    public ResourceKey<LevelStem> getLevelStemKey() {
        return this.levelStemKey;
    }

    public final LevelStem createLevelStem(RegistryAccess registryAccess, WorldGenSettings worldGenSettings) {
        return this.levelStemFactory.apply(registryAccess, worldGenSettings);
    }
}

