/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.capability.entity;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.util.Internal;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;

public class GelEntity
implements IGelEntity {
    public static final ResourceLocation EMPTY = StructureGelMod.locate("empty");
    public static final String PORTAL_KEY = "portal";
    @Nullable
    private GelPortalBlock portal;
    @Nullable
    private static GelPortalBlock portalClient;
    private static int portalTimer;

    @Override
    @Nullable
    public GelPortalBlock getPortal() {
        return this.portal;
    }

    @Override
    public void setPortal(@Nullable GelPortalBlock portal) {
        this.portal = portal;
    }

    @Nullable
    public static GelPortalBlock getPortalClient() {
        return portalClient;
    }

    @Internal
    public static void setPortalClient(Entity entity, GelPortalBlock portal) {
        if (entity.f_19853_.f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == entity) {
                portalClient = portal;
                portalTimer = 60;
            }
        }
    }

    @Internal
    public static void clientTick() {
        if (portalTimer > 0 && --portalTimer == 0) {
            portalClient = null;
        }
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        ResourceLocation name = null;
        if (this.portal != null) {
            name = ForgeRegistries.BLOCKS.getKey((Object)this.portal);
        }
        tag.m_128359_(PORTAL_KEY, name != null ? name.toString() : EMPTY.toString());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.setPortal(this.parsePortal(tag, PORTAL_KEY));
    }

    private GelPortalBlock parsePortal(CompoundTag nbt, String key) {
        GelPortalBlock gelPortalBlock;
        Object object;
        ResourceLocation portal = new ResourceLocation(nbt.m_128461_(key));
        return !portal.equals((Object)EMPTY) && ForgeRegistries.BLOCKS.containsKey(portal) && (object = ForgeRegistries.BLOCKS.getValue(portal)) instanceof GelPortalBlock ? (gelPortalBlock = (GelPortalBlock)((Object)object)) : null;
    }

    static {
        portalTimer = 0;
    }
}

