/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IronGateBlock
extends FenceGateBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final boolean gold;

    public IronGateBlock(BlockBehaviour.Properties properties, boolean gold) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.gold = gold;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean open;
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (CommonConfigs.Building.DOUBLE_IRON_GATE.get().booleanValue() && facing.m_122434_().m_122478_() && facingState.m_60713_((Block)this) && !((Boolean)stateIn.m_61143_((Property)f_53342_)).booleanValue() && (open = ((Boolean)facingState.m_61143_((Property)f_53341_)).booleanValue()) != (Boolean)stateIn.m_61143_((Property)f_53341_) && stateIn.m_61143_((Property)f_54117_) == facingState.m_61143_((Property)f_54117_)) {
            stateIn = (BlockState)stateIn.m_61124_((Property)f_53341_, (Comparable)Boolean.valueOf(open));
        }
        return stateIn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, f_53341_, f_53342_, f_53343_, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        boolean flag = world.m_46753_(blockpos);
        Direction direction = context.m_8125_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)f_53341_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)f_53342_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)f_53343_, (Comparable)Boolean.valueOf(this.canConnect((LevelAccessor)world, blockpos, direction)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? f_53345_ : f_53344_;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        if (!world.f_46443_) {
            boolean flag = world.m_46753_(pos);
            if ((Boolean)state.m_61143_((Property)f_53342_) != flag) {
                state = (BlockState)state.m_61124_((Property)f_53342_, (Comparable)Boolean.valueOf(flag));
                if (!this.gold || !CommonConfigs.Building.CONSISTENT_GATE.get().booleanValue()) {
                    if ((Boolean)state.m_61143_((Property)f_53341_) != flag) {
                        world.m_5898_(null, flag ? 1036 : 1037, pos, 0);
                        world.m_142346_(null, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    state = (BlockState)state.m_61124_((Property)f_53341_, (Comparable)Boolean.valueOf(flag));
                }
            }
            boolean connect = this.canConnect((LevelAccessor)world, pos, (Direction)state.m_61143_((Property)f_54117_));
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53343_, (Comparable)Boolean.valueOf(connect)), 2);
        }
    }

    private boolean canConnect(LevelAccessor world, BlockPos pos, Direction dir) {
        return this.canConnectUp(world.m_8055_(pos.m_7494_()), world, pos.m_7494_()) || this.canConnectSide(world.m_8055_(pos.m_121945_(dir.m_122427_()))) || this.canConnectSide(world.m_8055_(pos.m_121945_(dir.m_122428_())));
    }

    private boolean canConnectSide(BlockState state) {
        return state.m_60734_() instanceof IronBarsBlock;
    }

    private boolean canConnectUp(BlockState state, LevelAccessor world, BlockPos pos) {
        return state.m_60783_((BlockGetter)world, pos, Direction.DOWN) || state.m_60713_((Block)this) || state.m_60734_() instanceof IronBarsBlock;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!((Boolean)state.m_61143_((Property)f_53342_)).booleanValue() && this.gold || !CommonConfigs.Building.CONSISTENT_GATE.get().booleanValue()) {
            Direction dir = player.m_6350_();
            if (CommonConfigs.Building.DOUBLE_IRON_GATE.get().booleanValue()) {
                BlockPos down;
                BlockState stateDown;
                BlockPos up = pos.m_7494_();
                BlockState stateUp = world.m_8055_(up);
                if (stateUp.m_60713_((Block)this) && stateUp.m_61124_((Property)f_53343_, (Comparable)Boolean.valueOf(false)) == state.m_61124_((Property)f_53343_, (Comparable)Boolean.valueOf(false))) {
                    this.openGate(stateUp, world, up, dir);
                }
                if ((stateDown = world.m_8055_(down = pos.m_7495_())).m_60713_((Block)this) && stateDown.m_61124_((Property)f_53343_, (Comparable)Boolean.valueOf(false)) == state.m_61124_((Property)f_53343_, (Comparable)Boolean.valueOf(false))) {
                    this.openGate(stateDown, world, down, dir);
                }
            }
            this.openGate(state, world, pos, dir);
            boolean open = (Boolean)state.m_61143_((Property)f_53341_);
            world.m_5898_(player, open ? 1036 : 1037, pos, 0);
            world.m_142346_((Entity)player, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void openGate(BlockState state, Level world, BlockPos pos, Direction dir) {
        if (((Boolean)state.m_61143_((Property)f_53341_)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)f_53341_, (Comparable)Boolean.FALSE);
        } else {
            if (state.m_61143_((Property)f_54117_) == dir.m_122424_()) {
                state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)dir);
            }
            state = (BlockState)state.m_61124_((Property)f_53341_, (Comparable)Boolean.TRUE);
        }
        world.m_7731_(pos, state, 10);
    }

    public static BlockState messWithIronBarsState(LevelAccessor level, BlockPos clickedPos, BlockState returnValue) {
        boolean altered = false;
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockState blockState;
            BooleanProperty prop = (BooleanProperty)CrossCollisionBlock.f_52314_.get(d);
            if (((Boolean)returnValue.m_61143_((Property)prop)).booleanValue() || !((blockState = level.m_8055_(clickedPos.m_121945_(d))).m_60734_() instanceof FenceGateBlock) || ((Direction)blockState.m_61143_((Property)FenceGateBlock.f_54117_)).m_122434_() == d.m_122434_()) continue;
            altered = true;
            returnValue = (BlockState)returnValue.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return altered ? returnValue : null;
    }
}

