/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.blocks.InitializableBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.properties.IToolProvider;

@ParametersAreNonnullByDefault
public class ForgedCrateBlock
extends FallingBlock
implements InitializableBlock,
IInteractiveBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty propFacing = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty propStacked = BooleanProperty.m_61465_((String)"stacked");
    public static final IntegerProperty propIntegrity = IntegerProperty.m_61631_((String)"integrity", (int)0, (int)3);
    public static final ResourceLocation interactionLootTable = new ResourceLocation("tetra", "forged/crate_content");
    public static final String identifier = "forged_crate";
    static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(TetraToolActions.pry, 1, Direction.EAST, 6.0f, 8.0f, 6.0f, 8.0f, BlockStatePredicate.f_61281_, ForgedCrateBlock::attemptBreakPry), new BlockInteraction(TetraToolActions.hammer, 3, Direction.EAST, 1.0f, 4.0f, 1.0f, 4.0f, BlockStatePredicate.f_61281_, ForgedCrateBlock::attemptBreakHammer), new BlockInteraction(TetraToolActions.hammer, 3, Direction.EAST, 10.0f, 13.0f, 10.0f, 13.0f, BlockStatePredicate.f_61281_, ForgedCrateBlock::attemptBreakHammer)};
    private static final VoxelShape shape = ForgedCrateBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final VoxelShape[] shapesNormal = new VoxelShape[4];
    private static final VoxelShape[] shapesOffset = new VoxelShape[4];

    public ForgedCrateBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)ForgedBlockCommon.forgedMaterial).m_60918_(SoundType.f_56743_).m_60978_(5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)propFacing, (Comparable)Direction.EAST)).m_61124_((Property)propStacked, (Comparable)Boolean.valueOf(false))).m_61124_((Property)propIntegrity, (Comparable)Integer.valueOf(3))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean attemptBreakHammer(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction facing) {
        return ForgedCrateBlock.attemptBreak(world, pos, blockState, player, hand, player.m_21120_(hand), TetraToolActions.hammer, 2, 1);
    }

    private static boolean attemptBreakPry(Level world, BlockPos pos, BlockState blockState, Player player, InteractionHand hand, Direction facing) {
        return ForgedCrateBlock.attemptBreak(world, pos, blockState, player, hand, player.m_21120_(hand), TetraToolActions.pry, 0, 2);
    }

    private static boolean attemptBreak(Level world, BlockPos pos, BlockState blockState, @Nullable Player player, @Nullable InteractionHand hand, ItemStack itemStack, ToolAction toolAction, int min, int multiplier) {
        int progress;
        if (player == null) {
            return false;
        }
        int integrity = (Integer)blockState.m_61143_((Property)propIntegrity);
        if (integrity - (progress = CastOptional.cast((Object)itemStack.m_41720_(), IToolProvider.class).map(item -> item.getToolLevel(itemStack, toolAction)).map(level -> (level - min) * multiplier).orElse(1).intValue()) >= 0) {
            if (TetraToolActions.hammer.equals(toolAction)) {
                world.m_5594_(player, pos, SoundEvents.f_12600_, SoundSource.PLAYERS, 1.0f, 0.5f);
            } else {
                world.m_5594_(player, pos, SoundEvents.f_12024_, SoundSource.PLAYERS, 0.7f, 2.0f);
            }
            world.m_46597_(pos, (BlockState)blockState.m_61124_((Property)propIntegrity, (Comparable)Integer.valueOf(integrity - progress)));
        } else {
            boolean didBreak = EffectHelper.breakBlock(world, player, itemStack, pos, blockState, false);
            if (didBreak && world instanceof ServerLevel) {
                BlockInteraction.getLoot(interactionLootTable, player, hand, (ServerLevel)world, blockState).forEach(lootStack -> ForgedCrateBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)lootStack));
            }
        }
        return true;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState state, Direction face, Collection<ToolAction> tools) {
        return interactions;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{propFacing, propStacked, propIntegrity, BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)propFacing, (Comparable)context.m_8125_())).m_61124_((Property)propStacked, (Comparable)Boolean.valueOf(this.equals(context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60734_())))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (Direction.DOWN.equals((Object)facing)) {
            return (BlockState)super.m_7417_(state, facing, facingState, world, currentPos, facingPos).m_61124_((Property)propStacked, (Comparable)Boolean.valueOf(this.equals(facingState.m_60734_())));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.m_61143_((Property)propStacked)).booleanValue()) {
            return shapesNormal[((Direction)state.m_61143_((Property)propFacing)).m_122416_()];
        }
        return shapesOffset[((Direction)state.m_61143_((Property)propFacing)).m_122416_()];
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)propFacing, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)propFacing)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)propFacing)));
    }

    static {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ForgedCrateBlock.shapesNormal[dir.m_122416_()] = shape.m_83216_((double)((float)dir.m_122429_() / 16.0f), (double)((float)dir.m_122430_() / 16.0f), (double)((float)dir.m_122431_() / 16.0f));
            ForgedCrateBlock.shapesOffset[dir.m_122416_()] = shapesNormal[dir.m_122416_()].m_83216_(0.0, -0.125, 0.0);
        }
    }
}

