/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.tile.VendingMachineBlockEntityBase;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendingMachineBlockEntity
extends VendingMachineBlockEntityBase {
    private EnumMap<Direction, LazyOptional<IItemHandler>> itemCaps = new EnumMap(Direction.class);
    private InvWrapper inputWr = new InvWrapper((Container)this.getInputs());
    private InvWrapper outputWr = new InvWrapper((Container)this.getOutputs());

    public VendingMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
        for (Direction d : Direction.values()) {
            this.itemCaps.put(d, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new Handler(d)));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return LazyOptional.empty();
            }
            return this.itemCaps.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public class Handler
    implements IItemHandler {
        private final Direction dir;

        public Handler(Direction dir) {
            this.dir = dir;
        }

        public int getSlots() {
            return VendingMachineBlockEntity.this.inputWr.getSlots() + VendingMachineBlockEntity.this.outputWr.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return slot < VendingMachineBlockEntity.this.inputWr.getSlots() ? VendingMachineBlockEntity.this.inputWr.getStackInSlot(slot) : VendingMachineBlockEntity.this.outputWr.getStackInSlot(slot - VendingMachineBlockEntity.this.inputWr.getSlots());
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot >= VendingMachineBlockEntity.this.inputWr.getSlots() || !VendingMachineBlockEntity.this.canInput(stack, this.dir)) {
                return stack;
            }
            return VendingMachineBlockEntity.this.inputWr.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < VendingMachineBlockEntity.this.inputWr.getSlots() || !VendingMachineBlockEntity.this.canOutput(this.dir)) {
                return ItemStack.f_41583_;
            }
            return VendingMachineBlockEntity.this.outputWr.extractItem(slot - VendingMachineBlockEntity.this.inputWr.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot >= VendingMachineBlockEntity.this.inputWr.getSlots() && VendingMachineBlockEntity.this.canInput(stack, this.dir);
        }
    }
}

