/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading;

import com.tom.trading.Content;
import com.tom.trading.Platform;
import com.tom.trading.TradingNetworkModClient;
import com.tom.trading.block.AlwaysActivatableBlock;
import com.tom.trading.network.NetworkHandler;
import com.tom.trading.top.TheOneProbeHandler;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toms_trading_network")
public class TradingNetworkMod {
    public static final String MODID = "toms_trading_network";
    public static final Logger LOGGER = LogManager.getLogger((String)"toms_trading_network");

    public TradingNetworkMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TradingNetworkModClient::preInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Content.init();
        Platform.register();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Tom's Trading Network Setup starting");
        NetworkHandler.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        TradingNetworkModClient.clientSetup();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        AlwaysActivatableBlock aab;
        Block block;
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (!event.getEntity().m_36341_() && (block = state.m_60734_()) instanceof AlwaysActivatableBlock && (aab = (AlwaysActivatableBlock)block).onActivate(state, event.getLevel(), event.getPos(), event.getEntity(), event.getHand(), event.getHitVec())) {
            event.setCanceled(true);
        }
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> TheOneProbeHandler.create());
        }
    }
}

