/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.trading.Content;
import com.tom.trading.gui.AbstractFilteredScreen;
import com.tom.trading.gui.GuiButton;
import com.tom.trading.gui.PhantomSlot;
import com.tom.trading.gui.PlatformButton;
import com.tom.trading.gui.PlatformEditBox;
import com.tom.trading.gui.VendingMachineConfigMenu;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.PopupMenuManager;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VendingMachineConfigScreen
extends AbstractFilteredScreen<VendingMachineConfigMenu> {
    private static final ResourceLocation gui = new ResourceLocation("toms_trading_network", "textures/gui/vending_machine_config.png");
    private PlatformEditBox nameBox;
    private Component title;
    private EnumMap<BlockFaceDirection, GuiButton> sideCfgButtons = new EnumMap(BlockFaceDirection.class);
    private PopupMenuManager popup = new PopupMenuManager((Screen)this);

    public VendingMachineConfigScreen(VendingMachineConfigMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.title = pTitle;
        pMenu.updateGui = this::updateGui;
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)gui);
        this.m_93228_(pPoseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < 8; ++i) {
            Slot s = ((VendingMachineConfigMenu)this.f_97732_).m_38853_(i);
            if (s.m_7993_().m_41619_() || (((VendingMachineConfigMenu)this.f_97732_).matchNBT & 1 << i) != 0 && s.m_7993_().m_41720_() != Content.TAG_FILTER.get()) continue;
            this.m_93228_(pPoseStack, this.f_97735_ + s.f_40220_ - 1, this.f_97736_ + s.f_40221_ - 1, 176, 16, 18, 18);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        VendingMachineConfigScreen.m_93200_((PoseStack)pPoseStack, (int)(this.f_97735_ + 134), (int)(this.f_97736_ + 46), (int)0, (int)16, (int)16, (TextureAtlasSprite)this.f_96541_.m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(new ResourceLocation("toms_trading_network", "block/vending_machine_front")));
    }

    protected void m_7856_() {
        this.f_97726_ = 176;
        this.f_97727_ = 211;
        this.f_97731_ = this.f_97727_ - 92;
        this.sideCfgButtons.clear();
        super.m_7856_();
        this.nameBox = new PlatformEditBox(this.f_96547_, this.f_97735_ + 7, this.f_97736_ + 7, 110, 16, (Component)Component.m_237115_((String)"narrator.toms_trading_network.vending_machine_name"));
        this.m_142416_((GuiEventListener)this.nameBox);
        this.nameBox.m_94144_(this.title.getString());
        this.nameBox.m_94151_(this::onNameChanged);
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            GuiButton btn = new GuiButton(this.f_97735_ + 118 + d.getX() * 16, this.f_97736_ + 30 + d.getY() * 16, 0, b -> {
                int ns = (this.getFacingState(d) + 1) % 4;
                this.sendButtonClick(ns | d.ordinal() << 2 | 0x20);
            });
            btn.texture = gui;
            btn.texX = 176;
            this.sideCfgButtons.put(d, btn);
            this.m_142416_((GuiEventListener)btn);
        }
        this.updateGui();
        this.m_142416_((GuiEventListener)new PlatformButton(this.f_97735_ + 120, this.f_97736_ + 7, 50, 20, (Component)Component.m_237115_((String)"button.toms_trading_network.vending_machine.open_trading"), b -> this.sendButtonClick(64)));
    }

    private void onNameChanged(String name) {
        ((VendingMachineConfigMenu)this.f_97732_).setName(name);
        this.title = Component.m_237113_((String)name);
    }

    private void sendMatchNBT(int slot, boolean config) {
        this.sendButtonClick(0x60 | (config ? 16 : 0) | slot & 0xF);
    }

    private void sendButtonClick(int pPageData) {
        this.f_96541_.f_91072_.m_105208_(((VendingMachineConfigMenu)this.f_97732_).f_38840_, pPageData);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.popup.render(pPoseStack, pMouseX, pMouseY)) {
            this.m_7025_(pPoseStack, pMouseX, pMouseY);
            for (BlockFaceDirection d : BlockFaceDirection.values()) {
                GuiButton b;
                if (d == BlockFaceDirection.FRONT || !(b = this.sideCfgButtons.get((Object)d)).m_198029_()) continue;
                this.m_96617_(pPoseStack, Arrays.asList(Component.m_237115_((String)("tooltip.toms_trading_network.side." + d.name().toLowerCase())).m_7532_(), Component.m_237115_((String)("tooltip.toms_trading_network.side_config" + b.state)).m_7532_()), pMouseX, pMouseY);
            }
        }
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.f_96547_.m_92889_(pPoseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
        this.f_96547_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)"label.toms_trading_network.vending_machine.cost"), (float)this.f_97730_, 26.0f, 0x404040);
        this.f_96547_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)"label.toms_trading_network.vending_machine.result"), 76.0f, 26.0f, 0x404040);
        this.f_96547_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)"label.toms_trading_network.vending_machine.input"), (float)this.f_97730_, 72.0f, 0x404040);
        this.f_96547_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)"label.toms_trading_network.vending_machine.output"), 98.0f, 72.0f, 0x404040);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.popup.mouseClick(pMouseX, pMouseY, pButton)) {
            return true;
        }
        Slot clicked = this.getSlotUnderMouse();
        if (pButton == 1 && clicked instanceof PhantomSlot && !clicked.m_7993_().m_41619_()) {
            int popupSlot = clicked.m_150661_();
            boolean tagFilter = clicked.m_7993_().m_41720_() == Content.TAG_FILTER.get();
            List<String> tags = clicked.m_7993_().m_204131_().map(t -> t.f_203868_().toString()).toList();
            this.nameBox.m_94178_(false);
            this.popup.open(pMouseX, pMouseY, new PopupMenuManager.TextFieldElement(() -> Component.m_237115_((String)"tooltip.toms_trading_network.item_count"), s -> {
                try {
                    int c = Integer.parseInt(s);
                    ((VendingMachineConfigMenu)this.f_97732_).setConfigCount(clicked, c);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }, this.f_96547_, Integer.toString(clicked.m_7993_().m_41613_())), new PopupMenuManager.ButtonElement(() -> tagFilter ? Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{CommonComponents.f_130658_}).m_130940_(ChatFormatting.DARK_GRAY)) : Component.m_237110_((String)"tooltip.toms_trading_network.match_nbt", (Object[])new Object[]{(((VendingMachineConfigMenu)this.f_97732_).matchNBT & 1 << popupSlot) != 0 ? CommonComponents.f_130657_ : CommonComponents.f_130658_}), () -> {
                ((VendingMachineConfigMenu)this.f_97732_).matchNBT ^= 1 << popupSlot;
                this.sendMatchNBT(popupSlot, (((VendingMachineConfigMenu)this.f_97732_).matchNBT & 1 << popupSlot) != 0);
            }), new PopupMenuManager.ButtonElement(() -> tagFilter || tags.isEmpty() ? Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.toms_trading_network.to_tag_filter").m_130940_(ChatFormatting.DARK_GRAY)) : Component.m_237115_((String)"tooltip.toms_trading_network.to_tag_filter"), () -> {
                if (!tags.isEmpty()) {
                    this.popup.replace((PopupMenuManager.PopupElement[])tags.stream().map(s -> new PopupMenuManager.ButtonElement(() -> Component.m_237113_((String)s), () -> {
                        ItemStack st = new ItemStack((ItemLike)Content.TAG_FILTER.get(), clicked.m_7993_().m_41613_());
                        st.m_41784_().m_128359_("tag", s);
                        ((VendingMachineConfigMenu)this.f_97732_).setPhantom(clicked, st);
                        this.popup.close();
                    })).toArray(PopupMenuManager.PopupElement[]::new));
                }
            }));
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.popup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 256) {
            if (this.nameBox.m_93696_()) {
                this.nameBox.m_94178_(false);
            } else {
                this.f_96541_.f_91074_.m_6915_();
            }
            return true;
        }
        if (pKeyCode == 258) {
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        return !this.nameBox.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.nameBox.m_94204_() ? super.m_7933_(pKeyCode, pScanCode, pModifiers) : true;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.popup.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    private void updateGui() {
        for (BlockFaceDirection d : BlockFaceDirection.values()) {
            if (d == BlockFaceDirection.FRONT) continue;
            GuiButton b = this.sideCfgButtons.get((Object)d);
            b.state = this.getFacingState(d);
        }
    }

    private int getFacingState(BlockFaceDirection d) {
        return ((((VendingMachineConfigMenu)this.f_97732_).inputCfg & 1 << d.ordinal()) != 0 ? 1 : 0) | ((((VendingMachineConfigMenu)this.f_97732_).outputCfg & 1 << d.ordinal()) != 0 ? 2 : 0);
    }
}

