/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpectralConsumeParticle
extends TextureSheetParticle {
    protected final SpriteSet animatedSprite;
    private final float scale = this.f_107663_ = this.f_107223_.m_188501_() * 0.6f + 0.2f;
    private final int MAX_FRAME_ID = 3;
    protected int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    public SpectralConsumeParticle(SpriteSet animatedSprite, ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107215_ = motionX * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.01f;
        this.f_107216_ = motionY * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.01f;
        this.f_107217_ = motionZ * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.01f;
        this.f_107225_ = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.animatedSprite = animatedSprite;
        this.m_108339_(animatedSprite);
    }

    public void m_5744_(VertexConsumer p_225606_1_, Camera activeInfo, float partialTicks) {
        Entity entity = activeInfo.m_90592_();
        if (entity.f_19797_ >= this.lastTick + 5) {
            if (this.currentFrame == 3) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.f_19797_;
        }
        float f = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107663_ = this.scale * (1.0f - f * f * 0.5f);
        super.m_5744_(p_225606_1_, activeInfo, partialTicks);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        if (this.m_107276_()) {
            this.m_108339_(this.animatedSprite);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float partialTick) {
        float f = ((float)this.f_107224_ + partialTick) / (float)this.f_107225_;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        int i = super.m_6355_(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpectralConsumeParticle(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

