/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SearocketFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Supplier<BlockState> SEAROCKET(boolean pink) {
        return pink ? () -> ((Block)UABlocks.PINK_SEAROCKET.get()).m_49966_() : () -> ((Block)UABlocks.WHITE_SEAROCKET.get()).m_49966_();
    }

    public SearocketFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        if ((double)((Biome)worldIn.m_204166_(pos).m_203334_()).m_47554_() < 0.2) {
            boolean colorType;
            boolean bl = colorType = rand.m_188501_() <= 0.25f;
            if (SearocketFeature.SEAROCKET(colorType).get().m_60710_((LevelReader)worldIn, pos)) {
                this.generateSearocketPatch((LevelAccessor)worldIn, pos, colorType, rand.m_188503_(8));
                return true;
            }
        } else {
            boolean colorType;
            boolean bl = colorType = rand.m_188501_() <= 0.75f;
            if (SearocketFeature.SEAROCKET(colorType).get().m_60710_((LevelReader)worldIn, pos)) {
                this.generateSearocketPatch((LevelAccessor)worldIn, pos, colorType, rand.m_188503_(8));
                return true;
            }
        }
        return false;
    }

    public void generateSearocketPatch(LevelAccessor world, BlockPos pos, boolean pink, int randomDesign) {
        int[] patterns = new int[3];
        switch (randomDesign) {
            default: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 1: {
                patterns[0] = 2;
                patterns[1] = 8;
                patterns[2] = 5;
            }
            case 2: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 7;
            }
            case 3: {
                patterns[0] = 3;
                patterns[1] = 13;
                patterns[2] = 12;
            }
            case 4: {
                patterns[0] = 3;
                patterns[1] = 12;
                patterns[2] = 12;
            }
            case 5: {
                patterns[0] = 2;
                patterns[1] = 12;
                patterns[2] = 12;
            }
            case 6: {
                patterns[0] = 3;
                patterns[1] = 5;
                patterns[2] = 3;
            }
            case 7: 
        }
        patterns[0] = 3;
        patterns[1] = 3;
        patterns[2] = 6;
        BlockPos startPos = pos;
        MathUtil.Equation r = theta -> (Math.cos((double)patterns[1] * theta) / (double)patterns[2] + 1.0) * (double)patterns[0];
        if (!(world.m_46859_(startPos.m_7495_()) || world.m_46859_(startPos.m_6625_(2)) || world.m_46859_(startPos.m_6625_(3)))) {
            int repeatsDown = world.m_213780_().m_188503_(2) + 2;
            for (int repeats = 0; repeats < repeatsDown; ++repeats) {
                pos = pos.m_7918_(0, -repeats, 0);
                for (int i = -(patterns[0] / patterns[2] + patterns[0]); i < patterns[0] / patterns[2] + patterns[0]; ++i) {
                    for (int j = -(patterns[0] / patterns[2] + patterns[0]); j < patterns[0] / patterns[2] + patterns[0]; ++j) {
                        double radius = r.compute(Math.atan2(j, i));
                        BlockPos placingPos = pos.m_7918_(i, 0, j);
                        if (!world.m_8055_(placingPos).m_60767_().m_76336_() || !((double)(i * i + j * j) < radius * radius) || !SearocketFeature.SEAROCKET(pink).get().m_60710_((LevelReader)world, placingPos) || !world.m_6425_(placingPos).m_76178_()) continue;
                        world.m_7731_(placingPos, SearocketFeature.SEAROCKET(pink).get(), 2);
                    }
                }
            }
        }
    }
}

