/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.mpfui.renderable;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.mpfui.component.HorizontalAlignment;
import io.github.mortuusars.mpfui.component.TooltipBehavior;
import io.github.mortuusars.mpfui.renderable.MPFRenderable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockRenderable
extends MPFRenderable<TextBlockRenderable> {
    private final Supplier<Component> textSupplier;
    private final int maxLines;
    @Nullable
    private Integer color;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private TooltipBehavior tooltipBehavior = TooltipBehavior.REGULAR_AND_LEFTOVER;
    private List<FormattedCharSequence> leftoverTooltipLines = new ArrayList<FormattedCharSequence>();
    private final List<FormattedCharSequence> tooltipSeparatorLines;

    public TextBlockRenderable(Component text, int x, int y, int width, int height) {
        this(() -> text, x, y, width, height);
    }

    public TextBlockRenderable(Supplier<Component> textSupplier, int x, int y, int width, int height) {
        super(x, y, width, height, textSupplier.get());
        this.tooltipSeparatorLines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)"\n-\n"), 30);
        this.textSupplier = textSupplier;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.maxLines = height / 9;
    }

    public static int getDesiredHeight(Component text, int width, int maxLines) {
        Font font = Minecraft.m_91087_().f_91062_;
        List split = font.m_92923_((FormattedText)text, width);
        int lines = Math.min(split.size(), maxLines);
        Objects.requireNonNull(font);
        return lines * 9;
    }

    @Override
    public TextBlockRenderable getThis() {
        return this;
    }

    public TextBlockRenderable setAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public TextBlockRenderable setTooltipBehavior(TooltipBehavior tooltipBehavior) {
        this.tooltipBehavior = tooltipBehavior;
        return this;
    }

    public TextBlockRenderable setDefaultColor(@Nullable Integer color) {
        this.color = color;
        return this;
    }

    private int getColor() {
        return this.color != null ? this.color : 0;
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible(poseStack, mouseX, mouseY)) {
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            this.renderText(poseStack, mouseX, mouseY, partialTick);
            if (this.f_93622_) {
                this.m_7428_(poseStack, mouseX, mouseY);
            }
        }
    }

    protected void renderText(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        boolean hasLeftoverLines;
        Font font = Minecraft.m_91087_().f_91062_;
        Component text = this.textSupplier.get();
        List lines = font.m_92923_((FormattedText)text, this.f_93618_);
        boolean bl = hasLeftoverLines = lines.size() > this.maxLines;
        if (hasLeftoverLines) {
            this.leftoverTooltipLines = new ArrayList<FormattedCharSequence>(lines.stream().skip(this.maxLines).toList());
            this.leftoverTooltipLines.set(0, FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)"...", (Style)text.m_7383_()), (FormattedCharSequence)this.leftoverTooltipLines.get(0)));
        } else {
            this.leftoverTooltipLines.clear();
        }
        for (int lineIndex = 0; lineIndex < Math.min(lines.size(), this.maxLines); ++lineIndex) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(lineIndex);
            if (lineIndex + 1 == this.maxLines && hasLeftoverLines) {
                line = FormattedCharSequence.m_13696_((FormattedCharSequence)line, (FormattedCharSequence)FormattedCharSequence.m_13714_((String)"...", (Style)text.m_7383_()));
            }
            int lineWidth = font.m_92724_(line);
            float lineX = this.horizontalAlignment == HorizontalAlignment.RIGHT ? (float)(this.f_93620_ + (this.f_93618_ - lineWidth)) : (this.horizontalAlignment == HorizontalAlignment.CENTER ? (float)this.f_93620_ + ((float)this.f_93618_ / 2.0f - (float)lineWidth / 2.0f) : (float)this.f_93620_);
            Objects.requireNonNull(font);
            font.m_92877_(poseStack, line, lineX, (float)(this.f_93621_ + lineIndex * 9), this.getColor());
        }
    }

    @Override
    public void m_7428_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        if (this.tooltipBehavior == TooltipBehavior.NONE) {
            return;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return;
        }
        if (this.tooltipBehavior == TooltipBehavior.LEFTOVER_ONLY) {
            screen.m_96617_(poseStack, this.leftoverTooltipLines, mouseX, mouseY);
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        List regularTooltipLines = font.m_92923_((FormattedText)this.tooltip.get(), this.tooltipWidth);
        if (this.tooltipBehavior == TooltipBehavior.REGULAR_ONLY && regularTooltipLines.size() > 0) {
            screen.m_96617_(poseStack, regularTooltipLines, mouseX, mouseY);
        } else {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            if (regularTooltipLines.size() > 0) {
                lines.addAll(regularTooltipLines);
                lines.addAll(this.tooltipSeparatorLines);
            }
            if (this.tooltipBehavior == TooltipBehavior.FULL) {
                lines.addAll(font.m_92923_((FormattedText)this.textSupplier.get(), this.tooltipWidth));
            } else if (this.tooltipBehavior == TooltipBehavior.REGULAR_AND_LEFTOVER && this.leftoverTooltipLines.size() > 0) {
                lines.addAll(this.leftoverTooltipLines);
            }
            screen.m_96617_(poseStack, lines, mouseX, mouseY);
        }
    }
}

