/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.block;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.entity.PackageBlockEntity;
import io.github.mortuusars.wares.config.Config;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape SHAPE_X = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)6.0, (double)12.0);
    public static final VoxelShape SHAPE_Y = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)6.0, (double)13.0);

    public PackageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? SHAPE_X : SHAPE_Y;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PackageBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof PackageBlockEntity) {
                    PackageBlockEntity packageBE = (PackageBlockEntity)blockEntity;
                    if (packageBE.unpacksWhenBroken()) {
                        List<ItemStack> items = packageBE.getPackage().getItems(serverLevel, Vec3.m_82512_((Vec3i)pos));
                        for (ItemStack item : items) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)item.m_41777_());
                        }
                        level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)Wares.SoundEvents.PAPER_TEAR.get(), SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() * 0.5f + 0.8f);
                    } else {
                        ItemStack stack = new ItemStack((ItemLike)Wares.Items.PACKAGE.get());
                        stack.m_41751_(packageBE.getPackage().toTag(new CompoundTag()));
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                    }
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public PushReaction m_5537_(@NotNull BlockState state) {
        return (Boolean)Config.PACKAGE_PISTON_DESTROY.get() != false ? PushReaction.DESTROY : super.m_5537_(state);
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState pState, @NotNull Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && player.m_36341_() && ((Boolean)Config.PACKAGE_SNEAK_PREVENTS_UNPACKING.get()).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            packageBlockEntity.setUnpacksWhenBroken(false);
        }
        super.m_5707_(level, pos, pState, player);
    }
}

