/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.block.entity;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.advancement.DeliveryTableTrigger;
import io.github.mortuusars.wares.block.DeliveryTableBlock;
import io.github.mortuusars.wares.block.entity.AgreementTableLock;
import io.github.mortuusars.wares.block.entity.Deliverability;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.data.agreement.AgreementType;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.item.DeliveryAgreementItem;
import io.github.mortuusars.wares.menu.DeliveryTableMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeliveryTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int SLOTS = 14;
    public static final int AGREEMENT_SLOT = 0;
    public static final int BOX_SLOT = 1;
    public static final int[] AGREEMENT_SLOTS = new int[]{0};
    public static final int[] AGREEMENT_PLUS_PACKAGES_SLOTS = new int[]{0, 1};
    public static final int[] INPUT_PLUS_AGREEMENT_PLUS_PACKAGES_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int[] INPUT_PLUS_PACKAGES_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final int[] INPUT_SLOTS = new int[]{2, 3, 4, 5, 6, 7};
    public static final int[] OUTPUT_SLOTS = new int[]{8, 9, 10, 11, 12, 13};
    public static final int[] INPUT_PLUS_OUTPUT_SLOTS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    public static final int PACKAGER_WORK_RADIUS = 3;
    public static final int PACKAGER_LAST_WORK_THRESHOLD = 800;
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int CONTAINER_DATA_PROGRESS = 0;
    public static final int CONTAINER_DATA_DURATION = 1;
    public static final int CONTAINER_DATA_CAN_DELIVER_MANUALLY = 2;
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> DeliveryTableBlockEntity.this.progress;
                case 1 -> DeliveryTableBlockEntity.this.getDeliveryTime();
                case 2 -> {
                    if (((Boolean)Config.MANUAL_DELIVERY_ALLOWED.get()).booleanValue() && DeliveryTableBlockEntity.this.canDeliverManually) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int id, int value) {
            if (id == 0) {
                DeliveryTableBlockEntity.this.progress = value;
            } else if (id == 2) {
                DeliveryTableBlockEntity.this.canDeliverManually = (Boolean)Config.MANUAL_DELIVERY_ALLOWED.get() != false && value == 1;
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    protected final ItemStackHandler inventory;
    protected LazyOptional<IItemHandlerModifiable>[] inventoryHandlers;
    protected int progress = 0;
    protected boolean canDeliverManually = false;
    protected boolean deliveringManually = false;
    protected DeliveryAgreement agreement = DeliveryAgreement.EMPTY;
    protected boolean voidAgreementOnBreak;
    protected AgreementTableLock agreementLock = new AgreementTableLock(this);
    protected UUID ownerUUID = Util.f_137441_;
    private final SimpleContainer outputSpaceCheckContainer = new SimpleContainer(6);

    public DeliveryTableBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Wares.BlockEntities.DELIVERY_TABLE.get(), pos, blockState);
        this.inventory = this.createInventory(14);
        this.inventoryHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH});
    }

    public void serverTick() {
        int deliveredPackages;
        if (this.f_58857_ == null) {
            return;
        }
        this.convertAgreementStackIfNeeded();
        ItemStack agreementItem = this.getAgreementItem();
        if (!agreementItem.m_150930_((Item)Wares.Items.DELIVERY_AGREEMENT.get())) {
            if (this.progress > 0) {
                this.resetProgress();
                this.m_6596_();
            }
            if (((Boolean)Config.MOVE_COMPLETED_AGREEMENT_TO_OUTPUT.get()).booleanValue() && agreementItem.m_150930_((Item)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get())) {
                ItemStack agreementStack = this.getAgreementItem();
                for (int outputSlot : OUTPUT_SLOTS) {
                    if (!this.m_8020_(outputSlot).m_41619_()) continue;
                    this.m_6836_(outputSlot, agreementStack);
                    this.setAgreementItem(ItemStack.f_41583_);
                    break;
                }
            }
            return;
        }
        int prevProgress = this.progress;
        Deliverability deliverability = this.getDeliverability();
        if (deliverability == Deliverability.CAN_DELIVER) {
            boolean packagerWorkingAtTable = this.isPackagerWorkingAtTable();
            if (!this.deliveringManually && ((Boolean)Config.PACKAGER_REQUIRED.get()).booleanValue() && !packagerWorkingAtTable) {
                this.canDeliverManually = (Boolean)Config.MANUAL_DELIVERY_ALLOWED.get();
                return;
            }
            this.canDeliverManually = false;
            if (this.deliveringManually && packagerWorkingAtTable) {
                double completion = (double)this.progress / (double)this.getDeliveryTime();
                this.progress = Math.round((float)((double)this.agreement.getDeliveryTimeOrDefault() * completion));
                this.deliveringManually = false;
            }
            ++this.progress;
        } else if (deliverability != Deliverability.NO_SPACE_FOR_OUTPUT) {
            this.resetProgress();
        }
        if (this.progress >= this.getDeliveryTime() && (deliveredPackages = this.deliver(this.getBatchSize())) > 0) {
            this.onBatchDelivered(deliveredPackages);
        }
        if (prevProgress != this.progress) {
            this.m_6596_();
        }
    }

    private void onBatchDelivered(int deliveredBatches) {
        if (this.f_58857_ == null) {
            return;
        }
        this.deliveringManually = false;
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)Wares.SoundEvents.CARDBOARD_FALL.get(), SoundSource.BLOCKS, 0.85f, this.f_58857_.m_213780_().m_188501_() * 0.1f + 0.95f);
        if (!this.getAgreement().isInfinite()) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)Wares.SoundEvents.WRITING.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.m_213780_().m_188501_() * 0.1f + 0.95f);
        }
        this.triggerAdvancement(Wares.AdvancementTriggers.BATCH_DELIVERED);
        Optional<Villager> worker = this.getPackagerWorker(16);
        if (worker.isPresent()) {
            Villager packager = worker.get();
            int xp = packager.m_7809_() + deliveredBatches;
            packager.m_35546_(xp);
            int villagerLevel = packager.m_7141_().m_35576_();
            if (VillagerData.m_35582_((int)villagerLevel) && xp >= Config.getMaxXpPerLevel(villagerLevel)) {
                this.f_58857_.m_6269_(null, (Entity)packager, SoundEvents.f_12275_, SoundSource.NEUTRAL, 0.75f, 1.0f);
                packager.f_35374_ = true;
                packager.f_35373_ = 30;
            }
        }
    }

    protected boolean isPackagerWorkingAtTable() {
        Optional<Villager> worker = this.getPackagerWorker(3);
        if (worker.isEmpty()) {
            return false;
        }
        if (!((Boolean)Config.PACKAGER_SHOULD_BE_WORKING.get()).booleanValue()) {
            return true;
        }
        Villager packager = worker.get();
        long lastWorkedAt = packager.m_6274_().m_21952_(MemoryModuleType.f_26330_).orElse(-1L);
        if (lastWorkedAt < 0L) {
            return false;
        }
        assert (this.f_58857_ != null);
        int timeSinceLastWork = (int)(this.f_58857_.m_46467_() - lastWorkedAt);
        return timeSinceLastWork < 800;
    }

    public Optional<Villager> getPackagerWorker(int radius) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            throw new IllegalStateException("Should not be called client-side. Only server has info about villager job site.");
        }
        List villagersInRadius = this.f_58857_.m_45976_(Villager.class, new AABB(this.m_58899_()).m_82400_((double)radius));
        for (Villager villager : villagersInRadius) {
            Optional jobSiteMemory;
            if (villager.m_7141_().m_35571_() != Wares.Villagers.PACKAGER.get() || !(jobSiteMemory = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_)).isPresent() || !((GlobalPos)jobSiteMemory.get()).m_122646_().equals((Object)this.m_58899_())) continue;
            return Optional.of(villager);
        }
        return Optional.empty();
    }

    public DeliveryAgreement getAgreement() {
        return this.agreement;
    }

    public int getBatchSize() {
        Optional<Villager> worker = this.getPackagerWorker(3);
        int packages = (Boolean)Config.DELIVERIES_REQUIRE_BOXES.get() != false ? this.m_8020_(1).m_41613_() : Integer.MAX_VALUE;
        int villagerLevel = worker.map(villager -> villager.m_7141_().m_35576_()).orElse(1);
        return Math.min(packages, Config.getBatchSizeForLevel(villagerLevel));
    }

    protected int getDeliveryTime() {
        int time = this.agreement.getDeliveryTimeOrDefault();
        return this.deliveringManually ? Math.round((float)time * ((Double)Config.MANUAL_DELIVERY_TIME_MODIFIER.get()).floatValue()) : time;
    }

    protected void resetProgress() {
        this.progress = 0;
        this.deliveringManually = false;
        this.canDeliverManually = false;
    }

    public void startManualDelivery() {
        if (((Boolean)Config.MANUAL_DELIVERY_ALLOWED.get()).booleanValue() && this.canDeliverManually && !this.deliveringManually && !this.isPackagerWorkingAtTable() && this.getDeliverability() == Deliverability.CAN_DELIVER) {
            this.deliveringManually = true;
            this.canDeliverManually = false;
            int duration = this.agreement.getDeliveryTimeOrDefault();
            double completion = (double)this.progress / (double)duration;
            this.progress = (int)Math.round((double)this.getDeliveryTime() * completion);
        }
    }

    protected int deliver(int batchCount) {
        int deliveredCount = 0;
        for (int i = 0; i < batchCount; ++i) {
            Level level;
            int experience;
            boolean almostExpired;
            if (this.getDeliverability() != Deliverability.CAN_DELIVER) {
                return deliveredCount;
            }
            this.consumePackage();
            this.consumeFromInputSlots(this.agreement.getRequested());
            this.insertCopiesToOutputSlots(this.agreement.getPayment());
            ++deliveredCount;
            assert (this.f_58857_ != null);
            this.agreement.onDeliver();
            this.agreement.toItemStack(this.getAgreementItem());
            this.sendUpdateToNearbyClients();
            if (!this.agreement.isCompleted()) continue;
            boolean bl = almostExpired = this.getAgreement().canExpire() && this.getAgreement().getExpireTimestamp() - this.f_58857_.m_46467_() < 1200L;
            if (almostExpired) {
                this.getAgreementItem().m_41784_().m_128379_("almostExpired", true);
            }
            if ((experience = this.getAgreement().getExperience()) <= 0 || !((level = this.f_58857_) instanceof ServerLevel)) break;
            ServerLevel serverLevel = (ServerLevel)level;
            ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()).m_82520_(0.0, 0.5, 0.0), (int)experience);
            break;
        }
        this.resetProgress();
        return deliveredCount;
    }

    private void consumePackage() {
        if (((Boolean)Config.DELIVERIES_REQUIRE_BOXES.get()).booleanValue()) {
            this.m_7407_(1, 1);
        }
    }

    protected Deliverability getDeliverability() {
        if (this.agreement.isEmpty() || !this.agreement.canDeliver(this.f_58857_ != null ? this.f_58857_.m_46467_() : 0L)) {
            return Deliverability.AGREEMENT_INVALID;
        }
        if (!this.hasPackage()) {
            return Deliverability.NO_PACKAGES;
        }
        if (!this.hasRequestedItems()) {
            return Deliverability.NO_INPUT;
        }
        if (!this.hasSpaceForPayment()) {
            return Deliverability.NO_SPACE_FOR_OUTPUT;
        }
        return Deliverability.CAN_DELIVER;
    }

    protected boolean hasPackage() {
        return !this.m_8020_(1).m_41619_() || (Boolean)Config.DELIVERIES_REQUIRE_BOXES.get() == false;
    }

    protected boolean hasRequestedItems() {
        RequestedItem requestedItem;
        List<RequestedItem> requestedItems = this.agreement.getRequested();
        ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
        for (int slotIndex : INPUT_SLOTS) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(slotIndex);
            if (stackInSlot.m_41619_()) continue;
            inputStacks.add(stackInSlot.m_41777_());
        }
        Object object = requestedItems.iterator();
        while (object.hasNext() && !(requestedItem = (RequestedItem)object.next()).isEmpty()) {
            int requiredCount = requestedItem.getCount();
            for (ItemStack stack : inputStacks) {
                if (!stack.m_41619_() && requestedItem.matches(stack)) {
                    ItemStack split = stack.m_41620_(requiredCount);
                    requiredCount -= split.m_41613_();
                }
                if (requiredCount > 0) continue;
                break;
            }
            if (requiredCount <= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean hasSpaceForPayment() {
        this.outputSpaceCheckContainer.m_6211_();
        int i = 0;
        for (int slotIndex : OUTPUT_SLOTS) {
            this.outputSpaceCheckContainer.m_6836_(i, this.inventory.getStackInSlot(slotIndex).m_41777_());
            ++i;
        }
        Object object = this.getAgreement().getPayment().iterator();
        while (object.hasNext()) {
            ItemStack stack = (ItemStack)object.next();
            if (this.outputSpaceCheckContainer.m_19173_(stack.m_41777_()).m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected void consumeFromInputSlots(List<RequestedItem> requestedItems) {
        for (RequestedItem requestedItem : requestedItems) {
            ItemStack extractedStack;
            int slotIndex;
            int requiredCount = requestedItem.getCount();
            int[] nArray = INPUT_SLOTS;
            int n = nArray.length;
            for (int i = 0; !(i >= n || requestedItem.matches(this.inventory.getStackInSlot(slotIndex = nArray[i])) && (requiredCount -= (extractedStack = this.inventory.extractItem(slotIndex, requiredCount, false)).m_41613_()) <= 0); ++i) {
            }
        }
    }

    protected void insertCopiesToOutputSlots(List<ItemStack> paymentItems) {
        for (ItemStack stack : paymentItems) {
            int slotIndex;
            ItemStack insertedStack = stack.m_41777_();
            int[] nArray = OUTPUT_SLOTS;
            int n = nArray.length;
            for (int i = 0; i < n && !(insertedStack = this.inventory.insertItem(slotIndex = nArray[i], insertedStack, false)).m_41619_(); ++i) {
            }
        }
    }

    public boolean isAgreementLocked() {
        return this.agreementLock.isLocked();
    }

    public boolean shouldVoidAgreementOnBreak() {
        return this.voidAgreementOnBreak;
    }

    @NotNull
    protected ItemStackHandler createInventory(int slots) {
        return new ItemStackHandler(slots){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.m_41720_() instanceof DeliveryAgreementItem;
                }
                if (slot == 1) {
                    return (Boolean)Config.DELIVERIES_REQUIRE_BOXES.get() != false && stack.m_204117_(Wares.Tags.Items.DELIVERY_BOXES);
                }
                return super.isItemValid(slot, stack);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot == 1 && !((Boolean)Config.DELIVERIES_REQUIRE_BOXES.get()).booleanValue()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            protected void onContentsChanged(int slot) {
                if (slot == 0) {
                    DeliveryTableBlockEntity.this.updateBlockStateIfNeeded();
                    DeliveryTableBlockEntity.this.agreement = DeliveryAgreement.fromItemStack(DeliveryTableBlockEntity.this.m_8020_(0)).orElse(DeliveryAgreement.EMPTY);
                    DeliveryTableBlockEntity.this.resetProgress();
                }
                DeliveryTableBlockEntity.this.m_6596_();
            }
        };
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return this.inventoryHandlers[0].cast();
            }
            if (side == Direction.UP) {
                return this.inventoryHandlers[1].cast();
            }
            if (side != null) {
                return this.inventoryHandlers[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack getAgreementItem() {
        return this.m_8020_(0);
    }

    @NotNull
    public ItemStack extractAgreementItem() {
        return this.m_7407_(0, 1);
    }

    public void setAgreementItem(@NotNull ItemStack stack) {
        this.m_6836_(0, stack);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        return this.inventory.extractItem(slot, amount, false);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int @NotNull [] m_7071_(Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> OUTPUT_SLOTS;
            case Direction.UP -> {
                if (((Boolean)Config.DELIVERIES_REQUIRE_BOXES.get()).booleanValue()) {
                    yield AGREEMENT_PLUS_PACKAGES_SLOTS;
                }
                yield AGREEMENT_SLOTS;
            }
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> (Boolean)Config.TABLE_OUTPUTS_FROM_SIDES.get() != false ? INPUT_PLUS_OUTPUT_SLOTS : INPUT_SLOTS;
        };
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack pStack, @NotNull Direction direction) {
        return index >= OUTPUT_SLOTS[0];
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_7013_(int slotIndex, @NotNull ItemStack stack) {
        return slotIndex == 0 && stack.m_41720_() instanceof DeliveryAgreementItem || slotIndex == 1 && stack.m_204117_(Wares.Tags.Items.DELIVERY_BOXES) || slotIndex >= INPUT_SLOTS[0] && slotIndex < OUTPUT_SLOTS[0];
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"block.wares.delivery_table");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new DeliveryTableMenu(containerId, inventory, this, this.containerData);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        this.progress = tag.m_128451_("Progress");
        this.deliveringManually = tag.m_128471_("DeliveringManually");
        this.voidAgreementOnBreak = tag.m_128471_("VoidAgreementOnBreak");
        this.agreement = DeliveryAgreement.fromItemStack(this.getAgreementItem()).orElse(DeliveryAgreement.EMPTY);
        this.agreementLock.load(tag.m_128469_("AgreementLock"));
        if (tag.m_128425_("Owner", 11)) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        this.updateBlockStateIfNeeded();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("DeliveringManually", this.deliveringManually);
        if (this.voidAgreementOnBreak) {
            tag.m_128379_("VoidAgreementOnBreak", true);
        }
        tag.m_128365_("AgreementLock", (Tag)this.agreementLock.save(new CompoundTag()));
        if (!Util.f_137441_.equals(this.ownerUUID)) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
    }

    protected void convertAgreementStackIfNeeded() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.getAgreementItem().m_150930_((Item)Wares.Items.DELIVERY_AGREEMENT.get())) {
            return;
        }
        if (this.getAgreement().isCompleted()) {
            this.setAgreementItem(DeliveryAgreementItem.convertToCompleted(this.getAgreementItem()));
            this.triggerAdvancement(Wares.AdvancementTriggers.AGREEMENT_COMPLETED);
        } else if (this.getAgreement().isExpired(this.f_58857_.m_46467_())) {
            this.setAgreementItem(DeliveryAgreementItem.convertToExpired(this.getAgreementItem()));
            this.triggerAdvancement(Wares.AdvancementTriggers.AGREEMENT_EXPIRED);
        }
    }

    protected void updateBlockStateIfNeeded() {
        AgreementType type = AgreementType.fromItemStack(this.getAgreementItem());
        BlockState currentBlockState = this.m_58900_();
        if (this.f_58857_ != null && currentBlockState.m_61143_(DeliveryTableBlock.AGREEMENT) != type) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)currentBlockState.m_61124_(DeliveryTableBlock.AGREEMENT, (Comparable)((Object)type)));
        }
    }

    protected void sendUpdateToNearbyClients() {
        assert (this.f_58857_ != null);
        List nearbyPlayers = this.f_58857_.m_45976_(ServerPlayer.class, new AABB(this.m_58899_()).m_82400_(32.0));
        for (ServerPlayer player : nearbyPlayers) {
            player.f_8906_.m_9829_(this.m_58483_());
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<IItemHandlerModifiable> inventoryHandler : this.inventoryHandlers) {
            inventoryHandler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.inventoryHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH});
    }

    public boolean trySetOwner(ServerPlayer serverPlayer) {
        if (Util.f_137441_.equals(this.ownerUUID) || ((Boolean)Config.LAST_PLAYER_IS_OWNER.get()).booleanValue()) {
            this.ownerUUID = serverPlayer.m_20148_();
            this.m_6596_();
            return true;
        }
        return false;
    }

    public void triggerAdvancement(DeliveryTableTrigger trigger) {
        Player nearestPlayer;
        if (this.f_58857_ == null) {
            return;
        }
        @Nullable ServerPlayer player = null;
        if (!Util.f_137441_.equals(this.ownerUUID)) {
            @Nullable Player owner = this.f_58857_.m_46003_(this.ownerUUID);
            if (owner instanceof ServerPlayer) {
                ServerPlayer serverPlayer;
                player = serverPlayer = (ServerPlayer)owner;
            }
        } else if (((Boolean)Config.TRIGGER_FOR_NEAREST_PLAYER.get()).booleanValue() && (nearestPlayer = this.f_58857_.m_45941_(TargetingConditions.m_148353_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_())) instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            player = serverPlayer = (ServerPlayer)nearestPlayer;
        }
        if (player != null) {
            trigger.trigger(player, this);
        }
    }

    public void onPlacedBy(LivingEntity placer, ItemStack stack) {
        if (placer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)placer;
            this.trySetOwner(serverPlayer);
        }
    }
}

