/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.client.gui.agreement;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.mpfui.component.HorizontalAlignment;
import io.github.mortuusars.mpfui.component.Rectangle;
import io.github.mortuusars.mpfui.component.TooltipBehavior;
import io.github.mortuusars.mpfui.renderable.TextBlockRenderable;
import io.github.mortuusars.mpfui.renderable.TextureRenderable;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.client.gui.agreement.AgreementLayout;
import io.github.mortuusars.wares.client.gui.agreement.AgreementMenu;
import io.github.mortuusars.wares.client.gui.agreement.element.Seal;
import io.github.mortuusars.wares.client.gui.agreement.renderable.SealRenderable;
import io.github.mortuusars.wares.client.gui.agreement.renderable.StampRenderable;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.menu.ItemDisplaySlot;
import io.github.mortuusars.wares.util.TextUtil;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AgreementScreen
extends AbstractContainerScreen<AgreementMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("wares", "textures/gui/agreement.png");
    private static final ResourceLocation STAMPS_TEXTURE = new ResourceLocation("wares", "textures/gui/stamps.png");
    private static final int FONT_COLOR = -7838649;
    private final Seal seal;
    private Screen parentScreen;
    private int displayItemCycleTimer = 0;

    public AgreementScreen(AgreementMenu menu) {
        super((AbstractContainerMenu)menu, menu.playerInventory, (Component)Component.m_237119_());
        this.f_96541_ = Minecraft.m_91087_();
        this.seal = new Seal(this.getAgreement().getSeal());
    }

    public boolean isOpen() {
        return this.f_96541_ != null && this.f_96541_.f_91080_ == this;
    }

    public void showAsOverlay() {
        if (this.f_96541_ != null) {
            if (!this.isOpen()) {
                this.parentScreen = this.f_96541_.f_91080_;
            }
            this.f_96541_.m_91152_((Screen)this);
            Vec3 pos = ((AgreementMenu)this.f_97732_).player.m_20182_();
            ((AgreementMenu)this.f_97732_).level.m_6263_(((AgreementMenu)this.f_97732_).player, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), SoundSource.MASTER, 1.0f, ((AgreementMenu)this.f_97732_).level.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
    }

    public void m_7379_() {
        if (this.isOpen() && this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parentScreen);
            this.parentScreen = null;
            Vec3 pos = ((AgreementMenu)this.f_97732_).player.m_20182_();
            ((AgreementMenu)this.f_97732_).level.m_6263_(((AgreementMenu)this.f_97732_).player, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), SoundSource.MASTER, 1.0f, ((AgreementMenu)this.f_97732_).level.m_213780_().m_188501_() * 0.1f + 1.2f);
            return;
        }
        super.m_7379_();
    }

    protected DeliveryAgreement getAgreement() {
        return ((AgreementMenu)this.f_97732_).getAgreement();
    }

    protected void m_7856_() {
        Rectangle expiryRect;
        Rectangle orderedRect;
        Rectangle slotsRect;
        Rectangle messageRect;
        this.f_97726_ = ((AgreementMenu)this.f_97732_).getUIWidth();
        this.f_97727_ = ((AgreementMenu)this.f_97732_).getUIHeight();
        super.m_7856_();
        this.f_97731_ = -1000;
        this.f_97729_ = -1000;
        AgreementLayout layout = ((AgreementMenu)this.f_97732_).getLayout().offset(this.getGuiLeft(), this.getGuiTop() + ((AgreementMenu)this.f_97732_).posYOffset);
        Rectangle titleRect = layout.getElement(AgreementLayout.Element.TITLE);
        if (titleRect != null) {
            this.m_169394_((Widget)new TextBlockRenderable((Component)((AgreementMenu)this.f_97732_).getTitle(), titleRect.left(), titleRect.top(), titleRect.width(), titleRect.height()).setAlignment(HorizontalAlignment.CENTER).setDefaultColor(-7838649));
        }
        if ((messageRect = layout.getElement(AgreementLayout.Element.MESSAGE)) != null) {
            this.m_169394_((Widget)new TextBlockRenderable((Component)((AgreementMenu)this.f_97732_).getMessage(), messageRect.left(), messageRect.top(), messageRect.width(), messageRect.height()).setAlignment(HorizontalAlignment.CENTER).setDefaultColor(-7838649));
        }
        if ((slotsRect = layout.getElement(AgreementLayout.Element.SLOTS)) != null) {
            this.m_169394_((Widget)new TextureRenderable(slotsRect.centerX() - 9, slotsRect.centerY() - 6, 19, 11, 200, 20, 0, TEXTURE));
        }
        if ((orderedRect = layout.getElement(AgreementLayout.Element.ORDERED)) != null) {
            String text = this.getAgreement().isInfinite() ? "\u221e" : TextUtil.shortenNumber(this.getAgreement().getDelivered()) + " / " + TextUtil.shortenNumber(this.getAgreement().getOrdered());
            this.m_169394_((Widget)((TextBlockRenderable)((Object)new TextBlockRenderable(() -> Component.m_237113_((String)text), orderedRect.left(), orderedRect.top(), orderedRect.width(), orderedRect.height()).setDefaultColor(-7838649).setTooltip(() -> {
                if (this.getAgreement().isInfinite()) {
                    return Component.m_237115_((String)"gui.wares.agreement.infinite.tooltip");
                }
                int delivered = this.getAgreement().getDelivered();
                int ordered = this.getAgreement().getOrdered();
                if (delivered >= 1000 || ordered >= 1000) {
                    return Component.m_237110_((String)"gui.wares.agreement.deliveries.tooltip", (Object[])new Object[]{delivered, ordered});
                }
                return Component.m_237119_();
            }))).setTooltipBehavior(TooltipBehavior.REGULAR_ONLY).setAlignment(HorizontalAlignment.CENTER));
        }
        if ((expiryRect = layout.getElement(AgreementLayout.Element.EXPIRY)) != null) {
            ((TextBlockRenderable)this.m_169394_((Widget)((TextBlockRenderable)((Object)new TextBlockRenderable(() -> TextUtil.timeFromTicks(this.getAgreement().getExpireTimestamp() - ((AgreementMenu)this.f_97732_).level.m_46467_()), expiryRect.left(), expiryRect.top(), expiryRect.width(), expiryRect.height()).setAlignment(HorizontalAlignment.CENTER).setTooltip((Component)Component.m_237115_((String)"gui.wares.agreement.expire_time")))))).setTooltipBehavior(TooltipBehavior.REGULAR_ONLY).setDefaultColor(11350578).visibility((renderable, poseStack, mouseX, mouseY) -> !this.getAgreement().isCompleted() && this.getAgreement().getExpireTimestamp() - ((AgreementMenu)this.f_97732_).level.m_46467_() > 0L);
        }
        ((TextureRenderable)this.m_169394_((Widget)((TextureRenderable)((Object)new StampRenderable(this.getGuiLeft() + 12, this.getGuiTop() + 10, 71, 23, 1, 1, STAMPS_TEXTURE).setTooltip((Component)Component.m_237115_((String)"gui.wares.agreement.completed.tooltip")))))).setOpacity(0.75f).visibility((renderable, poseStack, mouseX, mouseY) -> this.getAgreement().isCompleted());
        ((TextureRenderable)this.m_169394_((Widget)((TextureRenderable)((Object)new StampRenderable(this.getGuiLeft() + 12, this.getGuiTop() + 10, 71, 23, 1, 27, STAMPS_TEXTURE).setTooltip((Component)Component.m_237115_((String)"gui.wares.agreement.expired.tooltip")))))).setOpacity(0.75f).visibility((renderable, poseStack, mouseX, mouseY) -> !this.getAgreement().isCompleted() && this.getAgreement().isExpired(((AgreementMenu)this.f_97732_).level.m_46467_()));
        MutableComponent buyerInfoTooltip = Component.m_237113_((String)"");
        if (!this.getAgreement().getBuyerName().equals(Component.m_237119_())) {
            buyerInfoTooltip.m_7220_(this.getAgreement().getBuyerName());
        }
        if (!this.getAgreement().getBuyerAddress().equals(Component.m_237119_())) {
            if (!this.getAgreement().getBuyerName().equals(Component.m_237119_())) {
                buyerInfoTooltip.m_130946_("\n");
            }
            buyerInfoTooltip.m_7220_(this.getAgreement().getBuyerAddress());
        }
        SealRenderable sealRenderable = new SealRenderable(this.getGuiLeft() + this.f_97726_ / 2 - 24, this.getGuiTop() + this.f_97727_ - 42, this.seal, 28);
        if (this.f_96547_.m_92852_((FormattedText)buyerInfoTooltip) > 0) {
            sealRenderable.setTooltip((Component)buyerInfoTooltip);
        }
        this.m_169394_((Widget)sealRenderable);
    }

    public void m_7286_(@NotNull PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (((AgreementMenu)this.f_97732_).isShort) {
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, 111);
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + 111, 0, 155, this.f_97726_, 101);
        } else {
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        }
        for (Slot slot : ((AgreementMenu)this.f_97732_).f_38839_) {
            this.m_93228_(poseStack, this.getGuiLeft() + slot.f_40220_ - 1, this.getGuiTop() + slot.f_40221_ - 1, 201, 1, 18, 18);
        }
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7025_(@NotNull PoseStack poseStack, int x, int y) {
        if (((AgreementMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            ItemDisplaySlot itemDisplaySlot;
            Component additionalTooltip;
            ItemStack stack = this.f_97734_.m_7993_();
            ArrayList<Component> itemTooltip = this.m_96555_(stack);
            Optional imageTooltip = stack.m_150921_();
            Slot slot = this.f_97734_;
            if (slot instanceof ItemDisplaySlot && !(additionalTooltip = (itemDisplaySlot = (ItemDisplaySlot)slot).getAdditionalTooltip()).getString().isEmpty()) {
                itemTooltip = new ArrayList<Component>(itemTooltip);
                itemTooltip.add(additionalTooltip);
            }
            this.m_169388_(poseStack, itemTooltip, imageTooltip, x, y);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (((Boolean)Config.AGREEMENT_CLOSE_WITH_RMB.get()).booleanValue() && pButton == 1) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_6597_(@NotNull Slot pSlot, int pSlotId, int pMouseButton, @NotNull ClickType pType) {
    }

    protected void m_181908_() {
        super.m_181908_();
        ++this.displayItemCycleTimer;
        if (this.displayItemCycleTimer % 20 == 1) {
            this.cycleDisplayItems(false);
        }
    }

    protected void cycleDisplayItems(boolean backwards) {
        for (Slot slot : ((AgreementMenu)this.f_97732_).f_38839_) {
            if (!(slot instanceof ItemDisplaySlot)) continue;
            ItemDisplaySlot itemDisplaySlot = (ItemDisplaySlot)slot;
            itemDisplaySlot.cycleItem(backwards);
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        boolean handled = super.m_6050_(pMouseX, pMouseY, pDelta);
        if (!handled) {
            this.cycleDisplayItems(pDelta > 0.0);
            this.displayItemCycleTimer = 1;
        }
        return handled;
    }
}

