/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.wares.Wares;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record Package(Either<ResourceLocation, List<ItemStack>> items, String sender) {
    public static final Codec<Package> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)ResourceLocation.f_135803_, (Codec)Codec.list((Codec)ItemStack.f_41582_)).optionalFieldOf("packedItems", (Object)Either.right(List.of(ItemStack.f_41583_))).forGetter(Package::items), (App)Codec.STRING.optionalFieldOf("sender", (Object)"").forGetter(Package::sender)).apply((Applicative)instance, Package::new));
    public static final ResourceLocation DEFAULT_LOOT_TABLE = Wares.resource("gameplay/empty_package");
    public static final Package DEFAULT = new Package((Either<ResourceLocation, List<ItemStack>>)Either.left((Object)DEFAULT_LOOT_TABLE));

    public Package(Either<ResourceLocation, List<ItemStack>> items) {
        this(items, "");
    }

    public CompoundTag toTag(CompoundTag tag) {
        CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).ifPresent(resultTag -> tag.m_128391_((CompoundTag)resultTag));
        return tag;
    }

    public void toItemStack(ItemStack stack) {
        this.toTag(stack.m_41784_());
    }

    public static Optional<Package> fromTag(@NotNull CompoundTag tag) {
        if (!tag.m_128441_("packedItems") && tag.m_128425_("BlockEntityTag", 10)) {
            tag = tag.m_128469_("BlockEntityTag");
        }
        return CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(arg_0 -> ((Logger)Wares.LOGGER).error(arg_0)).map(Pair::getFirst);
    }

    public static Optional<Package> fromItemStack(ItemStack stack) {
        return stack.m_41783_() != null ? Package.fromTag(stack.m_41783_()) : Optional.empty();
    }

    public List<ItemStack> getItems(ServerLevel level, Vec3 position) {
        return (List)this.items.map(lootTable -> Package.fromLootTable(level, position, lootTable), itemsList -> Package.fromItemsList(level, position, itemsList));
    }

    public static List<ItemStack> getDefaultItems(ServerLevel level, Vec3 position) {
        return Package.unpackLootTable(level, position, DEFAULT_LOOT_TABLE);
    }

    private static List<ItemStack> fromLootTable(ServerLevel level, Vec3 position, ResourceLocation table) {
        List<ItemStack> items = Package.unpackLootTable(level, position, table);
        return items.size() == 0 ? Package.getDefaultItems(level, position) : items;
    }

    private static List<ItemStack> fromItemsList(ServerLevel level, Vec3 position, List<ItemStack> stacks) {
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>(stacks.stream().filter(itemStack -> !itemStack.m_41619_()).toList());
        return nonEmptyStacks.size() == 0 ? Package.getDefaultItems(level, position) : nonEmptyStacks;
    }

    private static List<ItemStack> unpackLootTable(ServerLevel level, Vec3 position, ResourceLocation tableLocation) {
        LootTable lootTable = level.m_7654_().m_129898_().m_79217_(tableLocation);
        LootContext.Builder lootContextBuilder = new LootContext.Builder(level);
        lootContextBuilder.m_78972_(LootContextParams.f_81460_, (Object)position);
        return lootTable.m_230922_(lootContextBuilder.m_78975_(LootContextParamSets.f_81411_));
    }
}

