/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.generation.provider;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.CardboardBoxBlock;
import io.github.mortuusars.wares.data.agreement.SealedDeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.SteppedInt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LootTables
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;

    public LootTables(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) {
        this.dropsSelf(cache, (BlockItem)Wares.Items.DELIVERY_TABLE.get());
        this.writeTable(cache, Wares.resource("gameplay/empty_package"), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_))).m_79167_());
        CardboardBoxBlock cardboardBoxBlock = (CardboardBoxBlock)((Object)Wares.Blocks.CARDBOARD_BOX.get());
        this.writeTable(cache, Wares.resource("blocks/" + Wares.Blocks.CARDBOARD_BOX.getId().m_135815_()), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)cardboardBoxBlock).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)cardboardBoxBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CardboardBoxBlock.BOXES, 2)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)cardboardBoxBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CardboardBoxBlock.BOXES, 3)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)cardboardBoxBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CardboardBoxBlock.BOXES, 4)))))).m_79167_());
        for (Pair<ResourceLocation, LootTable> locAndTable : this.villageTables()) {
            this.writeTable(cache, (ResourceLocation)locAndTable.getFirst(), (LootTable)locAndTable.getSecond());
        }
        LootPoolSingletonContainer.Builder[] dyes = new LootPoolSingletonContainer.Builder[DyeColor.values().length];
        for (DyeColor value : DyeColor.values()) {
            dyes[value.ordinal()] = this.item((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:" + value + "_dye")), 2, 12);
        }
        this.writeTable(cache, Wares.resource("agreement/wandering_trader/dyes"), this.agreementItems(dyes));
        this.writeTable(cache, Wares.resource("agreement/wandering_trader/regular_price"), this.agreementItems(this.item((ItemLike)Items.f_42616_, 4, 12)));
        this.writeTable(cache, Wares.resource("agreement/wandering_trader/regular_ware"), this.agreementItems(this.item((ItemLike)Items.f_42401_, 8, 16), this.item((ItemLike)Items.f_42403_, 8, 16), this.item((ItemLike)Items.f_42688_, 4, 16), this.item((ItemLike)Items.f_41996_, 3, 10), LootTableReference.m_79776_((ResourceLocation)Wares.resource("agreement/wandering_trader/dyes"))));
        this.writeTable(cache, Wares.resource("agreement/wandering_trader/rare_price"), this.agreementItems(this.item((ItemLike)Items.f_42616_, 10, 20)));
        this.writeTable(cache, Wares.resource("agreement/wandering_trader/rare_ware"), this.agreementItems(this.item((ItemLike)Items.f_42436_, 2, 6), this.item((ItemLike)Items.f_42677_, 2, 6), this.item((ItemLike)Items.f_42534_, 4, 16), this.item((ItemLike)Items.f_151049_, 2, 8)));
    }

    public List<Pair<ResourceLocation, LootTable>> villageTables() {
        ArrayList<Pair<ResourceLocation, LootTable>> list = new ArrayList<Pair<ResourceLocation, LootTable>>();
        list.addAll(this.plains());
        list.addAll(this.taiga());
        list.addAll(this.desert());
        list.addAll(this.savanna());
        list.addAll(this.snowy());
        return list;
    }

    private List<Pair<ResourceLocation, LootTable>> plains() {
        ArrayList<Pair<ResourceLocation, LootTable>> list = new ArrayList<Pair<ResourceLocation, LootTable>>();
        String type = "plains";
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 8, 14), this.item((ItemLike)Items.f_42620_, 8, 14), this.item((ItemLike)Items.f_42454_, 4, 10), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42579_, 2, 6), this.item((ItemLike)Items.f_42485_, 2, 6), this.item((ItemLike)Items.f_42581_, 2, 6), this.item((ItemLike)Items.f_42406_, 3, 6))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 6, 14), this.item((ItemLike)Items.f_42620_, 6, 14), this.item((ItemLike)Items.f_42454_, 4, 10), this.item((ItemLike)Items.f_42516_, 8, 16), this.item((ItemLike)Items.f_42579_, 2, 6), this.item((ItemLike)Items.f_42485_, 2, 6), this.item((ItemLike)Items.f_42581_, 2, 6), this.item((ItemLike)Items.f_42406_, 3, 6), this.item((ItemLike)Items.f_41939_, 6, 10), this.item((ItemLike)Items.f_42206_, 5, 10))));
        list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
        list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42620_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42619_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42454_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42485_, 4, 10).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42579_, 4, 10).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42658_, 4, 10).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42206_, 4, 10).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42210_, 4, 10).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2))).m_79167_()));
        return list;
    }

    private List<Pair<ResourceLocation, LootTable>> taiga() {
        ArrayList<Pair<ResourceLocation, LootTable>> list = new ArrayList<Pair<ResourceLocation, LootTable>>();
        String type = "taiga";
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42046_, 4, 12), this.item((ItemLike)Items.f_42780_, 10, 16), this.item((ItemLike)Items.f_42454_, 4, 10), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42800_, 6, 16), this.item((ItemLike)Items.f_41838_, 4, 12), this.item((ItemLike)Items.f_42620_, 10, 18), this.item((ItemLike)Items.f_42406_, 3, 6), this.item((ItemLike)Items.f_41953_, 8, 14), this.item((ItemLike)Items.f_41952_, 8, 14))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42046_, 6, 14).m_79707_(10), this.item((ItemLike)Items.f_42620_, 6, 14).m_79707_(10), this.item((ItemLike)Items.f_42454_, 4, 10).m_79707_(10), this.item((ItemLike)Items.f_42516_, 8, 16).m_79707_(10), this.item((ItemLike)Items.f_42800_, 16, 24).m_79707_(10), this.item((ItemLike)Items.f_41838_, 14, 24).m_79707_(10), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10), this.item((ItemLike)Items.f_41998_, 12, 24).m_79707_(4), this.item((ItemLike)Items.f_42435_, 12, 24).m_79707_(4), this.item((ItemLike)Items.f_41953_, 8, 14).m_79707_(4), this.item((ItemLike)Items.f_41952_, 8, 14).m_79707_(4))));
        list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
        list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42780_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42046_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42620_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42454_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41838_, 16, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42800_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41865_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42211_, 8, 18).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2))).m_79167_()));
        return list;
    }

    private List<Pair<ResourceLocation, LootTable>> desert() {
        ArrayList<Pair<ResourceLocation, LootTable>> list = new ArrayList<Pair<ResourceLocation, LootTable>>();
        String type = "desert";
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 6, 16), this.item((ItemLike)Items.f_41982_, 4, 12), this.item((ItemLike)Items.f_42496_, 8, 16), this.item((ItemLike)Items.f_42461_, 8, 14), this.item((ItemLike)Items.f_41856_, 10, 16), this.item((ItemLike)Items.f_42252_, 10, 16), this.item((ItemLike)Items.f_42199_, 10, 16), this.item((ItemLike)Items.f_42126_, 10, 16), this.item((ItemLike)Items.f_42163_, 10, 16), this.item((ItemLike)Items.f_42649_, 4, 10), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42406_, 3, 6))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_41982_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_42649_, 4, 10).m_79707_(10), this.item((ItemLike)Items.f_42516_, 8, 16).m_79707_(10), this.item((ItemLike)Items.f_42461_, 8, 14).m_79707_(8), this.item((ItemLike)Items.f_41866_, 8, 16).m_79707_(6), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10))));
        list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
        list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41982_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42461_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_, 6, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42649_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41866_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42245_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42241_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42244_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42230_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42648_, 2, 6).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2))).m_79167_()));
        return list;
    }

    private List<Pair<ResourceLocation, LootTable>> savanna() {
        ArrayList<Pair<ResourceLocation, LootTable>> list = new ArrayList<Pair<ResourceLocation, LootTable>>();
        String type = "savanna";
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42619_, 6, 16), this.item((ItemLike)Items.f_42732_, 6, 16), this.item((ItemLike)Items.f_42587_, 8, 14), this.item((ItemLike)Items.f_42252_, 10, 16), this.item((ItemLike)Items.f_41841_, 10, 16), this.item((ItemLike)Items.f_41827_, 10, 16), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42406_, 3, 6))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42619_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_42732_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_42417_, 2, 6).m_79707_(10), this.item((ItemLike)Items.f_42516_, 8, 16).m_79707_(10), this.item((ItemLike)Items.f_41827_, 8, 14).m_79707_(8), this.item((ItemLike)Items.f_41841_, 8, 16).m_79707_(6), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10))));
        list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
        list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42619_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42732_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_, 6, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41866_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42658_, 6, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42029_, 6, 12).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42777_, 1, 3).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2))).m_79167_()));
        return list;
    }

    private List<Pair<ResourceLocation, LootTable>> snowy() {
        ArrayList<Pair<ResourceLocation, LootTable>> list = new ArrayList<Pair<ResourceLocation, LootTable>>();
        String type = "snowy";
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42620_, 6, 16), this.item((ItemLike)Items.f_42778_, 3, 8), this.item((ItemLike)Items.f_42413_, 8, 16), this.item((ItemLike)Items.f_41846_, 8, 14), this.item((ItemLike)Items.f_42700_, 10, 16), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42406_, 3, 6))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
        list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42620_, 3, 8).m_79707_(10), this.item((ItemLike)Items.f_41981_, 8, 14).m_79707_(10), this.item((ItemLike)Items.f_41980_, 8, 14).m_79707_(10), this.item((ItemLike)Items.f_42363_, 6, 12).m_79707_(10), this.item((ItemLike)Items.f_42452_, 14, 24).m_79707_(10), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10))));
        list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
        list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42620_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41981_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41980_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42363_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41846_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42777_, 1, 3).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2))).m_79167_()));
        return list;
    }

    @NotNull
    private LootTable chestLootTableWithAgreement(String type) {
        SealedDeliveryAgreement agreementSell = new SealedDeliveryAgreement.Builder().requested(Wares.resource("agreement/village/" + type + "_requested_sell")).payment(Wares.resource("agreement/village/" + type + "_payment_sell")).ordered(new SteppedInt(64, 256, 8)).experience(new SteppedInt(12, 32, 4)).build();
        ItemStack sealedStackSell = new ItemStack((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get());
        agreementSell.toItemStack(sealedStackSell);
        SealedDeliveryAgreement agreementBuy = new SealedDeliveryAgreement.Builder().requested(Wares.resource("agreement/village/" + type + "_requested_buy")).payment(Wares.resource("agreement/village/" + type + "_payment_buy")).ordered(new SteppedInt(64, 256, 8)).experience(new SteppedInt(12, 32, 4)).build();
        ItemStack sealedStackBuy = new ItemStack((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get());
        agreementBuy.toItemStack(sealedStackBuy);
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 1, 3).m_79707_(10))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)6.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Wares.Items.CARDBOARD_BOX.get(), 1, 1).m_79707_(8))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)sealedStackSell.m_41784_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)sealedStackBuy.m_41784_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_())).m_79167_();
    }

    private LootTable agreementItems(LootPoolSingletonContainer.Builder<?> ... items) {
        Preconditions.checkArgument((items.length > 0 ? 1 : 0) != 0, (Object)"No items were provided.");
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        for (LootPoolSingletonContainer.Builder<?> item : items) {
            pool.m_79076_(item);
        }
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(pool).m_79167_();
    }

    public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int count) {
        return this.item(item, count, count);
    }

    public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int min, int max) {
        LootPoolSingletonContainer.Builder itemBuilder = LootItem.m_79579_((ItemLike)item);
        if (min == max) {
            itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
        } else {
            itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }
        return itemBuilder;
    }

    private void dropsSelf(CachedOutput cache, BlockItem blockItem) {
        this.writeTable(cache, Wares.resource("blocks/" + ForgeRegistries.ITEMS.getKey((Object)blockItem).m_135815_()), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)blockItem))).m_79167_());
    }

    protected LootTable.Builder silkTouchTable(Item lootItem) {
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)lootItem).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))))));
    }

    protected LootTable.Builder silkTouchOrDefaultTable(Block block, Item lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.m_79043_().name(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(builder);
    }

    private void writeTable(CachedOutput cache, ResourceLocation location, LootTable lootTable) {
        Path outputFolder = this.generator.m_123916_();
        Path path = outputFolder.resolve("data/" + location.m_135827_() + "/loot_tables/" + location.m_135815_() + ".json");
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)net.minecraft.world.level.storage.loot.LootTables.m_79200_((LootTable)lootTable), (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't write loot lootTable {}", (Object)path, (Object)e);
        }
    }
}

