/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.item;

import com.mojang.datafixers.util.Either;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.client.gui.agreement.AgreementGUI;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.util.ClientHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeliveryAgreementItem
extends Item {
    public DeliveryAgreementItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        this.getAgreementFromStack(stack).ifLeft(agreement -> tooltipComponents.add((Component)Component.m_237115_((String)"item.wares.agreement.view.tooltip").m_130948_(Style.f_131099_.m_178520_(14071177))));
    }

    public boolean m_142305_(ItemStack agreementStack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess slotAccess) {
        Optional optionalAgreement;
        if (agreementStack.m_41720_() == this && otherStack.m_41619_() && action == ClickAction.SECONDARY && (optionalAgreement = this.getAgreementFromStack(agreementStack).left()).isPresent()) {
            DeliveryAgreement agreement = (DeliveryAgreement)optionalAgreement.get();
            if (agreementStack.m_150930_((Item)Wares.Items.DELIVERY_AGREEMENT.get())) {
                if (agreement.isCompleted()) {
                    slot.m_5852_(DeliveryAgreementItem.convertToCompleted(agreementStack));
                } else if (agreement.isExpired(player.f_19853_.m_46467_())) {
                    slot.m_5852_(DeliveryAgreementItem.convertToExpired(agreementStack));
                }
            }
            if (player.m_9236_().f_46443_) {
                Supplier<DeliveryAgreement> agreementSupplier = ClientHelper.isViewingInDeliveryTableScreen(agreementStack) ? ClientHelper.getDeliveryTableAgreementSupplier(agreement) : () -> agreement;
                AgreementGUI.showAsOverlay(player, agreementSupplier);
            }
            return true;
        }
        return super.m_142305_(agreementStack, otherStack, slot, action, player, slotAccess);
    }

    public void m_6883_(ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (stack.m_150930_((Item)Wares.Items.DELIVERY_AGREEMENT.get()) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (stack.m_41782_()) {
                long expireTime;
                boolean isExpired = false;
                CompoundTag tag = stack.m_41783_();
                if (tag.m_128441_("expireTime") && (expireTime = tag.m_128454_("expireTime")) >= 0L && expireTime <= level.m_46467_()) {
                    ItemStack expiredStack = DeliveryAgreementItem.convertToExpired(stack);
                    serverPlayer.m_150109_().m_6836_(slotId, expiredStack);
                    isExpired = true;
                }
                if (!isExpired && tag.m_128441_("ordered") && tag.m_128441_("remaining")) {
                    int ordered = tag.m_128451_("ordered");
                    int remaining = tag.m_128451_("remaining");
                    if (ordered > 0 && remaining <= 0) {
                        ItemStack completedStack = DeliveryAgreementItem.convertToCompleted(stack);
                        serverPlayer.m_150109_().m_6836_(slotId, completedStack);
                    }
                }
            }
        }
    }

    @NotNull
    public static ItemStack convertToExpired(ItemStack stack) {
        DeliveryAgreement agreement;
        if (stack.m_41619_()) {
            throw new IllegalStateException("Tried to convert an empty ItemStack to Expired Delivery Agreement.");
        }
        if (stack.m_150930_((Item)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get())) {
            throw new IllegalStateException("Tried to convert Completed Delivery Agreement to Expired Delivery Agreement. Stack: '" + stack + ".");
        }
        if (stack.m_150930_((Item)Wares.Items.EXPIRED_DELIVERY_AGREEMENT.get())) {
            return stack;
        }
        ItemStack expiredStack = new ItemStack((ItemLike)Wares.Items.EXPIRED_DELIVERY_AGREEMENT.get());
        @Nullable CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null) {
            expiredStack.m_41751_(stackTag);
        }
        if ((agreement = DeliveryAgreement.fromItemStack(stack).orElse(DeliveryAgreement.EMPTY)) != DeliveryAgreement.EMPTY) {
            agreement.expire();
            agreement.toItemStack(expiredStack);
        }
        return expiredStack;
    }

    @NotNull
    public static ItemStack convertToCompleted(ItemStack stack) {
        DeliveryAgreement agreement;
        if (stack.m_41619_()) {
            throw new IllegalStateException("Tried to convert an empty ItemStack to Completed Delivery Agreement.");
        }
        if (stack.m_150930_((Item)Wares.Items.EXPIRED_DELIVERY_AGREEMENT.get())) {
            throw new IllegalStateException("Tried to convert Expired Delivery Agreement to Completed Delivery Agreement. Stack: '" + stack + ".");
        }
        if (stack.m_150930_((Item)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get())) {
            return stack;
        }
        ItemStack completedStack = new ItemStack((ItemLike)Wares.Items.COMPLETED_DELIVERY_AGREEMENT.get());
        @Nullable CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null) {
            completedStack.m_41751_(stackTag);
        }
        if ((agreement = DeliveryAgreement.fromItemStack(stack).orElse(DeliveryAgreement.EMPTY)) != DeliveryAgreement.EMPTY) {
            agreement.complete();
            agreement.toItemStack(completedStack);
        }
        return completedStack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack usedItemStack = player.m_21120_(hand);
        if (level.f_46443_) {
            Either<DeliveryAgreement, AgreementError> agreementOrError = this.getAgreementFromStack(usedItemStack);
            agreementOrError.ifLeft(deliveryAgreement -> AgreementGUI.showAsOverlay(player, () -> deliveryAgreement)).ifRight(error -> {
                String userErrorKey;
                Object loggerError = switch (error) {
                    case AgreementError.NO_TAG -> {
                        userErrorKey = "item.wares.delivery_agreement.no_data.message";
                        yield usedItemStack + " does not have any Agreement data. Delivery Agreements must be created with specific nbt tags to work. Refer to the mod's Wiki page for configuration instructions.";
                    }
                    case AgreementError.EMPTY -> {
                        userErrorKey = "item.wares.delivery_agreement.empty.message";
                        yield "Cannot read Delivery Agreement from stack nbt OR Agreement is empty. There's probably something wrong with the agreement definition. Refer to the Wiki for instructions and double check that everything is entered and formatted correctly.";
                    }
                    default -> {
                        userErrorKey = "item.wares.delivery_agreement.damaged.message";
                        yield "Cannot read Delivery Agreement from stack nbt OR Agreement is empty. There's probably something wrong with the agreement definition. Refer to the Wiki for instructions and double check that everything is entered and formatted correctly.";
                    }
                };
                player.m_5661_((Component)Component.m_237115_((String)userErrorKey).m_130940_(ChatFormatting.RED), true);
                Wares.LOGGER.warn((String)loggerError);
                player.m_5496_((SoundEvent)Wares.SoundEvents.PAPER_CRACKLE.get(), 0.8f, 0.65f);
            });
        }
        return InteractionResultHolder.m_19092_((Object)usedItemStack, (boolean)level.f_46443_);
    }

    public Either<DeliveryAgreement, AgreementError> getAgreementFromStack(ItemStack stack) {
        if (stack.m_41783_() == null || stack.m_41783_().m_128456_()) {
            return Either.right((Object)((Object)AgreementError.NO_TAG));
        }
        Optional<DeliveryAgreement> optionalAgreement = DeliveryAgreement.fromItemStack(stack);
        if (optionalAgreement.isEmpty()) {
            return Either.right((Object)((Object)AgreementError.DAMAGED));
        }
        DeliveryAgreement agreement = optionalAgreement.get();
        if (agreement.isEmpty()) {
            return Either.right((Object)((Object)AgreementError.EMPTY));
        }
        return Either.left((Object)agreement);
    }

    public static enum AgreementError {
        NO_TAG,
        EMPTY,
        DAMAGED;

    }
}

