/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.item;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.entity.PackageBlockEntity;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.data.Package;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageItem
extends BlockItem {
    public PackageItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (level != null && level.f_46443_) {
            Package.fromItemStack(stack).ifPresent(pkg -> {
                String sender = pkg.sender();
                if (!sender.isEmpty()) {
                    tooltip.add((Component)Component.m_237115_((String)"item.wares.package.sender.tooltip").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)sender).m_130940_(ChatFormatting.WHITE)));
                }
                if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
                    pkg.items().ifLeft(lootTable -> tooltip.add((Component)Component.m_237115_((String)"item.wares.package.loot_table.tooltip").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)lootTable.toString()))));
                }
            });
        }
    }

    @NotNull
    public SoundEvent m_6061_() {
        return (SoundEvent)Wares.SoundEvents.PAPER_TEAR.get();
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 30;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.EAT;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        if (!((Boolean)Config.PACKAGE_PLACING_REQUIRES_SNEAK.get()).booleanValue()) {
            return super.m_6225_(context);
        }
        if (!context.m_7078_()) {
            Objects.requireNonNull(context.m_43723_()).m_6672_(context.m_43724_());
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        return super.m_6225_(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack usedStack = player.m_21120_(hand);
        if (!(usedStack.m_41720_() instanceof PackageItem)) {
            return InteractionResultHolder.m_19098_((Object)usedStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)usedStack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Package pack = Package.fromItemStack(stack).orElse(Package.DEFAULT);
            Vec3 pos = livingEntity.m_20182_();
            for (ItemStack itemStack : pack.getItems(serverLevel, livingEntity.m_20182_())) {
                Containers.m_18992_((Level)level, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ItemStack)itemStack);
            }
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)Wares.SoundEvents.CARDBOARD_HIT.get(), SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() * 0.2f + 0.9f);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                serverPlayer.m_36220_(Wares.Stats.PACKAGES_OPENED);
            }
        }
        if (level.f_46443_) {
            Minecraft.m_91087_().f_91066_.f_92095_.m_7249_(false);
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_7274_(@NotNull BlockPos pos, Level level, @Nullable Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity packageBlockEntity = (PackageBlockEntity)blockEntity;
            packageBlockEntity.setPackage(Package.fromItemStack(stack).orElse(Package.DEFAULT));
        }
        return super.m_7274_(pos, level, player, stack, state);
    }
}

