/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.test.data.agreement;

import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.test.framework.ITestClass;
import io.github.mortuusars.wares.test.framework.Test;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AgreementTest
implements ITestClass {
    @Override
    public List<Test> collect() {
        return List.of(new Test("DefaultAgreementIsNotExpired", player -> {
            DeliveryAgreement agreement = DeliveryAgreement.builder().title((Component)Component.m_237113_((String)"Title Test")).addRequestedItem(RequestedItem.EMPTY).build();
            this.assertThat(!agreement.isExpired(player.f_19853_.m_46467_()), "Expired when shouldn't.");
        }), new Test("DefaultAgreementIsNotCompleted", player -> {
            DeliveryAgreement agreement = DeliveryAgreement.builder().title((Component)Component.m_237113_((String)"Title Test")).addRequestedItem(RequestedItem.EMPTY).build();
            this.assertThat(!agreement.isCompleted(), "Completed when shouldn't.");
        }), new Test("ExpiredAgreementShouldBeExpired", player -> {
            DeliveryAgreement expiredAgreement = DeliveryAgreement.builder().addRequestedItem(RequestedItem.EMPTY).expireTime(player.f_19853_.m_46467_() - 5L).build();
            this.assertThat(expiredAgreement.isExpired(player.f_19853_.m_46467_()), "Not expired when it should.");
        }), new Test("ExpireMethodExpiresAgreement", player -> {
            DeliveryAgreement expiredAgreement = DeliveryAgreement.builder().addRequestedItem(RequestedItem.EMPTY).build();
            expiredAgreement.expire();
            this.assertThat(expiredAgreement.isExpired(player.f_19853_.m_46467_()), "Not expired when it should.");
        }), new Test("OnDeliverCompletedAgreementOnLast", player -> {
            DeliveryAgreement completed = DeliveryAgreement.builder().addRequestedItem(RequestedItem.EMPTY).ordered(10).delivered(9).build();
            completed.onDeliver();
            this.assertThat(completed.isCompleted(), "Not completed when it should.");
        }), new Test("OnDeliverCompletesAgreementAfterRequiredNumberOfTimes", player -> {
            DeliveryAgreement completed = DeliveryAgreement.builder().addRequestedItem(RequestedItem.EMPTY).ordered(10).delivered(5).build();
            for (int i = 0; i < 5; ++i) {
                this.assertThat(!completed.isCompleted(), "Completed when it shouldn't.");
                completed.onDeliver();
            }
            this.assertThat(completed.isCompleted(), "Not completed when it should.");
        }), new Test("CompleteMethodCompletesAgreement", player -> {
            DeliveryAgreement completed = DeliveryAgreement.builder().addRequestedItem(RequestedItem.EMPTY).build();
            completed.complete();
            this.assertThat(completed.isCompleted(), "Not completed when it should.");
        }), new Test("AgreementCodecEncodesAndDecodesCorrectly", player -> {
            DeliveryAgreement agreement = DeliveryAgreement.builder().id("1").buyerName((Component)Component.m_237113_((String)"Buyer")).addRequestedItem(new RequestedItem(Items.f_42674_, 1)).addPaymentItem(new ItemStack((ItemLike)Items.f_42616_)).ordered(99).delivered(1).experience(10).expireTime(10000L).build();
            ItemStack agreementStack = new ItemStack((ItemLike)Wares.Items.DELIVERY_AGREEMENT.get());
            agreement.toItemStack(agreementStack);
            Optional<DeliveryAgreement> decoded = DeliveryAgreement.fromItemStack(agreementStack);
            this.assertThat(decoded.isPresent(), "Decoding failed and returned Empty.");
            DeliveryAgreement decodedAgreement = decoded.get();
            Object[] decodedReq = (RequestedItem[])decodedAgreement.getRequested().toArray(RequestedItem[]::new);
            Arrays.sort(decodedReq);
            Object[] agreementReq = (RequestedItem[])agreement.getRequested().toArray(RequestedItem[]::new);
            Arrays.sort(agreementReq);
            Object[] decodedPay = (ItemStack[])decodedAgreement.getPayment().toArray(ItemStack[]::new);
            Arrays.sort(decodedPay);
            Object[] agreementPay = (ItemStack[])agreement.getPayment().toArray(ItemStack[]::new);
            Arrays.sort(agreementPay);
            boolean requestedItemsEqual = decodedReq.length == agreementReq.length;
            for (int i = 0; i < decodedReq.length; ++i) {
                if (((RequestedItem)decodedReq[i]).equals(agreementReq[i])) continue;
                requestedItemsEqual = false;
                break;
            }
            boolean paymentItemsEqual = decodedPay.length == agreementPay.length;
            for (int i = 0; i < decodedPay.length; ++i) {
                if (ItemStack.m_150942_((ItemStack)agreementPay[i], (ItemStack)decodedPay[i])) continue;
                paymentItemsEqual = false;
                break;
            }
            boolean agreementsMatch = decodedAgreement.getId().equals(agreement.getId()) && decodedAgreement.getBuyerName().m_130668_(999).equals(agreement.getBuyerName().m_130668_(999)) && requestedItemsEqual && paymentItemsEqual && decodedAgreement.getOrdered() == agreement.getOrdered() && decodedAgreement.getDelivered() == agreement.getDelivered() && decodedAgreement.getExperience() == agreement.getExperience() && decodedAgreement.getExpireTimestamp() == agreement.getExpireTimestamp();
            this.assertThat(agreementsMatch, "Not matching.");
        }));
    }
}

