/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.aenetvistool.client;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.brandon3055.aenetvistool.client.NetRenderManager;
import com.brandon3055.aenetvistool.data.NetworkData;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class P2PLinkRenderer
extends BCParticle {
    public static ResourceLocation texture = new ResourceLocation("aenetvistool", "textures/beam.png");
    private NetworkData.NetNode node;
    private int keepAlive = 10;
    private static final FXHandler FX_HANDLER = new FXHandler();

    public P2PLinkRenderer(World worldIn, Vec3D pos, NetworkData.NetNode node) {
        super(worldIn, pos);
        this.node = node;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
    }

    public boolean isRawGLParticle() {
        return true;
    }

    public IGLFXHandler getFXHandler() {
        return FX_HANDLER;
    }

    public int func_70537_b() {
        return 1;
    }

    public void update() {
        this.keepAlive = 10;
    }

    public void func_189213_a() {
        if (this.keepAlive-- <= 0) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!FXHandler.refreshRender) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.bind(buffer);
        for (NetworkData.NetBus bus : this.node.busList) {
            int[] colour = Colour.unpack((int)bus.getP2PColour());
            for (NetworkData.PartPos pos : bus.p2pTargets) {
                this.renderBeam(buffer, bus.pos.getPartPos(), pos.getPartPos(), partialTicks, colour[1], colour[2], colour[3], rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            }
        }
    }

    public void renderBeam(BufferBuilder buffer, Vec3D p2pSource, Vec3D p2pTarget, float partialTicks, int r, int g, int b, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        double scale = 0.05;
        Vector3 source = new Vector3(p2pSource.x, p2pSource.y, p2pSource.z);
        Vector3 target = p2pTarget.toVector3();
        Vector3 dirVec = source.copy().subtract(target).normalize();
        Vector3 planeA = dirVec.copy().perpendicular().normalize();
        Vector3 planeB = dirVec.copy().crossProduct(planeA);
        Vector3 planeC = planeB.copy().rotate(0.7853981633974351, dirVec).normalize();
        Vector3 planeD = planeB.copy().rotate(-0.7853981633974351, dirVec).normalize();
        planeA.multiply(scale);
        planeB.multiply(scale);
        planeC.multiply(scale);
        planeD.multiply(scale);
        double dist = 0.2 * Utils.getDistanceAtoB((Vec3D)new Vec3D(source), (Vec3D)new Vec3D(target));
        double anim = (double)((float)NetRenderManager.tick + partialTicks) / -15.0;
        Vector3 p1 = source.copy().add(planeA);
        Vector3 p2 = target.copy().add(planeA);
        Vector3 p3 = source.copy().subtract(planeA);
        Vector3 p4 = target.copy().subtract(planeA);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        p1 = source.copy().add(planeB);
        p2 = target.copy().add(planeB);
        p3 = source.copy().subtract(planeB);
        p4 = target.copy().subtract(planeB);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        p1 = source.copy().add(planeC);
        p2 = target.copy().add(planeC);
        p3 = source.copy().subtract(planeC);
        p4 = target.copy().subtract(planeC);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        p1 = source.copy().add(planeD);
        p2 = target.copy().add(planeD);
        p3 = source.copy().subtract(planeD);
        p4 = target.copy().subtract(planeD);
        this.bufferQuad(buffer, p1, p2, p3, p4, anim, dist, r, g, b);
        double minU = 0.0;
        double maxU = 0.53;
        double minV = 0.0;
        double maxV = 0.53;
        buffer.func_181662_b(source.x - (double)rotationX * scale - (double)rotationXY * scale, source.y - (double)rotationZ * scale, source.z - (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(maxU, maxV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(source.x - (double)rotationX * scale + (double)rotationXY * scale, source.y + (double)rotationZ * scale, source.z - (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(maxU, minV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(source.x + (double)rotationX * scale + (double)rotationXY * scale, source.y + (double)rotationZ * scale, source.z + (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(minU, minV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(source.x + (double)rotationX * scale - (double)rotationXY * scale, source.y - (double)rotationZ * scale, source.z + (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(minU, maxV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(target.x - (double)rotationX * scale - (double)rotationXY * scale, target.y - (double)rotationZ * scale, target.z - (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(maxU, maxV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(target.x - (double)rotationX * scale + (double)rotationXY * scale, target.y + (double)rotationZ * scale, target.z - (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(maxU, minV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(target.x + (double)rotationX * scale + (double)rotationXY * scale, target.y + (double)rotationZ * scale, target.z + (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(minU, minV).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(target.x + (double)rotationX * scale - (double)rotationXY * scale, target.y - (double)rotationZ * scale, target.z + (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(minU, maxV).func_181669_b(r, g, b, 255).func_181675_d();
    }

    private void bufferQuad(BufferBuilder buffer, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4, double anim, double dist, int r, int g, int b) {
        buffer.func_181662_b(p1.x, p1.y, p1.z).func_187315_a(0.5, anim).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(p2.x, p2.y, p2.z).func_187315_a(0.5, dist + anim).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(p4.x, p4.y, p4.z).func_187315_a(1.0, dist + anim).func_181669_b(r, g, b, 255).func_181675_d();
        buffer.func_181662_b(p3.x, p3.y, p3.z).func_187315_a(1.0, anim).func_181669_b(r, g, b, 255).func_181675_d();
    }

    public static class FXHandler
    implements IGLFXHandler {
        public static int listIndex = 0;
        public static boolean refreshRender = true;

        public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            if (layer != 1) {
                return;
            }
            if (listIndex == 0) {
                listIndex = GL11.glGenLists((int)1);
            }
            CCRenderState.instance().reset();
            float rx = (float)Particle.field_70556_an;
            float ry = (float)Particle.field_70554_ao;
            float rz = (float)Particle.field_70555_ap;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-rx), (float)(-ry), (float)(-rz));
            if (refreshRender) {
                GL11.glNewList((int)listIndex, (int)4864);
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            }
        }

        public void postDraw(int layer, BufferBuilder buffer, Tessellator tessellator) {
            boolean noDepth;
            if (layer != 1) {
                return;
            }
            if (refreshRender) {
                Vec3d cameraPos = ActiveRenderInfo.getCameraPosition();
                buffer.func_181674_a((float)cameraPos.field_72450_a + (float)Particle.field_70556_an, (float)cameraPos.field_72448_b + (float)Particle.field_70554_ao, (float)cameraPos.field_72449_c + (float)Particle.field_70555_ap);
                tessellator.func_78381_a();
                GL11.glEndList();
                refreshRender = false;
            }
            boolean bl = noDepth = NetRenderManager.toolData == null || NetRenderManager.toolData.renderP2PNoDepth;
            if (noDepth) {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            GL11.glCallList((int)listIndex);
            if (noDepth) {
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }
}

