/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.spell;

import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.api.spell.Spell;
import com.shinoow.abyssalcraft.api.spell.SpellRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class SpellUtils {
    @Nullable
    public static Spell getSpell(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return SpellRegistry.instance().getSpell(stack.func_77978_p().func_74779_i("Spell"));
    }

    private static boolean hasEnoughPE(EntityPlayer player, float req) {
        ItemStack stack = player.func_184592_cb();
        if (stack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)stack.func_77973_b()).getContainedEnergy(stack) >= req) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack1 = player.field_71071_by.func_70301_a(i);
            if (!(stack1.func_77973_b() instanceof IEnergyContainerItem) || !(((IEnergyContainerItem)stack1.func_77973_b()).getContainedEnergy(stack1) >= req)) continue;
            return true;
        }
        return false;
    }

    private static void drainPE(EntityPlayer player, float energy) {
        ItemStack stack = player.func_184592_cb();
        if (stack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)stack.func_77973_b()).getContainedEnergy(stack) >= energy) {
            ((IEnergyContainerItem)stack.func_77973_b()).consumeEnergy(stack, energy);
        } else {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack1 = player.field_71071_by.func_70301_a(i);
                if (!(stack1.func_77973_b() instanceof IEnergyContainerItem) || !(((IEnergyContainerItem)stack1.func_77973_b()).getContainedEnergy(stack1) >= energy)) continue;
                ((IEnergyContainerItem)stack1.func_77973_b()).consumeEnergy(stack1, energy);
                break;
            }
        }
    }

    public static void castChargingSpell(ItemStack stack, World world, EntityPlayer player) {
        Spell spell = SpellUtils.getSpell(stack);
        if (spell != null && spell.requiresCharging() && spell.canCastSpell(world, player.func_180425_c(), player) && SpellUtils.hasEnoughPE(player, spell.getReqEnergy())) {
            spell.castSpell(world, player.func_180425_c(), player);
            SpellUtils.drainPE(player, spell.getReqEnergy());
        }
    }

    public static void castInstantSpell(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        Spell spell = SpellUtils.getSpell(stack);
        if (spell != null) {
            if (!spell.requiresCharging()) {
                if (spell.canCastSpell(world, player.func_180425_c(), player) && SpellUtils.hasEnoughPE(player, spell.getReqEnergy())) {
                    spell.castSpell(world, player.func_180425_c(), player);
                    SpellUtils.drainPE(player, spell.getReqEnergy());
                }
            } else {
                player.func_184598_c(hand);
                for (int i = 0; i < 3; ++i) {
                    world.func_175688_a(EnumParticleTypes.FLAME, player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N, player.field_70163_u + 1.0, player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public static boolean canPlayerHurt(EntityPlayer player, Entity target) {
        if (!(target instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player2 = (EntityPlayer)target;
        if (player2.func_184812_l_() || player2.func_175149_v()) {
            return false;
        }
        return player.func_96122_a(player2);
    }
}

