/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.server;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.recipe.MaterializerRecipes;
import com.shinoow.abyssalcraft.common.inventory.ContainerMaterializer;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class TransferStackMessage
extends AbstractMessage.AbstractServerMessage<TransferStackMessage> {
    private int slot;
    private ItemStack stack;

    public TransferStackMessage() {
    }

    public TransferStackMessage(int slot, ItemStack stack) {
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.slot = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.slot, (int)5);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.stack);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (player.field_71070_bA instanceof ContainerMaterializer && this.canMaterialize(this.stack, player.field_71070_bA.func_75139_a(0).func_75211_c())) {
            player.field_71070_bA.func_75141_a(this.slot, this.stack);
            player.field_71070_bA.func_75142_b();
        }
    }

    private boolean canMaterialize(ItemStack stack, ItemStack bag) {
        for (ItemStack stack1 : MaterializerRecipes.instance().getMaterializationResult(bag)) {
            if (!APIUtils.areStacksEqual(stack, stack1)) continue;
            return true;
        }
        return false;
    }
}

