/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.init;

import com.shinoow.abyssalcraft.api.integration.ACPlugin;
import com.shinoow.abyssalcraft.api.integration.IACPlugin;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.abyssalcraft.init.ILifeCycleHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class IntegrationHandler
implements ILifeCycleHandler {
    boolean isInvTweaksLoaded = Loader.isModLoaded((String)"inventorytweaks");
    boolean isJEILoaded = Loader.isModLoaded((String)"jei");
    List<String> mods = new ArrayList<String>();
    List<IACPlugin> integrations = new ArrayList<IACPlugin>();
    List<IACPlugin> temp = new ArrayList<IACPlugin>();

    private void findIntegrations(ASMDataTable asmDataTable) {
        ACLogger.info("Starting the Integration Handler.", new Object[0]);
        this.fetchModIntegrations(asmDataTable);
        if (!this.temp.isEmpty()) {
            ACLogger.info("Preliminary integration search complete: found {} possible mod integration(s)!", this.temp.size());
        }
    }

    private void fetchModIntegrations(ASMDataTable asmDataTable) {
        List<IACPlugin> plugins = this.fetchPlugins(asmDataTable, ACPlugin.class, IACPlugin.class);
        if (!plugins.isEmpty()) {
            for (IACPlugin plugin : plugins) {
                this.temp.add(plugin);
            }
        }
    }

    private <T> List<T> fetchPlugins(ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                ACLogger.severe("Failed to load: {}", asmData.getClassName(), e);
            }
        }
        return instances;
    }

    private void search() {
        if (this.isInvTweaksLoaded) {
            ACLogger.info("Inventory Tweaks is present, initializing sorting stuff.", new Object[0]);
            this.mods.add("Inventory Tweaks");
        }
        if (this.isJEILoaded) {
            ACLogger.info("Just Enough Items is present, initializing informative stuff.", new Object[0]);
            this.mods.add("Just Enough Items");
        }
        if (!this.temp.isEmpty()) {
            for (IACPlugin plugin : this.temp) {
                if (!plugin.canLoad()) continue;
                ACLogger.info("Found a integration for mod {}", plugin.getModName());
                this.integrations.add(plugin);
                this.mods.add(plugin.getModName());
            }
            this.temp.clear();
        }
        if (!this.mods.isEmpty()) {
            ACLogger.info("Mod integrations found: {}", this.mods);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.findIntegrations(event.getAsmData());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.search();
        if (!this.integrations.isEmpty()) {
            ACLogger.info("Initializing integrations!", new Object[0]);
            for (IACPlugin plugin : this.integrations) {
                plugin.init();
            }
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.integrations.isEmpty()) {
            ACLogger.info("Post-initializing integrations!", new Object[0]);
            for (IACPlugin plugin : this.integrations) {
                plugin.postInit();
            }
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
    }
}

