/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEntityEmpowerer
extends TileEntityInventoryBase {
    public int processTime;
    public int recipeForRenderIndex = -1;
    private int lastRecipe;

    public TileEntityEmpowerer() {
        super(1, "empowerer");
    }

    @Deprecated
    public static List<EmpowererRecipe> getRecipesForInput(ItemStack input) {
        ArrayList<EmpowererRecipe> recipesThatWork = new ArrayList<EmpowererRecipe>();
        if (StackUtil.isValid(input)) {
            for (EmpowererRecipe recipe : ActuallyAdditionsAPI.EMPOWERER_RECIPES) {
                if (!recipe.getInput().apply(input)) continue;
                recipesThatWork.add(recipe);
            }
        }
        return recipesThatWork;
    }

    public static boolean isPossibleInput(ItemStack stack) {
        for (EmpowererRecipe r : ActuallyAdditionsAPI.EMPOWERER_RECIPES) {
            if (!r.getInput().apply(stack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static EmpowererRecipe findMatchingRecipe(ItemStack base, ItemStack stand1, ItemStack stand2, ItemStack stand3, ItemStack stand4) {
        for (EmpowererRecipe r : ActuallyAdditionsAPI.EMPOWERER_RECIPES) {
            if (!r.matches(base, stand1, stand2, stand3, stand4)) continue;
            return r;
        }
        return null;
    }

    @Override
    public void updateEntity() {
        TileEntityDisplayStand[] stands;
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && (stands = this.getNearbyStands()) != null) {
            EmpowererRecipe recipe = TileEntityEmpowerer.findMatchingRecipe(this.inv.getStackInSlot(0), stands[0].getStack(), stands[1].getStack(), stands[2].getStack(), stands[3].getStack());
            if (recipe != null) {
                this.recipeForRenderIndex = ActuallyAdditionsAPI.EMPOWERER_RECIPES.indexOf(recipe);
                boolean hasPower = true;
                for (TileEntityDisplayStand stand : stands) {
                    if (stand.storage.getEnergyStored() >= recipe.getEnergyPerStand() / recipe.getTime()) continue;
                    hasPower = false;
                }
                if (hasPower) {
                    ++this.processTime;
                    boolean done = this.processTime >= recipe.getTime();
                    for (TileEntityDisplayStand stand : stands) {
                        stand.storage.extractEnergyInternal(recipe.getEnergyPerStand() / recipe.getTime(), false);
                        if (!done) continue;
                        stand.inv.getStackInSlot(0).func_190918_g(1);
                        stand.func_70296_d();
                    }
                    if (this.processTime % 5 == 0 && this.field_145850_b instanceof WorldServer) {
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.FIREWORKS_SPARK, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.1, new int[0]);
                    }
                    if (done) {
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.END_ROD, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 100, 0.0, 0.0, 0.0, 0.25, new int[0]);
                        this.inv.setStackInSlot(0, recipe.getOutput().func_77946_l());
                        this.func_70296_d();
                        this.processTime = 0;
                        this.recipeForRenderIndex = -1;
                    }
                }
            } else {
                this.processTime = 0;
                this.recipeForRenderIndex = -1;
            }
            if (this.lastRecipe != this.recipeForRenderIndex) {
                this.lastRecipe = this.recipeForRenderIndex;
                this.sendUpdate();
            }
        }
    }

    private TileEntityDisplayStand[] getNearbyStands() {
        TileEntityDisplayStand[] stands = new TileEntityDisplayStand[4];
        for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
            EnumFacing facing = EnumFacing.field_176754_o[i];
            BlockPos offset = this.field_174879_c.func_177967_a(facing, 3);
            TileEntity tile = this.field_145850_b.func_175625_s(offset);
            if (!(tile instanceof TileEntityDisplayStand)) {
                return null;
            }
            stands[i] = (TileEntityDisplayStand)tile;
        }
        return stands;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.func_74768_a("ProcessTime", this.processTime);
        }
        if (type == TileEntityBase.NBTType.SYNC) {
            compound.func_74768_a("RenderIndex", this.recipeForRenderIndex);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.processTime = compound.func_74762_e("ProcessTime");
        }
        if (type == TileEntityBase.NBTType.SYNC) {
            this.recipeForRenderIndex = compound.func_74762_e("RenderIndex");
        }
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || TileEntityEmpowerer.isPossibleInput(stack);
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || !TileEntityEmpowerer.isPossibleInput(this.inv.getStackInSlot(0));
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 1;
    }
}

