/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.spinningwheel;

import com.google.common.base.Preconditions;
import com.teammetallurgy.atum.utils.AtumUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class SpinningWheelRecipeWrapper
implements IRecipeWrapper {
    private final ResourceLocation id;
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;
    private final String rotations;

    public SpinningWheelRecipeWrapper(ResourceLocation id, NonNullList<ItemStack> input, @Nonnull ItemStack output, int wheelRotations) {
        Preconditions.checkArgument((wheelRotations > 0 ? 1 : 0) != 0, (Object)"wheel rotations must be greater than 0");
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>((Collection<ItemStack>)input);
        this.id = id;
        this.inputs = Collections.singletonList(inputList);
        this.output = output;
        this.rotations = AtumUtils.format("gui.atum.rotations", wheelRotations);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        mc.field_71466_p.func_78276_b(this.rotations, 25, 0, Color.gray.getRGB());
        mc.field_71466_p.func_78276_b(AtumUtils.format("gui.atum.rotations", 3), 4, 0, Color.gray.getRGB());
    }
}

