/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.advancements;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMUtils;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleAdvancementBuildEventPost
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMUtils.doesClassEqual(transformedName, ObfNameHelper.Classes.ADVANCEMENTMANAGER)) {
            String methodDesc;
            String methodName;
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.ADVANCEMENTMANAGERRELOAD.getName(), methodDesc = ObfNameHelper.Methods.ADVANCEMENTMANAGERRELOAD.getDescriptor());
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.addAdvancementBuildEventPostHook(method, transformedName)) {
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                    return ASMHelper.writeClassToBytes(classNode);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.ADVANCEMENTMANAGER.getName()};
    }

    @Override
    public String getModuleName() {
        return "advancementBuildEventPost";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean addAdvancementBuildEventPostHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.find(method.instructions, (AbstractInsnNode)ObfNameHelper.Methods.LOADADVANCEMENTS.toInsnNode(182));
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " post", transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)ObfNameHelper.Fields.ADVANCEMENTMANAGER_ADVANCEMENTLIST.toInsnNode(178));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ONADVANCEMENTBUILDPOST.toInsnNode(184));
        method.instructions.insert(target, toInject);
        return true;
    }
}

