/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.util;

import com.bloodnbonesgaming.bnbgamingcore.core.BNBGamingCorePlugin;
import com.bloodnbonesgaming.bnbgamingcore.core.util.BNBCoreEvents;
import com.bloodnbonesgaming.bnbgamingcore.core.util.BNBGamingClassTransformer;
import com.google.common.collect.ObjectArrays;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.relauncher.FileListHelper;

public class ModuleDisableHandler {
    private static final Attributes.Name requiresEventAttribute = new Attributes.Name("RequiresBNBCoreEvent");

    public static void init(File mcLocation) {
        ArrayList<String> modulesToEnable = new ArrayList<String>();
        File modDir = new File(mcLocation, "mods");
        FilenameFilter jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        Object[] modList = modDir.listFiles(jarFilter);
        File[] parentSources = ModuleDisableHandler.getParentSources();
        ArrayList<File> parentSourcesList = new ArrayList<File>();
        for (int i = 0; i < parentSources.length; ++i) {
            if (!parentSources[i].getName().endsWith(".jar")) continue;
            parentSourcesList.add(parentSources[i]);
        }
        modList = (File[])ObjectArrays.concat((Object[])modList, (Object[])parentSourcesList.toArray(new File[0]), File.class);
        File versionedModDir = new File(modDir, "1.12.2");
        if (versionedModDir.isDirectory()) {
            Object[] versionedCoreMods = versionedModDir.listFiles(jarFilter);
            modList = (File[])ObjectArrays.concat((Object[])modList, (Object[])versionedCoreMods, File.class);
        }
        modList = FileListHelper.sortFileList((File[])modList);
        BNBGamingCorePlugin.log.debug("Found " + modList.length + " mods.");
        for (Object mod : modList) {
            try (JarFile modJar = new JarFile((File)mod);){
                Attributes attributes;
                Manifest manifest;
                if (modJar == null || (manifest = modJar.getManifest()) == null || !(attributes = manifest.getMainAttributes()).containsKey(requiresEventAttribute)) continue;
                BNBGamingCorePlugin.log.debug("Found mod with correct manifest attribute. " + modJar.getName());
                String string = attributes.getValue(requiresEventAttribute);
                BNBGamingCorePlugin.log.debug("Attribute string: " + string);
                String[] events = string.split(",");
                for (int i = 0; i < events.length; ++i) {
                    List<String> modules = BNBCoreEvents.getModulesToEnable(events[i]);
                    if (modules == null) continue;
                    modulesToEnable.addAll(modules);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BNBGamingClassTransformer.disableAllTransformerModulesExcept(modulesToEnable);
    }

    public static File[] getParentSources() {
        try {
            LaunchClassLoader loader = (LaunchClassLoader)ModuleDisableHandler.class.getClassLoader();
            ArrayList<File> files = new ArrayList<File>();
            for (URL url : loader.getSources()) {
                URI uri = url.toURI();
                if (!uri.getScheme().equals("file")) continue;
                files.add(new File(uri));
            }
            return files.toArray(new File[0]);
        }
        catch (URISyntaxException e) {
            FMLLog.log.error("Unable to process our input to locate the minecraft code", (Throwable)e);
            throw new LoaderException((Throwable)e);
        }
    }
}

