/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util.script;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.util.script.ArgTransformer;
import net.minecraft.world.gen.layer.GenLayer;

public enum ArgType {
    INT{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toInt(arg);
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "int";
        }
    }
    ,
    LONG{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toLong(arg);
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "long";
        }
    }
    ,
    FLOAT{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toFloat(arg);
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "float";
        }
    }
    ,
    DOUBLE{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toDouble(arg);
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "double";
        }
    }
    ,
    STRING{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toString(arg);
        }

        @Override
        public boolean allowNull() {
            return true;
        }

        @Override
        public String toString() {
            return "String";
        }
    }
    ,
    NON_NULL_BIOME_ID{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toBiomeInt(arg);
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "Non_Null_Biome_ID";
        }
    }
    ,
    BIOME_ID_ARRAY{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toBiomeIntArray(arg);
        }

        @Override
        public boolean allowNull() {
            return true;
        }

        @Override
        public String toString() {
            return "Biome_ID_Array";
        }
    }
    ,
    NON_NULL_BIOME_ID_ARRAY{

        @Override
        public Object transformArg(Object arg) {
            return ArgTransformer.toBiomeIntArray(arg);
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "Non_Null_Biome_ID_Array";
        }
    }
    ,
    GENLAYER{

        @Override
        public Object transformArg(Object arg) {
            return arg instanceof GenLayer ? arg : null;
        }

        @Override
        public boolean allowNull() {
            return false;
        }

        @Override
        public String toString() {
            return "GenLayer";
        }
    };


    public abstract Object transformArg(Object var1);

    public abstract boolean allowNull();

    public abstract String toString();

    public static Object[] transformArgs(Object[] masterArgs, ArgType[] argTypes) {
        Object[] args = new Object[masterArgs.length];
        for (int i = 0; i < args.length && i < argTypes.length; ++i) {
            if (masterArgs[i] == null) {
                if (argTypes[i].allowNull()) continue;
                BNBGamingLib.libInstance.getLog().info("Arg " + i + " was null and the argtype does not accept null");
                return null;
            }
            Object arg = argTypes[i].transformArg(masterArgs[i]);
            if (arg != null) {
                args[i] = arg;
                continue;
            }
            BNBGamingLib.libInstance.getLog().info("Arg " + i + " could not be transformed");
            return null;
        }
        return args;
    }
}

