/*
 * Decompiled with CFR 0.152.
 */
package bqtweaker.client.gui;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasHoverTray;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.popups.PopContextMenu;
import betterquesting.api2.client.gui.resources.colors.GuiColorPulse;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.client.gui2.editors.GuiQuestLinesEditor;
import betterquesting.client.gui2.editors.designer.GuiDesigner;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;

public class GuiQuestLinesOverride
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private IQuestLine selectedLine = null;
    private static int selectedLineId = -1;
    private final List<Tuple<DBEntry<IQuestLine>, Integer>> visChapters = new ArrayList<Tuple<DBEntry<IQuestLine>, Integer>>();
    private CanvasQuestLine cvQuest;
    private CanvasEmpty cvQuestPopup;
    private static CanvasEmpty cvChapterTray;
    private static CanvasHoverTray cvFrame;
    private CanvasScrolling cvLines;
    private PanelVScrollBar scLines;
    private PanelGeneric icoChapter;
    private CanvasScrolling txTitleScroll;
    private CanvasScrolling txDescScroll;
    private PanelTextBox txTitle;
    private PanelTextBox txDesc;
    private PanelButton claimAll;
    private PanelButton btnDesign;
    private final List<PanelButtonStorage<DBEntry<IQuestLine>>> btnListRef = new ArrayList<PanelButtonStorage<DBEntry<IQuestLine>>>();

    public GuiQuestLinesOverride(GuiScreen parent) {
        super(parent);
    }

    public void refreshGui() {
        this.refreshChapterVisibility();
        this.refreshContent();
    }

    public void initPanel() {
        super.initPanel();
        if (selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(selectedLineId);
            if (this.selectedLine == null) {
                selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        final boolean canEdit = ((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel((IGuiPanel)cvBackground);
        CanvasTextured cvTopBar = new CanvasTextured((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -32), 0), PresetTexture.PANEL_MAIN.getTexture());
        cvBackground.addPanel((IGuiPanel)cvTopBar);
        PanelButton btnExit = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -24, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_PG_PREV.getTexture());
        btnExit.setClickAction(b -> this.field_146297_k.func_147108_a(this.parent));
        btnExit.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"gui.back", (Object[])new Object[0])));
        cvBackground.addPanel((IGuiPanel)btnExit);
        if (canEdit) {
            PanelButton btnEdit = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -40, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_GEAR.getTexture());
            btnEdit.setClickAction(b -> this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestLinesEditor((GuiScreen)this)));
            btnEdit.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)btnEdit);
            this.btnDesign = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.BOTTOM_LEFT, 8, -56, 16, 16, 0), -1, "").setIcon(PresetIcon.ICON_SORT.getTexture());
            this.btnDesign.setClickAction(b -> this.field_146297_k.func_147108_a((GuiScreen)new GuiDesigner((GuiScreen)this, this.selectedLine)));
            this.btnDesign.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.designer", (Object[])new Object[0])));
            cvBackground.addPanel((IGuiPanel)this.btnDesign);
            this.btnDesign.setActive(this.selectedLine != null);
        }
        this.icoChapter = new PanelGeneric((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 16, 8, 16, 16, 0), null);
        cvTopBar.addPanel((IGuiPanel)this.icoChapter);
        this.txTitleScroll = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(44, 8, 2, 6), 0));
        cvTopBar.addPanel((IGuiPanel)this.txTitleScroll);
        this.txTitle = new PanelTextBox((IGuiRect)new GuiRectangle(0, 0, this.txTitleScroll.getTransform().getWidth(), this.txTitleScroll.getTransform().getHeight()), "", true);
        this.txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        this.txTitleScroll.addCulledPanel((IGuiPanel)this.txTitle, false);
        this.txDescScroll = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(2, 8, 6, 6), 0));
        cvTopBar.addPanel((IGuiPanel)this.txDescScroll);
        this.txDesc = new PanelTextBox((IGuiRect)new GuiRectangle(0, 0, this.txDescScroll.getTransform().getWidth(), this.txDescScroll.getTransform().getHeight()), "", true);
        this.txDesc.setColor(PresetColor.TEXT_HEADER.getColor());
        this.txDescScroll.addCulledPanel((IGuiPanel)this.txDesc, false);
        cvFrame = new CanvasHoverTray((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(174, 32, 8, 8), 0), (IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(180, 32, 8, 8), 0), PresetTexture.AUX_FRAME_0.getTexture());
        cvFrame.setManualOpen(true);
        cvBackground.addPanel((IGuiPanel)cvFrame);
        cvFrame.setTrayState(true, 1L);
        cvChapterTray = new CanvasEmpty((IGuiRect)new GuiRectangle(24, 24, 164, cvFrame.getTransform().getHeight() + 16));
        cvBackground.addPanel((IGuiPanel)cvChapterTray);
        this.cvLines = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 8, 16, 8), 0));
        cvChapterTray.addPanel((IGuiPanel)this.cvLines);
        this.scLines = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-16, 8, 8, 8), 0));
        this.cvLines.setScrollDriverY((IValueIO)this.scLines);
        cvChapterTray.addPanel((IGuiPanel)this.scLines);
        PanelButton fitView = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 8, 48, 16, 16, -2), 5, "");
        fitView.setIcon(PresetIcon.ICON_BOX_FIT.getTexture());
        fitView.setClickAction(b -> {
            if (this.cvQuest.getQuestLine() != null) {
                this.cvQuest.fitToWindow();
            }
        });
        fitView.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.zoom_fit", (Object[])new Object[0])));
        cvBackground.addPanel((IGuiPanel)fitView);
        this.claimAll = new PanelButton((IGuiRect)new GuiTransform(GuiAlign.TOP_LEFT, 8, 32, 16, 16, -2), -1, "");
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture());
        this.claimAll.setClickAction(b -> {
            if (this.cvQuest.getQuestButtons().size() <= 0) {
                return;
            }
            ArrayList<Integer> claimIdList = new ArrayList<Integer>();
            for (PanelButtonQuest pbQuest : this.cvQuest.getQuestButtons()) {
                IQuest q = (IQuest)((DBEntry)pbQuest.getStoredValue()).getValue();
                if (q.getRewards().size() <= 0 || !q.canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
                claimIdList.add(((DBEntry)pbQuest.getStoredValue()).getID());
            }
            int[] cIDs = new int[claimIdList.size()];
            for (int i = 0; i < cIDs.length; ++i) {
                cIDs[i] = (Integer)claimIdList.get(i);
            }
            NetQuestAction.requestClaim((int[])cIDs);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorStatic(-12303292), 0);
        });
        this.claimAll.setTooltip(Collections.singletonList(QuestTranslation.translate((String)"betterquesting.btn.claim_all", (Object[])new Object[0])));
        cvBackground.addPanel((IGuiPanel)this.claimAll);
        CanvasQuestLine oldCvQuest = this.cvQuest;
        this.cvQuest = new CanvasQuestLine((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), 2);
        this.cvQuestPopup = new CanvasEmpty((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0)){

            public boolean onMouseClick(int mx, int my, int click) {
                if (GuiQuestLinesOverride.this.cvQuest.getQuestLine() == null || !this.getTransform().contains(mx, my)) {
                    return false;
                }
                if (canEdit && click == 1) {
                    PopContextMenu popup = new PopContextMenu(new GuiRectangle(mx, my, RenderUtils.getStringWidth((String)QuestTranslation.translate((String)"betterquesting.btn.designer", (Object[])new Object[0]), (FontRenderer)Minecraft.func_71410_x().field_71466_p) + 12, GuiQuestLinesOverride.this.cvQuest.getButtonAt(mx, my) != null ? 32 : 16), true);
                    if (GuiQuestLinesOverride.this.cvQuest.getButtonAt(mx, my) != null) {
                        final GuiQuestEditor editor = new GuiQuestEditor((GuiScreen)new GuiQuestLinesOverride(GuiQuestLinesOverride.this.parent), ((DBEntry)GuiQuestLinesOverride.this.cvQuest.getButtonAt(mx, my).getStoredValue()).getID());
                        Runnable actionEditor = new Runnable(){

                            @Override
                            public void run() {
                                GuiQuestLinesOverride.this.field_146297_k.func_147108_a((GuiScreen)editor);
                            }
                        };
                        popup.addButton(QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0]), null, actionEditor);
                    }
                    final GuiDesigner designer = new GuiDesigner((GuiScreen)new GuiQuestLinesOverride(GuiQuestLinesOverride.this.parent), GuiQuestLinesOverride.this.cvQuest.getQuestLine());
                    Runnable actionDesigner = new Runnable(){

                        @Override
                        public void run() {
                            GuiQuestLinesOverride.this.field_146297_k.func_147108_a((GuiScreen)designer);
                        }
                    };
                    popup.addButton(QuestTranslation.translate((String)"betterquesting.btn.designer", (Object[])new Object[0]), null, actionDesigner);
                    GuiQuestLinesOverride.this.openPopup((IGuiPanel)popup);
                    return true;
                }
                return false;
            }
        };
        cvFrame.addPanel((IGuiPanel)this.cvQuest);
        cvFrame.addPanel((IGuiPanel)this.cvQuestPopup);
        if (this.selectedLine != null) {
            this.cvQuest.setQuestLine(this.selectedLine);
            if (oldCvQuest != null) {
                this.cvQuest.setZoom(oldCvQuest.getZoom());
                this.cvQuest.setScrollX(oldCvQuest.getScrollX());
                this.cvQuest.setScrollY(oldCvQuest.getScrollY());
                this.cvQuest.refreshScrollBounds();
                this.cvQuest.updatePanelScroll();
            }
            this.txTitle.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedName(), (Object[])new Object[0]));
            this.txDesc.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedDescription(), (Object[])new Object[0]));
            this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)this.selectedLine.getProperty(NativeProps.ICON), false, true), null);
        }
        this.refreshChapterVisibility();
        this.refreshClaimAll();
        this.refreshDesigner();
    }

    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        Minecraft mc = Minecraft.func_71410_x();
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            DBEntry quest = (DBEntry)((PanelButtonStorage)btn).getStoredValue();
            GuiHome.bookmark = new GuiQuest((GuiScreen)this, quest.getID());
            mc.func_147108_a(GuiHome.bookmark);
        }
    }

    private void refreshChapterVisibility() {
        boolean canEdit = ((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g);
        List lineList = QuestLineDatabase.INSTANCE.getSortedEntries();
        this.visChapters.clear();
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        for (DBEntry dbEntry : lineList) {
            int val;
            IQuestLine ql = (IQuestLine)dbEntry.getValue();
            EnumQuestVisibility vis = (EnumQuestVisibility)ql.getProperty(NativeProps.VISIBILITY);
            if (!canEdit && vis == EnumQuestVisibility.HIDDEN) continue;
            boolean show = false;
            boolean unlocked = false;
            boolean complete = false;
            boolean allComplete = true;
            boolean pendingClaim = false;
            if (canEdit) {
                show = true;
                unlocked = true;
                complete = true;
            }
            for (DBEntry qID : ql.getEntries()) {
                IQuest q = (IQuest)QuestDatabase.INSTANCE.getValue(qID.getID());
                if (q == null) continue;
                if (allComplete && !q.isComplete(playerID)) {
                    allComplete = false;
                }
                if (!pendingClaim && q.isComplete(playerID) && !q.hasClaimed(playerID)) {
                    pendingClaim = true;
                }
                if (!unlocked && q.isUnlocked(playerID)) {
                    unlocked = true;
                }
                if (!complete && q.isComplete(playerID)) {
                    complete = true;
                }
                if (!show && QuestCache.isQuestShown((IQuest)q, (UUID)playerID, (EntityPlayer)this.field_146297_k.field_71439_g)) {
                    show = true;
                }
                if (!unlocked || !complete || !show || !pendingClaim || allComplete) continue;
                break;
            }
            if (vis == EnumQuestVisibility.COMPLETED && !complete || vis == EnumQuestVisibility.UNLOCKED && !unlocked) continue;
            int n = val = pendingClaim ? 1 : 0;
            if (allComplete) {
                val |= 2;
            }
            if (!show) {
                val |= 4;
            }
            this.visChapters.add((Tuple<DBEntry<IQuestLine>, Integer>)new Tuple((Object)dbEntry, (Object)val));
        }
        this.buildChapterList();
    }

    private void buildChapterList() {
        this.cvLines.resetCanvas();
        this.btnListRef.clear();
        int listW = this.cvLines.getTransform().getWidth();
        for (int n = 0; n < this.visChapters.size(); ++n) {
            DBEntry entry = (DBEntry)this.visChapters.get(n).func_76341_a();
            int vis = (Integer)this.visChapters.get(n).func_76340_b();
            this.cvLines.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, n * 16, 16, 16, 0), (IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)((IQuestLine)entry.getValue()).getProperty(NativeProps.ICON), false, true)));
            if ((vis & 1) > 0) {
                this.cvLines.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(8, n * 16 + 8, 8, 8, -1), (IGuiTexture)new GuiTextureColored(PresetIcon.ICON_NOTICE.getTexture(), (IGuiColor)new GuiColorStatic(-256))));
            } else if ((vis & 2) > 0) {
                this.cvLines.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(8, n * 16 + 8, 8, 8, -1), (IGuiTexture)new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), (IGuiColor)new GuiColorStatic(-16711936))));
            }
            PanelButtonStorage btnLine = new PanelButtonStorage((IGuiRect)new GuiRectangle(16, n * 16, listW - 16, 16, 0), 1, QuestTranslation.translate((String)((IQuestLine)entry.getValue()).getUnlocalisedName(), (Object[])new Object[0]), (Object)entry);
            btnLine.setTextAlignment(0);
            btnLine.setActive((vis & 4) == 0 && entry.getID() != selectedLineId);
            btnLine.setCallback(q -> {
                this.btnListRef.forEach(b -> {
                    if (((DBEntry)b.getStoredValue()).getID() == selectedLineId) {
                        b.setActive(true);
                    }
                });
                btnLine.setActive(false);
                this.selectedLine = (IQuestLine)q.getValue();
                selectedLineId = q.getID();
                this.cvQuest.setQuestLine((IQuestLine)q.getValue());
                this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)((IQuestLine)q.getValue()).getProperty(NativeProps.ICON), false, true), null);
                this.txTitle.setText(QuestTranslation.translate((String)((IQuestLine)q.getValue()).getUnlocalisedName(), (Object[])new Object[0]));
                this.txDesc.setText(QuestTranslation.translate((String)((IQuestLine)q.getValue()).getUnlocalisedDescription(), (Object[])new Object[0]));
                this.cvQuest.fitToWindow();
                this.refreshClaimAll();
                this.refreshDesigner();
            });
            this.cvLines.addPanel((IGuiPanel)btnLine);
            this.btnListRef.add((PanelButtonStorage<DBEntry<IQuestLine>>)btnLine);
        }
        this.cvLines.refreshScrollBounds();
        this.scLines.setEnabled(this.cvLines.getScrollBounds().getHeight() > 0);
    }

    private void refreshContent() {
        if (selectedLineId >= 0) {
            this.selectedLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(selectedLineId);
            if (this.selectedLine == null) {
                selectedLineId = -1;
            }
        } else {
            this.selectedLine = null;
        }
        float zoom = this.cvQuest.getZoom();
        int sx = this.cvQuest.getScrollX();
        int sy = this.cvQuest.getScrollY();
        this.cvQuest.setQuestLine(this.selectedLine);
        this.cvQuest.setZoom(zoom);
        this.cvQuest.setScrollX(sx);
        this.cvQuest.setScrollY(sy);
        this.cvQuest.refreshScrollBounds();
        this.cvQuest.updatePanelScroll();
        if (this.selectedLine != null) {
            this.txTitle.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedName(), (Object[])new Object[0]));
            this.txDesc.setText(QuestTranslation.translate((String)this.selectedLine.getUnlocalisedDescription(), (Object[])new Object[0]));
            this.icoChapter.setTexture((IGuiTexture)new OreDictTexture(1.0f, (BigItemStack)this.selectedLine.getProperty(NativeProps.ICON), false, true), null);
        } else {
            this.txTitle.setText("");
            this.txDesc.setText("");
            this.icoChapter.setTexture(null, null);
        }
        this.refreshClaimAll();
        this.refreshDesigner();
    }

    private void refreshDesigner() {
        if (this.btnDesign != null) {
            this.btnDesign.setActive(this.selectedLine != null);
        }
    }

    private void refreshClaimAll() {
        if (this.cvQuest.getQuestLine() == null || this.cvQuest.getQuestButtons().size() <= 0) {
            this.claimAll.setActive(false);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorStatic(-12303292), 0);
            return;
        }
        for (PanelButtonQuest btn : this.cvQuest.getQuestButtons()) {
            if (!((IQuest)((DBEntry)btn.getStoredValue()).getValue()).canClaim((EntityPlayer)this.field_146297_k.field_71439_g)) continue;
            this.claimAll.setActive(true);
            this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorPulse(-1, -12303292, 2.0, 0.0f), 0);
            return;
        }
        this.claimAll.setIcon(PresetIcon.ICON_CHEST_ALL.getTexture(), (IGuiColor)new GuiColorStatic(-12303292), 0);
        this.claimAll.setActive(false);
    }
}

