/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.resources.textures.LayeredTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class PanelItemSlot
extends PanelButtonStorage<BigItemStack> {
    private final boolean showCount;
    private final boolean oreDict;
    private final List<BigItemStack> oreVariants = new ArrayList<BigItemStack>();

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value) {
        this(rect, id, value, false, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount) {
        this(rect, id, value, showCount, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount, boolean oreDict) {
        super(rect, id, "", value);
        this.showCount = showCount;
        this.oreDict = oreDict;
        this.setTextures(PresetTexture.ITEM_FRAME.getTexture(), PresetTexture.ITEM_FRAME.getTexture(), new LayeredTexture(PresetTexture.ITEM_FRAME.getTexture(), new ColorTexture(PresetColor.ITEM_HIGHLIGHT.getColor(), new GuiPadding(1, 1, 1, 1))));
        this.setStoredValue(value);
    }

    public PanelItemSlot setStoredValue(BigItemStack value) {
        super.setStoredValue(value);
        if (value != null) {
            Minecraft mc = Minecraft.func_71410_x();
            this.setIcon(this.oreDict || value.getBaseStack().func_77952_i() == Short.MAX_VALUE ? new OreDictTexture(1.0f, value, this.showCount, true) : new ItemTexture(value, this.showCount, true), 1);
            this.setTooltip(value.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
        } else {
            this.setIcon(null);
            this.setTooltip(null);
        }
        this.updateOreStacks();
        return this;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (this.getStoredValue() != null && this.getTransform().contains(mx, my)) {
            BigItemStack ttStack = (BigItemStack)this.getStoredValue();
            if (this.oreDict && this.oreVariants.size() > 0) {
                ttStack = this.oreVariants.get((int)((double)System.currentTimeMillis() / 1000.0) % this.oreVariants.size());
            }
            Minecraft mc = Minecraft.func_71410_x();
            return ttStack.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        }
        return null;
    }

    private void updateOreStacks() {
        if (this.oreVariants == null) {
            return;
        }
        this.oreVariants.clear();
        BigItemStack stack = (BigItemStack)this.getStoredValue();
        if (stack == null) {
            return;
        }
        if (!stack.hasOreDict()) {
            if (stack.getBaseStack().func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                stack.getBaseStack().func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                subItems.forEach(is -> {
                    BigItemStack bis = new BigItemStack((ItemStack)is);
                    bis.stackSize = stack.stackSize;
                    this.oreVariants.add(bis);
                });
            } else {
                this.oreVariants.add(stack);
            }
            return;
        }
        for (ItemStack iStack : stack.getOreIngredient().func_193365_a()) {
            if (iStack.func_77952_i() == Short.MAX_VALUE) {
                NonNullList subItems = NonNullList.func_191196_a();
                iStack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                for (ItemStack sStack : subItems) {
                    BigItemStack bStack = new BigItemStack(sStack);
                    bStack.stackSize = stack.stackSize;
                    this.oreVariants.add(bStack);
                }
                continue;
            }
            BigItemStack bStack = new BigItemStack(iStack);
            bStack.stackSize = stack.stackSize;
            this.oreVariants.add(bStack);
        }
    }
}

