/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import wanion.biggercraftingtables.BiggerCraftingTables;
import wanion.biggercraftingtables.block.TileEntityBiggerCreatingTable;
import wanion.lib.common.IGhostAcceptorContainer;
import wanion.lib.common.IShapedContainer;
import wanion.lib.common.WContainer;
import wanion.lib.inventory.slot.MatchingSlot;
import wanion.lib.inventory.slot.ShapeSlot;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public class ContainerBiggerCreatingTable<R extends IAdvancedRecipe, T extends TileEntityBiggerCreatingTable<R>>
extends WContainer<T>
implements IGhostAcceptorContainer,
IShapedContainer {
    private final T tileEntityBiggerCreatingTable;
    private final int playerInventoryEnds;
    private final int playerInventoryStarts;
    private final int result;
    private final int root;

    public ContainerBiggerCreatingTable(int inventoryStartsX, int inventoryStartsY, int playerStartsX, int playerStartsY, int resultX, int resultY, @Nonnull T tileEntityBiggerCreatingTable, InventoryPlayer inventoryPlayer) {
        super(tileEntityBiggerCreatingTable);
        int x;
        int y;
        this.tileEntityBiggerCreatingTable = tileEntityBiggerCreatingTable;
        this.root = ((TileEntityBiggerCreatingTable)((Object)tileEntityBiggerCreatingTable)).getRoot();
        for (y = 0; y < this.root; ++y) {
            for (x = 0; x < this.root; ++x) {
                this.func_75146_a((Slot)new MatchingSlot(tileEntityBiggerCreatingTable, y * this.root + x, inventoryStartsX + 18 * x, inventoryStartsY + 18 * y));
            }
        }
        this.func_75146_a((Slot)new ShapeSlot(tileEntityBiggerCreatingTable, this.root * this.root, resultX, resultY));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + y * 9 + x, playerStartsX + 18 * x, playerStartsY + 18 * y));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, playerStartsX + 18 * i, playerStartsY + 58));
        }
        this.playerInventoryEnds = this.field_75151_b.size();
        this.playerInventoryStarts = this.playerInventoryEnds - 36;
        this.result = this.playerInventoryStarts - 1;
    }

    @Nonnull
    public final ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slot) {
        ItemStack itemstack = null;
        Slot actualSlot = (Slot)this.field_75151_b.get(slot);
        if (slot > this.result && actualSlot != null && actualSlot.func_75216_d()) {
            ItemStack itemstack1 = actualSlot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (!this.func_75135_a(itemstack1, this.playerInventoryStarts, this.playerInventoryEnds, true)) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack != null ? itemstack : ItemStack.field_190927_a;
    }

    @Nonnull
    public final ItemStack func_184996_a(int slot, int mouseButton, @Nonnull ClickType clickType, @Nonnull EntityPlayer entityPlayer) {
        if (slot >= 0 && slot < this.result) {
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            if (clickType == ClickType.QUICK_MOVE) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            } else if (clickType == ClickType.PICKUP) {
                ItemStack playerStack = entityPlayer.field_71071_by.func_70445_o();
                boolean slotHasStack = actualSlot.func_75216_d();
                if (slotHasStack && mouseButton == 1 && actualSlot instanceof MatchingSlot) {
                    this.nextMatching((MatchingSlot)actualSlot);
                } else if (!playerStack.func_190926_b()) {
                    ItemStack newSlotStack = playerStack.func_77946_l();
                    newSlotStack.func_190920_e(1);
                    if (!playerStack.func_77969_a(actualSlot.func_75211_c())) {
                        actualSlot.func_75215_d(newSlotStack);
                    } else {
                        actualSlot.func_75215_d(ItemStack.field_190927_a);
                    }
                    if (actualSlot instanceof MatchingSlot) {
                        this.resetMatching((MatchingSlot)actualSlot);
                    }
                } else if (slotHasStack) {
                    actualSlot.func_75215_d(ItemStack.field_190927_a);
                    if (actualSlot instanceof MatchingSlot) {
                        this.resetMatching((MatchingSlot)actualSlot);
                    }
                }
            }
            return ItemStack.field_190927_a;
        }
        if (slot == this.result) {
            boolean playerHasStack;
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            boolean slotHasStack = actualSlot.func_75216_d();
            ItemStack playerStack = entityPlayer.field_71071_by.func_70445_o();
            boolean bl = playerHasStack = !playerStack.func_190926_b();
            if (clickType == ClickType.PICKUP || clickType == ClickType.QUICK_MOVE) {
                if (playerHasStack && !slotHasStack) {
                    ItemStack newSlotStack = playerStack.func_77946_l();
                    actualSlot.func_75215_d(newSlotStack);
                } else if (slotHasStack && !playerHasStack) {
                    ItemStack slotStack = actualSlot.func_75211_c();
                    if (mouseButton == 1) {
                        slotStack.func_190920_e(clickType == ClickType.PICKUP ? slotStack.func_190916_E() - 1 : slotStack.func_190916_E() - 16);
                        if (!actualSlot.func_75216_d()) {
                            actualSlot.func_75215_d(ItemStack.field_190927_a);
                        }
                    }
                    if (mouseButton == 0 && slotStack.func_190916_E() < slotStack.func_77976_d()) {
                        slotStack.func_190920_e(MathHelper.func_76125_a((int)(clickType == ClickType.PICKUP ? slotStack.func_190916_E() + 1 : slotStack.func_190916_E() + 16), (int)1, (int)slotStack.func_77976_d()));
                    }
                } else if (playerStack.func_77969_a(actualSlot.func_75211_c())) {
                    actualSlot.func_75215_d(ItemStack.field_190927_a);
                }
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, mouseButton, clickType, entityPlayer);
    }

    private void nextMatching(@Nonnull MatchingSlot matchingSlot) {
        if (BiggerCraftingTables.proxy.isServer()) {
            matchingSlot.getMatching().nextMatcher();
            this.func_75142_b();
        }
    }

    private void resetMatching(@Nonnull MatchingSlot matchingSlot) {
        if (BiggerCraftingTables.proxy.isServer()) {
            matchingSlot.getMatching().resetMatcher();
            this.func_75142_b();
        }
    }

    public final void defineShape(short key, @Nonnull ItemStack output) {
        IAdvancedRecipe advancedRecipe = ((TileEntityBiggerCreatingTable)((Object)this.tileEntityBiggerCreatingTable)).getRecipeRegistry().findRecipeByKeyAndOutput(key, output);
        if (advancedRecipe == null) {
            return;
        }
        this.clearShape();
        List inputs = advancedRecipe.getInputs();
        if (advancedRecipe.isShaped()) {
            int i = 0;
            for (int y = 0; y < this.root; ++y) {
                for (int x = 0; x < this.root; ++x) {
                    ItemStack stackInput;
                    if (i >= inputs.size() || x >= advancedRecipe.getWidth() || y >= advancedRecipe.getHeight()) continue;
                    Slot slot = (Slot)this.field_75151_b.get(x + this.root * y);
                    if ((stackInput = ContainerBiggerCreatingTable.getStackInput(inputs.get(i++))) == null) continue;
                    slot.func_75215_d(stackInput);
                }
            }
        } else {
            for (int i = 0; i < inputs.size() && i < this.root * this.root; ++i) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack stackInput = ContainerBiggerCreatingTable.getStackInput(inputs.get(i));
                if (stackInput == null) continue;
                slot.func_75215_d(stackInput);
            }
        }
        ((Slot)this.field_75151_b.get(this.result)).func_75215_d(advancedRecipe.getOutput());
        this.func_75142_b();
    }

    public void clearShape() {
        this.clearShape(this.root * this.root);
    }

    private void clearShape(int endsIn) {
        for (int i = 0; i <= endsIn; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof MatchingSlot)) continue;
            slot.func_75215_d(ItemStack.field_190927_a);
            this.resetMatching((MatchingSlot)slot);
        }
        this.tileEntityBiggerCreatingTable.func_70296_d();
    }

    public void acceptGhostStack(int slot, @Nonnull ItemStack itemStack) {
        if (slot < this.field_75151_b.size() - 36) {
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            actualSlot.func_75215_d(itemStack);
            if (actualSlot instanceof MatchingSlot) {
                this.resetMatching((MatchingSlot)actualSlot);
            }
            this.func_75142_b();
        }
    }

    private static ItemStack getStackInput(Object input) {
        return input instanceof ItemStack ? ((ItemStack)input).func_77946_l() : (input instanceof List ? ((ItemStack)((List)input).get(0)).func_77946_l() : null);
    }
}

