/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import codechicken.lib.render.item.IItemRenderer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelRegistryHelper {
    private static List<Pair<ModelResourceLocation, IBakedModel>> registerModels = new LinkedList<Pair<ModelResourceLocation, IBakedModel>>();
    private static List<IModelBakeCallbackPre> modelBakePreCallbacks = new LinkedList<IModelBakeCallbackPre>();
    private static List<IModelBakeCallback> modelBakeCallbacks = new LinkedList<IModelBakeCallback>();

    public static void registerPreBakeCallback(IModelBakeCallbackPre callback) {
        modelBakePreCallbacks.add(callback);
    }

    public static void registerCallback(IModelBakeCallback callback) {
        modelBakeCallbacks.add(callback);
    }

    public static void register(ModelResourceLocation location, IBakedModel model) {
        registerModels.add((Pair<ModelResourceLocation, IBakedModel>)new ImmutablePair((Object)location, (Object)model));
    }

    public static void registerItemRenderer(Item item, IItemRenderer renderer) {
        ModelResourceLocation modelLoc = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ModelRegistryHelper.register(modelLoc, renderer);
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelLoc);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (IModelBakeCallbackPre iModelBakeCallbackPre : modelBakePreCallbacks) {
            iModelBakeCallbackPre.onModelBakePre((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry());
        }
        for (Pair pair : registerModels) {
            event.getModelRegistry().func_82595_a(pair.getKey(), pair.getValue());
        }
        for (IModelBakeCallback iModelBakeCallback : modelBakeCallbacks) {
            iModelBakeCallback.onModelBake((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry());
        }
    }

    public static interface IModelBakeCallback {
        public void onModelBake(IRegistry<ModelResourceLocation, IBakedModel> var1);
    }

    public static interface IModelBakeCallbackPre {
        public void onModelBakePre(IRegistry<ModelResourceLocation, IBakedModel> var1);
    }
}

