/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capabilities.arcana;

import divinerpg.DivineRPG;
import divinerpg.api.arcana.IArcana;
import divinerpg.networking.message.MessageArcanaBar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Arcana
implements IArcana {
    private int tickDelay = 4;
    private float max;
    private float arcana = this.max = 200.0f;

    @Override
    public void consume(EntityPlayer player, float points) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        this.set(this.getArcana() - points);
        this.sendPacket(player);
    }

    @Override
    public void fill(EntityPlayer player, float points) {
        float prev = this.getArcana();
        this.set(prev + points);
        if (prev != this.getArcana()) {
            this.sendPacket(player);
        }
    }

    @Override
    public void regen(EntityPlayer player) {
        if (player.field_70170_p.func_82737_E() % (long)this.tickDelay == 0L) {
            this.fill(player, 1.0f);
        }
    }

    @Override
    public void set(float points) {
        this.arcana = MathHelper.func_76131_a((float)points, (float)0.0f, (float)this.getMaxArcana());
    }

    @Override
    public float getArcana() {
        return this.arcana;
    }

    @Override
    public float getMaxArcana() {
        return this.max;
    }

    @Override
    public void setMaxArcana(float max) {
        if (max < 0.0f) {
            throw new IllegalArgumentException("Max of arcana cn't be less then null!");
        }
        this.max = max;
    }

    @Override
    public int getRegenDelay() {
        return this.tickDelay;
    }

    @Override
    public void setRegenDelay(int delay) {
        if (delay < 1) {
            throw new IllegalArgumentException("Tick delay beetween regen can't be less than one!");
        }
        this.tickDelay = delay;
    }

    private void sendPacket(EntityPlayer player) {
        if (!(player instanceof FakePlayer) && player instanceof EntityPlayerMP) {
            DivineRPG.network.sendTo((IMessage)new MessageArcanaBar(this), (EntityPlayerMP)player);
        }
    }
}

