/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.iceika;

import divinerpg.dimensions.iceika.IceikaCaves;
import divinerpg.dimensions.iceika.IceikaTerrainGenerator;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.StructureRegistry;
import divinerpg.structure.iceika.archerdungeon.ArcherDungeon;
import divinerpg.structure.iceika.rollum.RollumDungeon;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class IceikaChunkGenerator
implements IChunkGenerator {
    private final World world;
    private Random rand;
    private Biome[] biomesForGeneration;
    private final MapGenBase caveGenerator;
    private IceikaTerrainGenerator terraingen = new IceikaTerrainGenerator();
    private ArcherDungeon archerDungeonGenerator;
    private RollumDungeon rollumDungeonGenerator;

    public IceikaChunkGenerator(World world, long seed) {
        this.world = world;
        this.rand = new Random((seed + 516L) * 314L);
        this.terraingen.setup(world, this.rand);
        this.caveGenerator = new IceikaCaves();
        this.archerDungeonGenerator = new ArcherDungeon(world);
        this.rollumDungeonGenerator = new RollumDungeon(world);
    }

    public void generateTerrain(int x, int z, ChunkPrimer chunkPrimer) {
        int i = 4;
        int k = i + 1;
        int l = 17;
        int i1 = i + 1;
        int j = this.world.func_181545_F();
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < i; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        for (int j2 = 0; j2 < 4; ++j2) {
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (l1 * 8 + i2 < j) {
                                    iblockstate = Blocks.field_150355_j.func_176223_P();
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                chunkPrimer.func_177855_a(l2, i3, j3, iblockstate);
                            }
                        }
                    }
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateTerrain(x, z, chunkprimer);
        this.terraingen.setBiomesForGeneration(this.biomesForGeneration);
        this.terraingen.generate(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.terraingen.replaceBiomeBlocks(x, z, chunkprimer, this, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
        this.archerDungeonGenerator.func_186125_a(this.world, x, z, chunkprimer);
        this.rollumDungeonGenerator.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_72959_q().func_180631_a(pos);
        return biome != null ? biome.func_76747_a(creatureType) : null;
    }

    public boolean func_185933_a(Chunk chunkIn, int chunkX, int chunkZ) {
        return true;
    }

    public void func_180514_a(Chunk p_180514_1_, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int z;
        int y;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos pos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(new BlockPos(baseX, 0, baseZ));
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        this.archerDungeonGenerator.func_175794_a(this.world, this.rand, chunkpos);
        this.rollumDungeonGenerator.func_175794_a(this.world, this.rand, chunkpos);
        if (this.rand.nextInt(35) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p(new BlockPos(x + 3, (y = this.world.func_189649_b(x, z = baseZ + this.rand.nextInt(16))) - 1, z + 3)).func_177230_c() == BlockRegistry.frozenGrass) {
                int houseNumber = this.rand.nextInt(StructureRegistry.WORKSHOP_HOUSES.length);
                StructureRegistry.WORKSHOP_HOUSES[houseNumber].func_180709_b(this.world, this.rand, new BlockPos(x, y - 1, z));
            }
        } else if (this.rand.nextInt(15) == 0 && this.world.func_180495_p(new BlockPos(x = baseX + this.rand.nextInt(16), (y = this.world.func_189649_b(x, z = baseZ + this.rand.nextInt(16))) - 1, z)).func_177230_c() == BlockRegistry.frozenGrass) {
            int lampNumber = this.rand.nextInt(StructureRegistry.COALSTONE_LAMPS.length);
            StructureRegistry.COALSTONE_LAMPS[lampNumber].func_180709_b(this.world, this.rand, new BlockPos(x, y - 1, z));
        }
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, pos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(baseX + 8), (int)(baseZ + 8), (int)16, (int)16, (Random)this.rand);
        boolean flag = false;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && !flag && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, pos.func_177982_a(i1, j1, k1));
        }
        pos = pos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(pos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 3);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 3);
                }
            }
        }
    }
}

