/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.vethea;

import com.google.common.base.Predicate;
import divinerpg.dimensions.vethea.TempleWorldGenerator;
import divinerpg.dimensions.vethea.VetheaLevelGenerators;
import divinerpg.dimensions.vethea.WorldGenEnhanced;
import divinerpg.dimensions.vethea.WorldGenVetheanFlower;
import divinerpg.dimensions.vethea.WorldGenVetheanPillarNew;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.StructureRegistry;
import divinerpg.structure.vethea.crypt1.Crypt1;
import divinerpg.structure.vethea.crypt2.Crypt2;
import divinerpg.structure.vethea.evergarden.Evergarden;
import divinerpg.structure.vethea.hive.Hive;
import divinerpg.structure.vethea.karosmadhouse.KarosMadhouse;
import divinerpg.structure.vethea.quadroticpost.QuadroticPost;
import divinerpg.structure.vethea.raglokchamber.RaglokChamber;
import divinerpg.structure.vethea.temple1.Temple1;
import divinerpg.structure.vethea.temple2.Temple2;
import divinerpg.structure.vethea.wreckhall.WreckHall;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;

public class VetheaChunkGenerator
implements IChunkGenerator {
    private final List<VetheaLevelGenerators> levels = new ArrayList<VetheaLevelGenerators>();
    private World world;
    private int floorHeight = 48;
    private int roofHeight = 16;
    protected Random rand;

    public VetheaChunkGenerator(World world) {
        this.world = world;
        this.rand = new Random();
        for (int i = 0; i < 4; ++i) {
            VetheaLevelGenerators level = new VetheaLevelGenerators(this.floorHeight * i, this.roofHeight);
            this.customize(level, i);
            this.levels.add(level);
        }
    }

    private void customize(VetheaLevelGenerators level, int position) {
        String[] items;
        int i;
        WorldGenMinable large = new WorldGenMinable(BlockRegistry.fireCrystal.func_176223_P(), 50, (Predicate)BlockStateMatcher.func_177638_a((Block)BlockRegistry.dreamGrass));
        WorldGenMinable meduim = new WorldGenMinable(BlockRegistry.fireCrystal.func_176223_P(), 45, (Predicate)BlockStateMatcher.func_177638_a((Block)BlockRegistry.dreamGrass));
        WorldGenMinable small = new WorldGenMinable(BlockRegistry.fireCrystal.func_176223_P(), 20, (Predicate)BlockStateMatcher.func_177638_a((Block)BlockRegistry.dreamGrass));
        int surfaceLevel = position * this.floorHeight + this.roofHeight;
        level.addWorldGen(new WorldGenEnhanced((WorldGenerator)large, 42, surfaceLevel));
        level.addWorldGen(new WorldGenEnhanced((WorldGenerator)meduim, 12, surfaceLevel));
        level.addWorldGen(new WorldGenEnhanced((WorldGenerator)small, 6, surfaceLevel));
        for (i = 0; i < 7; ++i) {
            String[] tree = new TempleWorldGenerator(this.createForAllLevels(String.format("floatingtree%s", i + 1)), new BlockPos(11, (this.floorHeight - this.roofHeight) / 2, 11));
            level.addWorldGen(new WorldGenEnhanced((WorldGenerator)tree, 5, surfaceLevel + 8));
        }
        if (position < 3) {
            level.addWorldGen(new WorldGenEnhanced(new WorldGenVetheanPillarNew(this.floorHeight - this.roofHeight), 24, surfaceLevel));
        }
        level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForAllLevels("infusionoutpost"), true), 43, surfaceLevel));
        for (i = 1; i <= 2; ++i) {
            level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForAllLevels(String.format("lamp%s", i)), new BlockPos(10, 0, 10)), 40, surfaceLevel));
        }
        for (String item : items = new String[]{"bow", "hook", "mushroom", "pickaxe", "pointedsquare", "ring", "sword", "trident"}) {
            level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForAllLevels(item), new BlockPos(3, 0, 16)), 60, surfaceLevel));
        }
        switch (position) {
            case 0: {
                level.addStructure(new Crypt1(this.world, 10));
                level.addStructure(new Crypt2(this.world, 12));
                for (int i2 = 4; i2 <= 6; ++i2) {
                    level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForVethea(position, "tree" + i2), true), 24, surfaceLevel));
                }
                this.addFlowers(level, surfaceLevel, BlockRegistry.greenGemtop, BlockRegistry.purpleGemtop, BlockRegistry.yellowDulah, BlockRegistry.greenDulah);
                break;
            }
            case 1: {
                level.addStructure(new Hive(this.world, 64));
                level.addStructure(new Temple1(this.world, 64));
                level.addStructure(new Temple2(this.world, 64));
                level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForVethea(position, "tree3"), true), 10, surfaceLevel));
                level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForVethea(0, "tree3"), true), 10, surfaceLevel));
                this.addFlowers(level, surfaceLevel, BlockRegistry.fernite, BlockRegistry.dreamglow, BlockRegistry.shimmer);
                break;
            }
            case 2: {
                level.addStructure(new QuadroticPost(this.world, 112));
                level.addStructure(new KarosMadhouse(this.world, 112));
                for (int i3 = 7; i3 <= 8; ++i3) {
                    level.addWorldGen(new WorldGenEnhanced(new TempleWorldGenerator(this.createForVethea(position, "tree" + i3), true), 24, surfaceLevel));
                }
                this.addFlowers(level, surfaceLevel, BlockRegistry.shineGrass, BlockRegistry.cracklespike, BlockRegistry.bulbatobe);
                break;
            }
            case 3: {
                level.addStructure(new Evergarden(this.world, 160));
                level.addStructure(new RaglokChamber(this.world, 160));
                level.addStructure(new WreckHall(this.world, 160));
                this.addFlowers(level, surfaceLevel, BlockRegistry.shimmer, BlockRegistry.shineGrass, BlockRegistry.dreamglow);
            }
        }
    }

    private void addFlowers(VetheaLevelGenerators level, int height, Block ... blocks) {
        for (Block block : blocks) {
            level.addWorldGen(new WorldGenEnhanced(new WorldGenVetheanFlower(block), 5, height));
        }
    }

    private ResourceLocation createForVethea(int level, String structureFolder) {
        return new ResourceLocation("divinerpg", String.format("vethea/layer%s/%s", level + 1, structureFolder));
    }

    private ResourceLocation createForAllLevels(String structureName) {
        return new ResourceLocation("divinerpg", String.format("vethea/all_floors/%s", structureName));
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.levels.forEach(level -> level.generateChunk(this.world, chunkPrimer, x, z));
        Chunk chunk = new Chunk(this.world, chunkPrimer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        Random random = this.world.func_72843_D(chunkX, chunkZ, 10387313);
        this.levels.forEach(level -> level.populate(this.world, random, chunkX, chunkZ));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos pos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(new BlockPos(baseX, 0, baseZ));
        if (this.rand.nextInt(100) == 0) {
            int x = baseX + this.rand.nextInt(16);
            int z = baseZ + this.rand.nextInt(16);
            int y = 20 + this.rand.nextInt(8);
            int houseNumber = this.rand.nextInt(StructureRegistry.HUNGER_HOUSES.length);
            StructureRegistry.HUNGER_HOUSES[houseNumber].func_180709_b(this.world, this.rand, new BlockPos(x, y, z));
        }
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, pos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(baseX + 8), (int)(baseZ + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunk, int i, int i1) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_72959_q().func_180631_a(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String s, BlockPos blockPos, boolean b) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int i, int i1) {
    }

    public boolean func_193414_a(World world, String s, BlockPos blockPos) {
        MapGenStructure structure = this.levels.stream().map(x -> x.findStructure(s)).filter(Objects::nonNull).findFirst().orElse(null);
        if (structure != null) {
            return structure.func_175795_b(blockPos);
        }
        return false;
    }
}

