/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.vethea;

import divinerpg.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;

public class VetheaLevelGenerators {
    private List<MapGenStructure> structures = new ArrayList<MapGenStructure>();
    private List<WorldGenerator> generators = new ArrayList<WorldGenerator>();
    private int startHeight;
    private int roofHeight;

    public VetheaLevelGenerators(int startHeight, int roofHeight) {
        this.startHeight = startHeight;
        this.roofHeight = roofHeight;
    }

    public void addWorldGen(WorldGenerator generator) {
        this.addWorldGen(generator, false);
    }

    public void addWorldGen(WorldGenerator generator, boolean forced) {
        if (forced) {
            this.generators.add(0, generator);
        } else {
            this.generators.add(generator);
        }
    }

    public void addStructure(MapGenStructure structure) {
        this.structures.add(structure);
    }

    @Nullable
    public MapGenStructure findStructure(String name) {
        return this.structures.stream().filter(x -> x.func_143025_a().equals(name)).findFirst().orElse(null);
    }

    public void generateChunk(World world, ChunkPrimer chunkPrimer, int x, int z) {
        this.generateFloors(chunkPrimer);
        this.structures.forEach(gen -> gen.func_186125_a(world, x, z, chunkPrimer));
    }

    public void populate(World world, Random random, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos block = chunkPos.func_180331_a(1, this.startHeight + this.roofHeight, 1);
        if (!this.structures.stream().map(x -> x.func_175794_a(world, random, chunkPos)).filter(x -> x).findFirst().orElse(false).booleanValue()) {
            this.generators.forEach(x -> x.func_180709_b(world, random, block));
        }
    }

    private void generateFloors(ChunkPrimer chunkPrimer) {
        int earthLevel = this.startHeight + this.roofHeight;
        int dirtLevel = earthLevel - 1;
        int maxStoneLevel = dirtLevel - 1;
        int maxWidth = 15;
        BlockPos.func_191531_b((int)0, (int)this.startHeight, (int)0, (int)maxWidth, (int)maxStoneLevel, (int)maxWidth).forEach(x -> chunkPrimer.func_177855_a(x.func_177958_n(), x.func_177956_o(), x.func_177952_p(), BlockRegistry.dreamStone.func_176223_P()));
        BlockPos.func_191531_b((int)0, (int)dirtLevel, (int)0, (int)maxWidth, (int)dirtLevel, (int)maxWidth).forEach(x -> chunkPrimer.func_177855_a(x.func_177958_n(), x.func_177956_o(), x.func_177952_p(), BlockRegistry.dreamDirt.func_176223_P()));
        BlockPos.func_191531_b((int)0, (int)earthLevel, (int)0, (int)maxWidth, (int)earthLevel, (int)maxWidth).forEach(x -> chunkPrimer.func_177855_a(x.func_177958_n(), x.func_177956_o(), x.func_177952_p(), BlockRegistry.dreamGrass.func_176223_P()));
    }
}

