/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import net.minecraft.util.ResourceLocation;

public enum ArrowType {
    NONE(0.0f, 0.0f, null),
    HUNTER_ARROW(2.0f, 11.0f, ArrowType.ProjectileLoc("hunter_arrow"), ArrowSpecial.POSION),
    SHADOW_ARROW(2.0f, 11.0f, ArrowType.ProjectileLoc("shadow_arrow")),
    ENDER_ARROW(4.0f, 16.0f, ArrowType.ProjectileLoc("ender_arrow")),
    BLUEFIRE_ARROW(2.0f, 11.0f, ArrowType.ProjectileLoc("bluefire_arrow"), ArrowSpecial.EXPLODE),
    INFERNO_ARROW(2.0f, 11.0f, ArrowType.ProjectileLoc("inferno_arrow"), ArrowSpecial.FLAME),
    ICICLE_ARROW(2.0f, 11.0f, ArrowType.ProjectileLoc("icicle_arrow")),
    SNOWSTORM_ARROW(2.0f, 11.0f, ArrowType.ProjectileLoc("snowstorm_arrow"), ArrowSpecial.EXPLODE),
    EDEN_ARROW(6.0f, 16.0f, ArrowType.ProjectileLoc("eden_arrow")),
    LESSER_WILDWOOD_ARROW(6.0f, 16.0f, ArrowType.ProjectileLoc("wildwood_arrow")),
    GREATER_WILDWOOD_ARROW(10.0f, 20.0f, ArrowType.ProjectileLoc("wildwood_arrow")),
    FURY_ARROW(13.0f, 25.0f, ArrowType.ProjectileLoc("fury_arrow")),
    EVERFRIGHT(25.0f, 46.0f, ArrowType.ProjectileLoc("ever_arrow")),
    TEAKER_ARROW(2.0f, 5.0f, ArrowType.ProjectileLoc("teaker_arrow")),
    AMTHIRMIS_ARROW(2.0f, 7.0f, ArrowType.ProjectileLoc("teaker_arrow")),
    DARVEN_ARROW(3.0f, 11.0f, ArrowType.ProjectileLoc("darven_arrow")),
    CERMILE_ARROW(4.0f, 14.0f, ArrowType.ProjectileLoc("darven_arrow")),
    PARDIMAL_ARROW(5.0f, 18.0f, ArrowType.ProjectileLoc("pardimal_arrow")),
    QUADROTIC_ARROW(6.0f, 21.0f, ArrowType.ProjectileLoc("pardimal_arrow")),
    KAROS_ARROW(7.0f, 23.0f, ArrowType.ProjectileLoc("karos_arrow")),
    HELIOSIS_ARROW(8.0f, 28.0f, ArrowType.ProjectileLoc("karos_arrow")),
    ARKSIANE_ARROW(12.0f, 36.0f, ArrowType.ProjectileLoc("karos_arrow")),
    ARID_WARRIOR_ARROW(1.5f, 1.5f, ArrowType.VanillaLoc()),
    WILDFIRE_ARROW(5.0f, 5.0f, ArrowType.ProjectileLoc("inferno_arrow"), ArrowSpecial.FLAME),
    FROST_ARCHER_ARROW(2.0f, 2.0f, ArrowType.ProjectileLoc("snowstorm_arrow")),
    SUN_ARCHER_ARROW(9.0f, 9.0f, ArrowType.ProjectileLoc("eden_arrow")),
    ENCHANTED_ARCHER_ARROW(12.0f, 12.0f, ArrowType.ProjectileLoc("wildwood_arrow")),
    SKYTHERN_ARCHER_ARROW(14.0f, 14.0f, ArrowType.ProjectileLoc("wildwood_arrow")),
    TWILIGHT_ARCHER_ARROW(16.0f, 16.0f, ArrowType.ProjectileLoc("fury_arrow")),
    REYVOR_ARROW(22.0f, 22.0f, ArrowType.ProjectileLoc("fury_arrow")),
    ETERNAL_ARCHER_FLAME_ARROW(26.0f, 26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.FLAME),
    ETERNAL_ARCHER_WITHER_ARROW(26.0f, 26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.WITHER),
    ETERNAL_ARCHER_EXPLODE_ARROW(26.0f, 26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.EXPLODE),
    ETERNAL_ARCHER_SLOW_ARROW(26.0f, 26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.SLOW),
    ETERNAL_ARCHER_NAUSEA_ARROW(26.0f, 26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.NAUSEA),
    ETERNAL_ARCHER_BLIND_ARROW(26.0f, 26.0f, ArrowType.ProjectileLoc("fury_arrow"), ArrowSpecial.BLIND),
    LIVING_STATUE_ARROW(6.0f, 6.0f, ArrowType.VanillaLoc());

    private final float minDamage;
    private final float maxDamage;
    private final ResourceLocation texture;
    private ArrowSpecial arrowSpecial = ArrowSpecial.NONE;

    private ArrowType(float minDamage, float maxDamage, ResourceLocation texture) {
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
        this.texture = texture;
        this.arrowSpecial = ArrowSpecial.NONE;
    }

    private ArrowType(float minDamage, float maxDamage, ResourceLocation texture, ArrowSpecial special) {
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
        this.texture = texture;
        this.arrowSpecial = special;
    }

    public float getMinDamage() {
        return this.minDamage;
    }

    public float getMaxDamage() {
        return this.maxDamage;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ArrowSpecial getArrowSpecial() {
        return this.arrowSpecial;
    }

    public static ArrowType getArrowFromId(int ordinal) {
        if (ordinal < 0 || ordinal > ArrowType.values().length) {
            ordinal = 0;
        }
        return ArrowType.values()[ordinal];
    }

    private static ResourceLocation ProjectileLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/projectiles/" + name + ".png");
    }

    private static ResourceLocation VanillaLoc() {
        return new ResourceLocation("minecraft:textures/entity/projectiles/arrow.png");
    }

    public static enum ArrowSpecial {
        NONE,
        FLAME,
        WITHER,
        EXPLODE,
        SLOW,
        NAUSEA,
        BLIND,
        POSION;

    }
}

