/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks;

import divinerpg.objects.blocks.BlockMod;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockModDoubleCrop
extends BlockMod
implements IPlantable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    protected static final AxisAlignedBB TALL_CROP_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private Random rand;

    public BlockModDoubleCrop(String name) {
        super(name, 0.0f, Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.rand = new Random();
    }

    public abstract Item getSeedDrop();

    public abstract Item getFlowerDrop();

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TALL_CROP_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_175623_d(pos.func_177984_a()) && (Integer)state.func_177229_b((IProperty)AGE) == 0 && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151577_b && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)));
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        return block == this || state.func_185904_a() == Material.field_151577_b;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            if ((Integer)state.func_177229_b((IProperty)AGE) == 2) {
                this.func_176226_b(worldIn, pos, state, 0);
            } else if ((Integer)state.func_177229_b((IProperty)AGE) == 0) {
                BlockModDoubleCrop.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.getSeedDrop()));
            }
            worldIn.func_175655_b(pos, false);
        } else if ((Integer)state.func_177229_b((IProperty)AGE) == 1 && pos.func_177984_a().equals((Object)fromPos)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getSeedDrop();
    }

    public int func_149745_a(Random rand) {
        return 1 + rand.nextInt(2);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 0) {
            drops.add((Object)new ItemStack(this.func_180660_a(state, this.rand, 0), 1));
        } else if (age == 1) {
            drops.add((Object)new ItemStack(this.func_180660_a(state, this.rand, 0), this.func_149745_a(this.rand)));
        } else if (age == 2) {
            drops.add((Object)new ItemStack(this.getFlowerDrop(), 1));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeedDrop());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

