/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.arcana.death;

import divinerpg.objects.entities.entity.EntityDivineMob;
import divinerpg.registry.LootTableRegistry;
import divinerpg.registry.SoundRegistry;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityDeathBase
extends EntityDivineMob {
    private final Potion potionEffect;

    private EntityDeathBase(World w) {
        this(w, MobEffects.field_76421_d);
    }

    protected EntityDeathBase(World world, Potion potionEffect) {
        super(world);
        this.func_70105_a(1.0f, 1.2f);
        this.potionEffect = potionEffect;
    }

    public float func_70047_e() {
        return 0.85f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.addAttackingAI();
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.DEATHCRYX;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.DEATHCRYX_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.DEATHCRYX_HURT;
    }

    public boolean func_70652_k(Entity entity) {
        boolean attacked;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.func_70644_a(MobEffects.field_76433_i)) {
            damage += (float)(3 << this.func_70660_b(MobEffects.field_76433_i).func_76458_c());
        }
        if (this.func_70644_a(MobEffects.field_76437_t)) {
            damage -= (float)(2 << this.func_70660_b(MobEffects.field_76437_t).func_76458_c());
        }
        int knockback = 0;
        if (entity instanceof EntityLivingBase) {
            damage += (float)EnchantmentHelper.func_185293_e((EntityLivingBase)((EntityLivingBase)entity));
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)((EntityLivingBase)entity));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(this.potionEffect, 320, 2));
        }
        if (attacked = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            int fire;
            if (knockback > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fire = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(fire * 4);
            }
        }
        return attacked;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_DEATHCRYX;
    }
}

