/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss;

import divinerpg.enums.ArrowType;
import divinerpg.objects.entities.entity.EntityDivineBoss;
import divinerpg.objects.entities.entity.projectiles.EntityDivineArrow;
import divinerpg.registry.LootTableRegistry;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityQuadro
extends EntityDivineBoss
implements IRangedAttackMob {
    private QuadroAbility ability;
    private int abilityCooldown;
    private int rangedAttackCounter;
    public boolean dir;

    public EntityQuadro(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.2f, 2.2f);
        this.ability = this.getRandomAbility();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_QUADRO;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 1.0f, 1.0f));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof EntityLivingBase) {
            this.func_82196_d(this.func_70638_az(), 0.0f);
        }
        if (this.abilityCooldown <= 0) {
            this.ability = this.getRandomAbility();
            this.abilityCooldown = 500;
            this.rangedAttackCounter = 0;
            this.dir = true;
            int s = this.field_70146_Z.nextInt(9);
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
            for (EntityPlayer p : players) {
                String chatMessage;
                SoundEvent sound;
                switch (s) {
                    case 0: {
                        sound = SoundRegistry.QUADRO_DIE_BEFORE;
                        chatMessage = "message.quadro.die";
                        break;
                    }
                    case 1: {
                        sound = SoundRegistry.QUADRO_ENOUGH;
                        chatMessage = "message.quadro.enough";
                        break;
                    }
                    case 2: {
                        sound = SoundRegistry.QUADRO_INCOMING_PUNCH;
                        chatMessage = "message.quadro.punch";
                        break;
                    }
                    case 3: {
                        sound = SoundRegistry.QUADRO_IS_NEXT;
                        chatMessage = "message.quadro.next";
                        break;
                    }
                    case 4: {
                        sound = SoundRegistry.QUADRO_KILL_MINE;
                        chatMessage = "message.quadro.mine";
                        break;
                    }
                    case 5: {
                        sound = SoundRegistry.QUADRO_MY_KILL;
                        chatMessage = "message.quadro.kill";
                        break;
                    }
                    case 6: {
                        sound = SoundRegistry.QUADRO_NO_DIE;
                        chatMessage = "message.quadro.no";
                        break;
                    }
                    case 7: {
                        sound = SoundRegistry.QUADRO_SIT_DOWN;
                        chatMessage = "message.quadro.sit";
                        break;
                    }
                    default: {
                        sound = SoundRegistry.QUADRO_TASTE_FIST;
                        chatMessage = "message.quadro.taste";
                    }
                }
                this.field_70170_p.func_184133_a(p, p.func_180425_c(), sound, SoundCategory.HOSTILE, 1.0f, 1.0f);
                if (this.field_70170_p.field_72995_K) continue;
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, chatMessage, new Object[0]));
            }
        }
        if (this.abilityCooldown == 480) {
            --this.abilityCooldown;
            this.dir = false;
        }
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == QuadroAbility.MELEE_SLOW) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
            this.func_70659_e(0.48f);
        } else if (this.ability == QuadroAbility.MELEE_FAST) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.48);
            this.func_70659_e(0.32f);
        } else if (this.ability == QuadroAbility.RANGED_SLOW) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            this.func_70659_e(0.0f);
        } else if (this.ability == QuadroAbility.RANGED_FAST) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            this.func_70659_e(0.0f);
        }
    }

    public void func_82196_d(EntityLivingBase par1, float par2) {
        switch (this.ability) {
            case RANGED_FAST: {
                if (this.rangedAttackCounter % 5 == 0) {
                    EntityDivineArrow var2 = new EntityDivineArrow(this.field_70170_p, ArrowType.KAROS_ARROW, (EntityLivingBase)this, par1, 1.6f, 12.0f);
                    this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72838_d((Entity)var2);
                }
                ++this.rangedAttackCounter;
                break;
            }
            case RANGED_SLOW: {
                if (this.rangedAttackCounter % 15 == 0) {
                    EntityDivineArrow var4 = new EntityDivineArrow(this.field_70170_p, ArrowType.KAROS_ARROW, (EntityLivingBase)this, par1, 1.6f, 12.0f);
                    this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72838_d((Entity)var4);
                }
                ++this.rangedAttackCounter;
                break;
            }
        }
    }

    public void func_184724_a(boolean b) {
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    private QuadroAbility getRandomAbility() {
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                return QuadroAbility.RANGED_SLOW;
            }
            case 1: {
                return QuadroAbility.RANGED_FAST;
            }
            case 2: {
                return QuadroAbility.MELEE_SLOW;
            }
            case 3: {
                return QuadroAbility.MELEE_FAST;
            }
        }
        return null;
    }

    static enum QuadroAbility {
        RANGED_SLOW(0),
        RANGED_FAST(1),
        MELEE_SLOW(2),
        MELEE_FAST(3);

        private int numVal;

        private QuadroAbility(int numVal) {
            this.numVal = numVal;
        }

        public int value() {
            return this.numVal;
        }
    }
}

