/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss;

import divinerpg.objects.entities.entity.EntityDivineBoss;
import divinerpg.objects.entities.entity.projectiles.EntityRaglokBomb;
import divinerpg.registry.LootTableRegistry;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityRaglok
extends EntityDivineBoss {
    private int ability;
    private final int DEFAULT = 0;
    private final int LIGHTNING = 1;
    private final int BLIND = 2;
    private final int BOMBS = 3;
    private final int SLOW = 4;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int abilityCooldown;
    private boolean loaded = false;
    private int rangedAttackCounter;
    private boolean avengeAbilityUsed = false;

    public EntityRaglok(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 5.0f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_RAGLOK;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.loaded && !this.field_70170_p.field_72995_K) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
            for (EntityPlayer p : players) {
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.raglok.dare", new Object[0]));
            }
            this.func_184185_a(SoundRegistry.RAGLOK_AWAKEN, 1.0f, 1.0f);
            this.loaded = true;
        }
        this.manageAbilities();
    }

    public void manageAbilities() {
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 64.0);
        if (player == null || player.func_184812_l_() || this.avengeAbilityUsed) {
            return;
        }
        if (this.abilityCooldown == 0 || this.ability == 0) {
            this.abilityCooldown = 400;
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    this.ability = 1;
                    this.rangedAttackCounter = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
                    break;
                }
                case 1: {
                    this.ability = 2;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    break;
                }
                case 2: {
                    this.ability = 3;
                    this.rangedAttackCounter = 0;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    break;
                }
                case 3: {
                    this.ability = 4;
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
                    break;
                }
            }
            this.message();
        } else if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == 2 && player != null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 25, 0));
        }
        if (this.ability == 4 && player != null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 10, 1));
        }
        if (this.ability == 1) {
            if (this.abilityCooldown % 40 == 0 && player != null) {
                this.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(this.field_70170_p, this.prevPlayerX, this.prevPlayerY, this.prevPlayerZ, false));
                ++this.rangedAttackCounter;
            } else if (this.abilityCooldown % 40 != 0 && this.abilityCooldown % 20 == 0 && player != null) {
                this.prevPlayerX = player.field_70165_t;
                this.prevPlayerY = player.field_70163_u;
                this.prevPlayerZ = player.field_70161_v;
            }
            if (this.rangedAttackCounter == 10) {
                this.ability = 0;
            }
        }
        if (this.ability == 3) {
            if (this.abilityCooldown % 30 == 0 && player != null) {
                for (int i = 0; i < 4; ++i) {
                    EntityRaglokBomb var2 = new EntityRaglokBomb(this.field_70170_p);
                    var2.func_70107_b(player.field_70165_t, player.field_70163_u + 5.0, player.field_70161_v);
                    var2.field_70159_w = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 5.0;
                    var2.field_70181_x = -0.14;
                    var2.field_70179_y = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 5.0;
                    this.field_70170_p.func_72838_d((Entity)var2);
                    ++this.rangedAttackCounter;
                }
            }
            if (this.rangedAttackCounter == 12) {
                this.ability = 0;
            }
        }
    }

    private void message() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(64.0, 64.0, 64.0));
        block6: for (int var1 = 0; var1 < list.size(); ++var1) {
            if (!(list.get(var1) instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)list.get(var1);
            switch (this.ability) {
                case 1: {
                    this.func_184185_a(SoundRegistry.RAGLOK_GUARDIAN, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.raglok.think", new Object[0]));
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.raglok.great", new Object[0]));
                    continue block6;
                }
                case 2: {
                    this.func_184185_a(SoundRegistry.RAGLOK_DARK, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.raglok.future", new Object[0]));
                    continue block6;
                }
                case 3: {
                    this.func_184185_a(SoundRegistry.RAGLOK_RAIN, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.raglok.rain", new Object[0]));
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.raglok.kill", new Object[0]));
                    continue block6;
                }
                case 4: {
                    this.func_184185_a(SoundRegistry.RAGLOK_NOTHING, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.raglok.compare", new Object[0]));
                    continue block6;
                }
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 1.0f, 1.0f));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.RAGLOK_AVENGE;
    }

    public void func_70609_aI() {
        if (!this.avengeAbilityUsed) {
            EntityPlayer player;
            if (!this.field_70170_p.field_72995_K) {
                List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
                for (EntityPlayer p : players) {
                    p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.raglok.avenge", new Object[0]));
                }
            }
            if ((player = this.field_70170_p.func_72890_a((Entity)this, 64.0)) != null && !player.func_184812_l_()) {
                this.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(this.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, false));
            }
            this.avengeAbilityUsed = true;
        }
        super.func_70609_aI();
    }
}

